/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.benchmark.Atomics;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class MonitoringQueuedThreadPool
extends QueuedThreadPool {
    private final AtomicLong tasks = new AtomicLong();
    private final AtomicLong maxTaskLatency = new AtomicLong();
    private final AtomicLong totalTaskLatency = new AtomicLong();
    private final MonitoringBlockingArrayQueue queue;
    private final AtomicLong maxQueueLatency = new AtomicLong();
    private final AtomicLong totalQueueLatency = new AtomicLong();
    private final AtomicInteger threads = new AtomicInteger();
    private final AtomicInteger maxThreads = new AtomicInteger();

    public MonitoringQueuedThreadPool(int maxThreads) {
        super(maxThreads, maxThreads, 86400000, new MonitoringBlockingArrayQueue(maxThreads, 256));
        this.queue = (MonitoringBlockingArrayQueue)this.getQueue();
        this.setStopTimeout(2000L);
    }

    @Override
    public void execute(final Runnable job) {
        final long begin = System.nanoTime();
        super.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long queueLatency = System.nanoTime() - begin;
                MonitoringQueuedThreadPool.this.tasks.incrementAndGet();
                Atomics.updateMax(MonitoringQueuedThreadPool.this.maxQueueLatency, queueLatency);
                MonitoringQueuedThreadPool.this.totalQueueLatency.addAndGet(queueLatency);
                Atomics.updateMax(MonitoringQueuedThreadPool.this.maxThreads, MonitoringQueuedThreadPool.this.threads.incrementAndGet());
                long start = System.nanoTime();
                try {
                    job.run();
                }
                finally {
                    long taskLatency = System.nanoTime() - start;
                    MonitoringQueuedThreadPool.this.threads.decrementAndGet();
                    Atomics.updateMax(MonitoringQueuedThreadPool.this.maxTaskLatency, taskLatency);
                    MonitoringQueuedThreadPool.this.totalTaskLatency.addAndGet(taskLatency);
                }
            }
        });
    }

    public void reset() {
        this.tasks.set(0L);
        this.maxTaskLatency.set(0L);
        this.totalTaskLatency.set(0L);
        this.queue.reset();
        this.maxQueueLatency.set(0L);
        this.totalQueueLatency.set(0L);
        this.threads.set(0);
        this.maxThreads.set(0);
    }

    public long getTasks() {
        return this.tasks.get();
    }

    public int getMaxActiveThreads() {
        return this.maxThreads.get();
    }

    public int getMaxQueueSize() {
        return this.queue.maxSize.get();
    }

    public long getAverageQueueLatency() {
        long count = this.tasks.get();
        return count == 0L ? -1L : this.totalQueueLatency.get() / count;
    }

    public long getMaxQueueLatency() {
        return this.maxQueueLatency.get();
    }

    public long getMaxTaskLatency() {
        return this.maxTaskLatency.get();
    }

    public long getAverageTaskLatency() {
        long count = this.tasks.get();
        return count == 0L ? -1L : this.totalTaskLatency.get() / count;
    }

    public static class MonitoringBlockingArrayQueue
    extends BlockingArrayQueue<Runnable> {
        private final AtomicInteger size = new AtomicInteger();
        private final AtomicInteger maxSize = new AtomicInteger();

        public MonitoringBlockingArrayQueue(int capacity, int growBy) {
            super(capacity, growBy);
        }

        public void reset() {
            this.size.set(0);
            this.maxSize.set(0);
        }

        @Override
        public void clear() {
            this.reset();
            super.clear();
        }

        @Override
        public boolean offer(Runnable job) {
            boolean added = super.offer(job);
            if (added) {
                this.increment();
            }
            return added;
        }

        private void increment() {
            Atomics.updateMax(this.maxSize, this.size.incrementAndGet());
        }

        @Override
        public Runnable poll() {
            Runnable job = (Runnable)super.poll();
            if (job != null) {
                this.decrement();
            }
            return job;
        }

        @Override
        public Runnable poll(long time, TimeUnit unit) throws InterruptedException {
            Runnable job = (Runnable)super.poll(time, unit);
            if (job != null) {
                this.decrement();
            }
            return job;
        }

        @Override
        public Runnable take() throws InterruptedException {
            Runnable job = (Runnable)super.take();
            this.decrement();
            return job;
        }

        private void decrement() {
            this.size.decrementAndGet();
        }
    }
}

