/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.MessageClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.transport.TransportRegistry;
import org.cometd.common.AbstractClientSession;
import org.cometd.common.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayeuxClient
extends AbstractClientSession
implements Bayeux {
    public static final String BACKOFF_INCREMENT_OPTION = "backoffIncrement";
    public static final String MAX_BACKOFF_OPTION = "maxBackoff";
    public static final String BAYEUX_VERSION = "1.0";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass().getName() + "." + Integer.toHexString(System.identityHashCode(this)));
    private final TransportRegistry transportRegistry = new TransportRegistry();
    private final Map<String, Object> options = new ConcurrentHashMap<String, Object>();
    private final List<Message.Mutable> messageQueue = new ArrayList<Message.Mutable>(32);
    private final CookieStore cookieStore = new CookieManager().getCookieStore();
    private final TransportListener messageListener = new MessageTransportListener();
    private final SessionState sessionState = new SessionState();
    private final String url;
    private ScheduledExecutorService scheduler;
    private long backoffIncrement;
    private long maxBackoff;

    public BayeuxClient(String url, ClientTransport transport, ClientTransport ... transports) {
        this(url, (ScheduledExecutorService)null, transport, transports);
    }

    public BayeuxClient(String url, ScheduledExecutorService scheduler, ClientTransport transport, ClientTransport ... transports) {
        this.url = Objects.requireNonNull(url);
        this.scheduler = scheduler;
        transport = Objects.requireNonNull(transport);
        this.transportRegistry.add(transport);
        for (ClientTransport t : transports) {
            this.transportRegistry.add(t);
        }
        for (String transportName : this.transportRegistry.getKnownTransports()) {
            ClientTransport clientTransport = this.transportRegistry.getTransport(transportName);
            clientTransport.setOption("url", url);
            if (clientTransport instanceof MessageClientTransport) {
                ((MessageClientTransport)((Object)clientTransport)).setMessageTransportListener(this.messageListener);
            }
            if (!(clientTransport instanceof HttpClientTransport)) continue;
            HttpClientTransport httpTransport = (HttpClientTransport)clientTransport;
            httpTransport.setCookieStore(this.cookieStore);
        }
    }

    public String getURL() {
        return this.url;
    }

    public long getBackoffIncrement() {
        return this.backoffIncrement;
    }

    public long getMaxBackoff() {
        return this.maxBackoff;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public HttpCookie getCookie(String name) {
        for (HttpCookie cookie : this.getCookieStore().get(URI.create(this.getURL()))) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public void putCookie(HttpCookie cookie) {
        URI uri = URI.create(this.getURL());
        if (cookie.getPath() == null) {
            String path = uri.getPath();
            path = path == null || !path.contains("/") ? "/" : path.substring(0, path.lastIndexOf("/") + 1);
            cookie.setPath(path);
        }
        if (cookie.getDomain() == null) {
            cookie.setDomain(uri.getHost());
        }
        this.getCookieStore().add(uri, cookie);
    }

    @Override
    public String getId() {
        return this.sessionState.getSessionId();
    }

    @Override
    public boolean isHandshook() {
        State state = this.getState();
        return state == State.HANDSHAKEN || state == State.CONNECTING || state == State.CONNECTED || state == State.UNCONNECTED;
    }

    @Override
    public boolean isConnected() {
        return this.getState() == State.CONNECTED;
    }

    public boolean isDisconnected() {
        State state = this.getState();
        return state == State.TERMINATING || state == State.DISCONNECTED;
    }

    protected State getState() {
        return this.sessionState.getState();
    }

    @Override
    public void handshake() {
        this.handshake(null, null);
    }

    @Override
    public void handshake(Map<String, Object> handshakeFields) {
        this.handshake(handshakeFields, null);
    }

    public void handshake(ClientSessionChannel.MessageListener callback) {
        this.handshake(null, callback);
    }

    @Override
    public void handshake(final Map<String, Object> fields, final ClientSessionChannel.MessageListener callback) {
        if (!this.sessionState.update(State.HANDSHAKING)) {
            throw new IllegalStateException();
        }
        this.sessionState.submit(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.sessionState.handshaking(fields, callback);
            }
        });
    }

    public State handshake(long waitMs) {
        return this.handshake(null, waitMs);
    }

    public State handshake(Map<String, Object> template, long waitMs) {
        this.handshake(template);
        this.waitFor(waitMs, State.CONNECTING, State.CONNECTED, State.DISCONNECTED);
        return this.getState();
    }

    protected boolean sendHandshake() {
        List<ClientTransport> transports = this.transportRegistry.negotiate(this.getAllowedTransports().toArray(), BAYEUX_VERSION);
        ArrayList<String> transportNames = new ArrayList<String>(transports.size());
        for (ClientTransport transport : transports) {
            transportNames.add(transport.getName());
        }
        Message.Mutable message = this.newMessage();
        Map handshakeFields = this.sessionState.getHandshakeFields();
        if (handshakeFields != null) {
            message.putAll(handshakeFields);
        }
        String messageId = this.newMessageId();
        message.setId(messageId);
        message.setChannel("/meta/handshake");
        message.put("supportedConnectionTypes", transportNames);
        message.put("version", BAYEUX_VERSION);
        this.registerCallback(messageId, this.sessionState.getHandshakeCallback());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Handshaking on transport {}: {}", (Object)this.getTransport(), (Object)message);
        }
        ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
        messages.add(message);
        return this.sendMessages(messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(long waitMs, State state, State ... states) {
        ArrayList<State> waitForStates = new ArrayList<State>();
        waitForStates.add(state);
        waitForStates.addAll(Arrays.asList(states));
        SessionState sessionState = this.sessionState;
        synchronized (sessionState) {
            while (waitMs > 0L) {
                if (this.sessionState.isIdle()) {
                    State currentState = this.getState();
                    for (State s : waitForStates) {
                        if (!currentState.implies(s)) continue;
                        return true;
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Waiting {}ms for {}", (Object)waitMs, (Object)waitForStates);
                }
                long start = System.nanoTime();
                if (this.sessionState.await(waitMs)) break;
                long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Waited {}/{}ms for {}, state is {}", new Object[]{elapsed, waitMs, waitForStates, this.sessionState.getState()});
                }
                waitMs -= elapsed;
            }
            return false;
        }
    }

    protected boolean sendConnect() {
        ClientTransport transport = this.getTransport();
        if (transport == null) {
            return false;
        }
        Message.Mutable message = this.newMessage();
        message.setId(this.newMessageId());
        message.setChannel("/meta/connect");
        message.put("connectionType", transport.getName());
        State state = this.getState();
        if (state == State.CONNECTING || state == State.UNCONNECTED) {
            message.getAdvice(true).put("timeout", 0);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connecting, transport {}", (Object)transport);
        }
        ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
        messages.add(message);
        return this.sendMessages(messages);
    }

    @Override
    protected ChannelId newChannelId(String channelId) {
        AbstractClientSession.AbstractSessionChannel channel = (AbstractClientSession.AbstractSessionChannel)this.getChannels().get(channelId);
        return channel == null ? new ChannelId(channelId) : channel.getChannelId();
    }

    @Override
    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new BayeuxClientChannel(channelId);
    }

    @Override
    protected void sendBatch() {
        List<Message.Mutable> messages;
        if (this.canSend() && !(messages = this.takeMessages()).isEmpty()) {
            this.sendMessages(messages);
        }
    }

    protected boolean sendMessages(List<Message.Mutable> messages) {
        Iterator<Message.Mutable> iterator = messages.iterator();
        while (iterator.hasNext()) {
            Message.Mutable message = iterator.next();
            String messageId = message.getId();
            message.setClientId(this.sessionState.sessionId);
            if (this.extendSend(message)) {
                message.setId(messageId);
                continue;
            }
            iterator.remove();
        }
        if (messages.isEmpty()) {
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sending messages {}", (Object)messages);
        }
        return this.sessionState.send(this.messageListener, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message.Mutable> takeMessages() {
        ArrayList<Message.Mutable> messages;
        List<Message.Mutable> list = this.messageQueue;
        synchronized (list) {
            messages = new ArrayList<Message.Mutable>(this.messageQueue);
            this.messageQueue.clear();
        }
        return messages;
    }

    @Override
    public void disconnect() {
        this.disconnect(null);
    }

    @Override
    public void disconnect(final ClientSessionChannel.MessageListener callback) {
        this.sessionState.submit(new Runnable(){

            @Override
            public void run() {
                if (BayeuxClient.this.sessionState.disconnecting()) {
                    Message.Mutable message = BayeuxClient.this.newMessage();
                    String messageId = BayeuxClient.this.newMessageId();
                    message.setId(messageId);
                    message.setChannel("/meta/disconnect");
                    BayeuxClient.this.registerCallback(messageId, callback);
                    ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
                    messages.add(message);
                    BayeuxClient.this.sendMessages(messages);
                }
            }
        });
    }

    public boolean disconnect(long timeout) {
        if (this.isDisconnected()) {
            return true;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        ClientSessionChannel.MessageListener lastConnectListener = new ClientSessionChannel.MessageListener(){

            @Override
            public void onMessage(ClientSessionChannel channel, Message message) {
                Map<String, Object> advice = message.getAdvice();
                if (!message.isSuccessful() || advice != null && "none".equals(advice.get("reconnect"))) {
                    latch.countDown();
                }
            }
        };
        this.getChannel("/meta/connect").addListener(lastConnectListener);
        this.disconnect();
        boolean disconnected = this.waitFor(timeout, State.DISCONNECTED, new State[0]);
        try {
            latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        this.getChannel("/meta/connect").removeListener(lastConnectListener);
        this.sessionState.submit(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.sessionState.terminating();
            }
        });
        return disconnected;
    }

    public void abort() {
        this.sessionState.submit(new Runnable(){

            @Override
            public void run() {
                if (BayeuxClient.this.sessionState.update(State.TERMINATING)) {
                    BayeuxClient.this.sessionState.terminate(true);
                }
            }
        });
    }

    private void processMessages(List<Message.Mutable> messages) {
        block10: for (Message.Mutable message : messages) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Processing {}", (Object)message);
            }
            switch (message.getChannel()) {
                case "/meta/handshake": {
                    this.processHandshake(message);
                    continue block10;
                }
                case "/meta/connect": {
                    this.processConnect(message);
                    continue block10;
                }
                case "/meta/disconnect": {
                    this.processDisconnect(message);
                    continue block10;
                }
            }
            this.processMessage(message);
        }
    }

    protected void messagesFailure(Throwable cause, List<? extends Message> messages) {
        block10: for (Message message : messages) {
            ClientTransport transport;
            Map<String, Object> fields;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Failing {}", (Object)message);
            }
            Message.Mutable failed = this.newMessage();
            failed.setId(message.getId());
            failed.setSuccessful(false);
            failed.setChannel(message.getChannel());
            if (message.containsKey("subscription")) {
                failed.put("subscription", message.get("subscription"));
            }
            HashMap<String, Object> failure = new HashMap<String, Object>();
            failed.put("failure", failure);
            failure.put("message", message);
            if (cause != null) {
                failure.put("exception", cause);
            }
            if (cause instanceof TransportException && (fields = ((TransportException)cause).getFields()) != null) {
                failure.putAll(fields);
            }
            if ((transport = this.getTransport()) != null) {
                failure.put("connectionType", transport.getName());
            }
            switch (message.getChannel()) {
                case "/meta/handshake": {
                    this.handshakeFailure(failed, cause);
                    continue block10;
                }
                case "/meta/connect": {
                    this.connectFailure(failed, cause);
                    continue block10;
                }
                case "/meta/disconnect": {
                    this.disconnectFailure(failed, cause);
                    continue block10;
                }
            }
            this.messageFailure(failed, cause);
        }
    }

    protected void processHandshake(final Message.Mutable handshake) {
        if (handshake.isSuccessful()) {
            ClientTransport oldTransport = this.getTransport();
            Object field = handshake.get("supportedConnectionTypes");
            Object[] serverTransports = field instanceof List ? ((List)field).toArray() : (Object[])field;
            List<ClientTransport> negotiatedTransports = this.transportRegistry.negotiate(serverTransports, BAYEUX_VERSION);
            if (negotiatedTransports.isEmpty()) {
                ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
                failureInfo.transport = null;
                failureInfo.cause = null;
                failureInfo.error = String.format("405:c%s,s%s:no_transport", this.getAllowedTransports(), Arrays.toString(serverTransports));
                failureInfo.action = "none";
                handshake.setSuccessful(false);
                handshake.put("error", failureInfo.error);
                this.failHandshake(handshake, failureInfo);
            } else {
                Number messagesField = (Number)handshake.get("x-messages");
                final int messages = messagesField == null ? 0 : messagesField.intValue();
                final ClientTransport newTransport = negotiatedTransports.get(0);
                if (newTransport != oldTransport) {
                    this.prepareTransport(oldTransport, newTransport);
                }
                this.sessionState.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (BayeuxClient.this.sessionState.handshaken(newTransport, handshake.getAdvice(), handshake.getClientId(), messages)) {
                            BayeuxClient.this.receive(handshake);
                            BayeuxClient.this.sendBatch();
                            if (messages == 0) {
                                BayeuxClient.this.sessionState.connecting();
                            }
                        }
                    }
                });
            }
        } else {
            ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
            failureInfo.transport = this.getTransport();
            failureInfo.cause = null;
            failureInfo.error = null;
            failureInfo.action = this.sessionState.getAdviceAction(handshake.getAdvice(), "handshake");
            this.failHandshake(handshake, failureInfo);
        }
    }

    private void handshakeFailure(Message.Mutable handshake, Throwable failure) {
        ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
        failureInfo.transport = null;
        failureInfo.cause = failure;
        failureInfo.error = null;
        failureInfo.action = "handshake";
        this.failHandshake(handshake, failureInfo);
    }

    private void failHandshake(Message.Mutable handshake, ClientTransport.FailureInfo failureInfo) {
        this.receive(handshake);
        if (this.isDisconnected()) {
            failureInfo.action = "none";
        }
        this.onTransportFailure(handshake, failureInfo, this.sessionState);
    }

    protected void processConnect(Message.Mutable connect) {
        final Map<String, Object> advice = connect.getAdvice();
        if (connect.isSuccessful()) {
            this.receive(connect);
            this.sessionState.submit(new Runnable(){

                @Override
                public void run() {
                    BayeuxClient.this.sessionState.connected(advice);
                }
            });
        } else {
            ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
            failureInfo.transport = this.getTransport();
            failureInfo.cause = null;
            failureInfo.error = null;
            failureInfo.action = this.sessionState.getAdviceAction(advice, "retry");
            this.failConnect(connect, failureInfo);
        }
    }

    private void connectFailure(Message.Mutable connect, Throwable failure) {
        ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
        failureInfo.transport = null;
        failureInfo.cause = failure;
        failureInfo.error = null;
        failureInfo.action = "retry";
        this.failConnect(connect, failureInfo);
    }

    private void failConnect(Message.Mutable connect, ClientTransport.FailureInfo failureInfo) {
        this.receive(connect);
        if (this.isDisconnected()) {
            failureInfo.action = "none";
        }
        this.onTransportFailure(connect, failureInfo, this.sessionState);
    }

    protected void processDisconnect(Message.Mutable disconnect) {
        if (disconnect.isSuccessful()) {
            this.receive(disconnect);
            this.sessionState.submit(new Runnable(){

                @Override
                public void run() {
                    BayeuxClient.this.sessionState.terminating();
                }
            });
        } else {
            this.disconnectFailure(disconnect, null);
        }
    }

    private void disconnectFailure(Message.Mutable disconnect, Throwable failure) {
        ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
        failureInfo.transport = this.getTransport();
        failureInfo.cause = failure;
        failureInfo.error = null;
        failureInfo.action = "none";
        this.failDisconnect(disconnect, failureInfo);
    }

    private void failDisconnect(Message.Mutable disconnect, ClientTransport.FailureInfo failureInfo) {
        this.receive(disconnect);
        this.sessionState.submit(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.sessionState.terminating();
            }
        });
    }

    protected void processMessage(Message.Mutable message) {
        this.receive(message);
        if (this.getState() == State.HANDSHAKEN) {
            this.sessionState.submit(new Runnable(){

                @Override
                public void run() {
                    BayeuxClient.this.sessionState.connecting();
                }
            });
        }
    }

    private void messageFailure(Message.Mutable message, Throwable failure) {
        ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
        failureInfo.transport = this.getTransport();
        failureInfo.cause = failure;
        failureInfo.error = null;
        failureInfo.action = "none";
        this.failMessage(message, failureInfo);
    }

    private void failMessage(Message.Mutable message, ClientTransport.FailureInfo failureInfo) {
        this.receive(message);
    }

    protected boolean scheduleHandshake(long interval, long backOff) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Scheduled handshake in {}+{} ms", (Object)interval, (Object)backOff);
        }
        return this.scheduleAction(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.sendHandshake();
            }
        }, interval, backOff);
    }

    protected boolean scheduleConnect(long interval, long backOff) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Scheduled connect in {}+{} ms", (Object)interval, (Object)backOff);
        }
        return this.scheduleAction(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.sendConnect();
            }
        }, interval, backOff);
    }

    private boolean scheduleAction(Runnable action, long interval, long backoff) {
        ScheduledExecutorService scheduler = this.scheduler;
        if (scheduler != null) {
            try {
                scheduler.schedule(action, interval + backoff, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (RejectedExecutionException x) {
                this.logger.trace("", x);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Could not schedule action {} to scheduler {}", (Object)action, (Object)scheduler);
        }
        return false;
    }

    @Override
    public List<String> getAllowedTransports() {
        return this.transportRegistry.getAllowedTransports();
    }

    @Override
    public Set<String> getKnownTransportNames() {
        return this.transportRegistry.getKnownTransports();
    }

    @Override
    public ClientTransport getTransport(String transport) {
        return this.transportRegistry.getTransport(transport);
    }

    public ClientTransport getTransport() {
        return this.sessionState.getTransport();
    }

    protected void initialize() {
        long maxBackoff;
        long backoffIncrement;
        Number value = (Number)this.getOption(BACKOFF_INCREMENT_OPTION);
        long l = backoffIncrement = value == null ? -1L : value.longValue();
        if (backoffIncrement < 0L) {
            backoffIncrement = 1000L;
        }
        this.backoffIncrement = backoffIncrement;
        value = (Number)this.getOption(MAX_BACKOFF_OPTION);
        long l2 = maxBackoff = value == null ? -1L : value.longValue();
        if (maxBackoff <= 0L) {
            maxBackoff = 30000L;
        }
        this.maxBackoff = maxBackoff;
        if (this.scheduler == null) {
            this.scheduler = new BayeuxClientScheduler();
        }
    }

    protected void terminate() {
        List<Message.Mutable> messages = this.takeMessages();
        this.messagesFailure(null, messages);
        this.cookieStore.removeAll();
        if (this.scheduler instanceof BayeuxClientScheduler) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    @Override
    public Object getOption(String qualifiedName) {
        return this.options.get(qualifiedName);
    }

    @Override
    public void setOption(String qualifiedName, Object value) {
        this.options.put(qualifiedName, value);
        for (String name : this.transportRegistry.getKnownTransports()) {
            ClientTransport transport = this.transportRegistry.getTransport(name);
            transport.setOption(qualifiedName, value);
        }
    }

    @Override
    public Set<String> getOptionNames() {
        return this.options.keySet();
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    protected void send(Message.Mutable message) {
        this.enqueueSend(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueSend(Message.Mutable message) {
        if (this.canSend()) {
            ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
            messages.add(message);
            boolean sent = this.sendMessages(messages);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} message {}", (Object)(sent ? "Sent" : "Failed"), (Object)message);
            }
        } else {
            List<Message.Mutable> list = this.messageQueue;
            synchronized (list) {
                this.messageQueue.add(message);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Enqueued message {} (batching: {})", (Object)message, (Object)this.isBatching());
            }
        }
    }

    private boolean canSend() {
        State state = this.getState();
        boolean handshaking = state == State.HANDSHAKING || state == State.REHANDSHAKING;
        return !this.isBatching() && !handshaking;
    }

    public void onSending(List<? extends Message> messages) {
    }

    public void onMessages(List<Message.Mutable> messages) {
    }

    public void onFailure(Throwable failure, List<? extends Message> messages) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Messages failed " + messages, failure);
        }
    }

    private void prepareTransport(ClientTransport oldTransport, ClientTransport newTransport) {
        if (oldTransport != null) {
            oldTransport.terminate();
        }
        newTransport.init();
    }

    protected void onTransportFailure(Message message, ClientTransport.FailureInfo failureInfo, ClientTransport.FailureHandler handler) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Transport failure: {} for {}", (Object)failureInfo, (Object)message);
        }
        if ("none".equals(failureInfo.action)) {
            if ("/meta/handshake".equals(message.getChannel()) && failureInfo.transport == null) {
                this.onTransportFailure(this.getTransport().getName(), null, failureInfo.cause);
            }
        } else {
            failureInfo.delay = this.sessionState.getBackOff();
            if ("/meta/handshake".equals(message.getChannel())) {
                if (failureInfo.transport == null) {
                    List<ClientTransport> transports = this.transportRegistry.negotiate(this.getAllowedTransports().toArray(), BAYEUX_VERSION);
                    if (transports.isEmpty()) {
                        this.onTransportFailure(this.getTransport().getName(), null, failureInfo.cause);
                        failureInfo.action = "none";
                    } else {
                        ClientTransport oldTransport = this.getTransport();
                        ClientTransport newTransport = transports.get(0);
                        if (newTransport != oldTransport) {
                            this.prepareTransport(oldTransport, newTransport);
                        }
                        this.onTransportFailure(oldTransport.getName(), newTransport.getName(), failureInfo.cause);
                        failureInfo.transport = newTransport;
                        failureInfo.action = "handshake";
                    }
                }
                if (!"none".equals(failureInfo.action)) {
                    this.sessionState.increaseBackOff();
                }
            } else {
                this.sessionState.initUnconnectTime();
                if ("retry".equals(failureInfo.action)) {
                    failureInfo.delay = this.sessionState.increaseBackOff();
                    if (this.sessionState.nextConnectExceedsMaxInterval()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Switching to handshake retries");
                        }
                        failureInfo.action = "handshake";
                    }
                }
                if ("handshake".equals(failureInfo.action)) {
                    failureInfo.delay = 0L;
                    this.sessionState.resetBackOff();
                }
            }
        }
        handler.handle(failureInfo);
    }

    protected void onTransportFailure(String oldTransportName, String newTransportName, Throwable failure) {
    }

    private static class BayeuxClientScheduler
    extends ScheduledThreadPoolExecutor {
        public BayeuxClientScheduler() {
            super(1);
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.setRemoveOnCancelPolicy(true);
        }
    }

    private class SessionState
    implements ClientTransport.FailureHandler {
        private final Queue<Runnable> actions = new ArrayDeque<Runnable>();
        private State state = State.DISCONNECTED;
        private ClientTransport transport;
        private Map<String, Object> handshakeFields;
        private ClientSessionChannel.MessageListener handshakeCallback;
        private Map<String, Object> advice;
        private String sessionId;
        private long backOff;
        private long unconnectTime;
        private boolean active;
        private int handshakeMessages;

        private SessionState() {
        }

        private void reset() {
            this.actions.clear();
            this.state = State.DISCONNECTED;
            this.transport = null;
            this.handshakeFields = null;
            this.handshakeCallback = null;
            this.advice = null;
            this.sessionId = null;
            this.backOff = 0L;
            this.unconnectTime = 0L;
            this.active = false;
            this.handshakeMessages = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private State getState() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.state;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClientTransport getTransport() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.transport;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> getHandshakeFields() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.handshakeFields;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClientSessionChannel.MessageListener getHandshakeCallback() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.handshakeCallback;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> getAdvice() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.advice;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getSessionId() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.sessionId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getBackOff() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.backOff;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getUnconnectTime() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                if (this.unconnectTime == 0L) {
                    return 0L;
                }
                return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.unconnectTime);
            }
        }

        private long getTimeout() {
            return this.getAdviceLong("timeout");
        }

        private long getInterval() {
            return this.getAdviceLong("interval");
        }

        private long getMaxInterval() {
            return this.getAdviceLong("maxInterval");
        }

        private String getAdviceAction(Map<String, Object> advice, String defaultAction) {
            String result = null;
            if (advice == null) {
                advice = this.getAdvice();
            }
            if (advice != null) {
                result = (String)advice.get("reconnect");
            }
            return result == null ? defaultAction : result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getAdviceLong(String field) {
            SessionState sessionState = this;
            synchronized (sessionState) {
                long result = 0L;
                if (this.advice != null && this.advice.containsKey(field)) {
                    result = ((Number)this.advice.get(field)).longValue();
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long nextBackOff() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return Math.min(this.backOff + BayeuxClient.this.getBackoffIncrement(), BayeuxClient.this.getMaxBackoff());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long increaseBackOff() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                this.backOff = this.nextBackOff();
                return this.backOff;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetBackOff() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                this.backOff = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handshaking(Map<String, Object> fields, ClientSessionChannel.MessageListener callback) {
            BayeuxClient.this.initialize();
            List<String> allowedTransports = BayeuxClient.this.getAllowedTransports();
            ClientTransport transport = BayeuxClient.this.transportRegistry.negotiate(allowedTransports.toArray(), BayeuxClient.BAYEUX_VERSION).get(0);
            BayeuxClient.this.prepareTransport(null, transport);
            if (BayeuxClient.this.logger.isDebugEnabled()) {
                BayeuxClient.this.logger.debug("Using initial transport {} from {}", (Object)transport.getName(), (Object)allowedTransports);
            }
            SessionState sessionState = this;
            synchronized (sessionState) {
                this.transport = transport;
                this.handshakeFields = fields;
                this.handshakeCallback = callback;
            }
            BayeuxClient.this.resetSubscriptions();
            BayeuxClient.this.sendHandshake();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean rehandshaking(long backOff) {
            boolean result;
            State oldState;
            SessionState sessionState = this;
            synchronized (sessionState) {
                oldState = this.state;
                result = BayeuxClient.this.sessionState.update(State.REHANDSHAKING);
            }
            if (result) {
                if (oldState != State.HANDSHAKING) {
                    BayeuxClient.this.resetSubscriptions();
                }
                BayeuxClient.this.scheduleHandshake(this.getInterval(), backOff);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handshaken(ClientTransport transport, Map<String, Object> advice, String sessionId, int messages) {
            SessionState sessionState = this;
            synchronized (sessionState) {
                if (this.update(State.HANDSHAKEN)) {
                    this.transport = transport;
                    this.advice = advice;
                    this.sessionId = sessionId;
                    this.handshakeMessages = messages;
                    this.backOff = 0L;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean connecting() {
            boolean result = false;
            SessionState sessionState = this;
            synchronized (sessionState) {
                if (this.handshakeMessages > 0) {
                    --this.handshakeMessages;
                }
                if (this.handshakeMessages == 0) {
                    result = BayeuxClient.this.sessionState.update(State.CONNECTING);
                }
            }
            if (result) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), 0L);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean connected(Map<String, Object> advice) {
            boolean result;
            long backOff;
            SessionState sessionState = this;
            synchronized (sessionState) {
                backOff = this.backOff;
                result = this.update(State.CONNECTED);
                if (result) {
                    this.unconnectTime = 0L;
                    if (advice != null) {
                        this.advice = advice;
                    }
                }
            }
            if (result) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), backOff);
            }
            return result;
        }

        private boolean unconnected(long backOff) {
            boolean result = this.update(State.UNCONNECTED);
            if (result) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), backOff);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean nextConnectExceedsMaxInterval() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                long maxInterval = this.getMaxInterval();
                if (maxInterval > 0L) {
                    long expiration = this.getTimeout() + this.getInterval() + maxInterval;
                    return this.getUnconnectTime() + this.getBackOff() > expiration;
                }
                return false;
            }
        }

        private boolean disconnecting() {
            return this.update(State.DISCONNECTING);
        }

        private void terminating() {
            if (this.update(State.TERMINATING)) {
                this.terminate(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean update(State newState) {
            SessionState sessionState = this;
            synchronized (sessionState) {
                State oldState = this.state;
                boolean result = this.state.isUpdateableTo(newState);
                if (result) {
                    this.state = newState;
                }
                if (BayeuxClient.this.logger.isDebugEnabled()) {
                    BayeuxClient.this.logger.debug("State {}updated: {} -> {}", new Object[]{result ? "" : "not ", oldState, newState});
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate(boolean abort) {
            if (abort) {
                this.transport.abort();
            } else {
                this.transport.terminate();
            }
            BayeuxClient.this.terminate();
            SessionState sessionState = this;
            synchronized (sessionState) {
                this.update(State.DISCONNECTED);
                this.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void submit(Runnable action) {
            boolean empty;
            SessionState sessionState = this;
            synchronized (sessionState) {
                empty = this.actions.isEmpty();
                this.actions.offer(action);
            }
            if (empty && this.process()) {
                sessionState = this;
                synchronized (sessionState) {
                    if (BayeuxClient.this.logger.isDebugEnabled()) {
                        BayeuxClient.this.logger.debug("Notifying threads in waitFor()");
                    }
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean process() {
            boolean looping = false;
            while (true) {
                Runnable action;
                SessionState sessionState = this;
                synchronized (sessionState) {
                    if (!looping && this.active) {
                        return false;
                    }
                    action = this.actions.poll();
                    if (action == null) {
                        this.active = false;
                        return true;
                    }
                    if (!looping) {
                        looping = true;
                        this.active = true;
                    }
                }
                action.run();
            }
        }

        private boolean send(TransportListener messageListener, List<Message.Mutable> messages) {
            if (BayeuxClient.this.isDisconnected()) {
                BayeuxClient.this.messagesFailure(new TransportException(null), messages);
                return false;
            }
            this.transport.send(messageListener, messages);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isIdle() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return !this.active;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean await(long time) {
            SessionState sessionState = this;
            synchronized (sessionState) {
                try {
                    this.wait(time);
                    return false;
                }
                catch (InterruptedException x) {
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initUnconnectTime() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                if (this.unconnectTime == 0L) {
                    this.unconnectTime = System.nanoTime();
                }
            }
        }

        @Override
        public void handle(final ClientTransport.FailureInfo failureInfo) {
            if (BayeuxClient.this.logger.isDebugEnabled()) {
                BayeuxClient.this.logger.debug("Transport failure handling: {}", (Object)failureInfo);
            }
            this.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    State newState = failureInfo.actionToState();
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        String url;
                        ClientTransport newTransport = failureInfo.transport;
                        if (newTransport != null) {
                            SessionState.this.transport = newTransport;
                        }
                        if ((url = failureInfo.url) != null) {
                            SessionState.this.transport.setURL(url);
                        }
                    }
                    switch (newState) {
                        case REHANDSHAKING: {
                            SessionState.this.rehandshaking(failureInfo.delay);
                            break;
                        }
                        case UNCONNECTED: {
                            SessionState.this.unconnected(failureInfo.delay);
                            break;
                        }
                        case TERMINATING: {
                            SessionState.this.terminating();
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            });
        }
    }

    protected class BayeuxClientChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected BayeuxClientChannel(ChannelId channelId) {
            super(BayeuxClient.this, channelId);
        }

        @Override
        public ClientSession getSession() {
            this.throwIfReleased();
            return BayeuxClient.this;
        }
    }

    private class MessageTransportListener
    implements TransportListener {
        private MessageTransportListener() {
        }

        @Override
        public void onSending(List<? extends Message> messages) {
            BayeuxClient.this.onSending(messages);
        }

        @Override
        public void onMessages(List<Message.Mutable> messages) {
            BayeuxClient.this.onMessages(messages);
            BayeuxClient.this.processMessages(messages);
        }

        @Override
        public void onFailure(Throwable failure, List<? extends Message> messages) {
            BayeuxClient.this.onFailure(failure, messages);
            BayeuxClient.this.messagesFailure(failure, messages);
        }
    }

    public static enum State {
        UNCONNECTED(new State[0]),
        HANDSHAKING(new State[0]),
        REHANDSHAKING(new State[0]),
        HANDSHAKEN(HANDSHAKING, REHANDSHAKING),
        CONNECTING(HANDSHAKING, REHANDSHAKING, HANDSHAKEN),
        CONNECTED(HANDSHAKING, REHANDSHAKING, HANDSHAKEN, CONNECTING),
        DISCONNECTING(new State[0]),
        TERMINATING(DISCONNECTING),
        DISCONNECTED(DISCONNECTING, TERMINATING);

        private final State[] implieds;

        private State(State ... implieds) {
            this.implieds = implieds;
        }

        private boolean implies(State state) {
            if (state == this) {
                return true;
            }
            for (State implied : this.implieds) {
                if (state != implied) continue;
                return true;
            }
            return false;
        }

        private boolean isUpdateableTo(State newState) {
            switch (this) {
                case DISCONNECTED: {
                    return newState == HANDSHAKING;
                }
                case HANDSHAKING: 
                case REHANDSHAKING: {
                    return EnumSet.of(REHANDSHAKING, HANDSHAKEN, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case HANDSHAKEN: {
                    return EnumSet.of(CONNECTING, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case CONNECTING: 
                case CONNECTED: 
                case UNCONNECTED: {
                    return EnumSet.of(REHANDSHAKING, CONNECTED, UNCONNECTED, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case DISCONNECTING: {
                    return newState == TERMINATING;
                }
                case TERMINATING: {
                    return newState == DISCONNECTED;
                }
            }
            throw new IllegalStateException();
        }
    }
}

