/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.ext;

import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;

public class AckExtension
extends ClientSession.Extension.Adapter {
    public static final String ACK_FIELD = "ack";
    private boolean _serverSupportsAcks;
    private long _transientBatch;
    private int _size;
    private long _batch;

    @Override
    public boolean rcvMeta(ClientSession session, Message.Mutable message) {
        Object ack;
        Map<String, Object> ext;
        if ("/meta/handshake".equals(message.getChannel())) {
            Map<String, Object> ext2 = message.getExt(false);
            if (ext2 != null) {
                Object field = ext2.get(ACK_FIELD);
                if (field instanceof Map) {
                    Map ack2 = (Map)field;
                    this._serverSupportsAcks = Boolean.TRUE.equals(ack2.get("enabled"));
                    Object batch = ack2.get("batch");
                    Object size = ack2.get("size");
                    if (batch instanceof Number && size instanceof Number) {
                        this._transientBatch = ((Number)batch).longValue();
                        this._size = ((Number)size).intValue();
                    }
                } else {
                    this._serverSupportsAcks = Boolean.TRUE.equals(field);
                }
            }
        } else if ("/meta/connect".equals(message.getChannel()) && message.isSuccessful() && this._serverSupportsAcks && (ext = message.getExt(false)) != null && (ack = ext.get(ACK_FIELD)) instanceof Number) {
            this._batch = ((Number)ack).longValue();
        }
        return true;
    }

    @Override
    public boolean rcv(ClientSession session, Message.Mutable message) {
        if (this._size > 0) {
            --this._size;
            if (this._size == 0) {
                this._batch = this._transientBatch;
                this._transientBatch = 0L;
            }
        }
        return true;
    }

    @Override
    public boolean sendMeta(ClientSession session, Message.Mutable message) {
        if ("/meta/handshake".equals(message.getChannel())) {
            this._serverSupportsAcks = false;
            this._transientBatch = 0L;
            this._batch = 0L;
            this._size = 0;
            message.getExt(true).put(ACK_FIELD, Boolean.TRUE);
        } else if ("/meta/connect".equals(message.getChannel()) && this._serverSupportsAcks) {
            message.getExt(true).put(ACK_FIELD, this._batch);
        }
        return true;
    }
}

