/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.common.HashMapMessage;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientSession
implements ClientSession,
Dumpable {
    private static final Logger logger = LoggerFactory.getLogger(ClientSession.class);
    private static final AtomicLong _idGen = new AtomicLong(0L);
    private final List<ClientSession.Extension> _extensions = new CopyOnWriteArrayList<ClientSession.Extension>();
    private final AttributesMap _attributes = new AttributesMap();
    private final ConcurrentMap<String, AbstractSessionChannel> _channels = new ConcurrentHashMap<String, AbstractSessionChannel>();
    private final Map<String, ClientSessionChannel.MessageListener> _callbacks = new ConcurrentHashMap<String, ClientSessionChannel.MessageListener>();
    private final Map<String, ClientSessionChannel.MessageListener> _subscribers = new ConcurrentHashMap<String, ClientSessionChannel.MessageListener>();
    private final Map<String, ClientSession.MessageListener> _remoteCalls = new ConcurrentHashMap<String, ClientSession.MessageListener>();
    private final AtomicInteger _batch = new AtomicInteger();

    protected AbstractClientSession() {
    }

    protected String newMessageId() {
        return String.valueOf(_idGen.incrementAndGet());
    }

    @Override
    public void addExtension(ClientSession.Extension extension) {
        this._extensions.add(extension);
    }

    @Override
    public void removeExtension(ClientSession.Extension extension) {
        this._extensions.remove(extension);
    }

    @Override
    public List<ClientSession.Extension> getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    protected boolean extendSend(Message.Mutable message) {
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.sendMeta(this, message)) continue;
                return false;
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.send(this, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean extendRcv(Message.Mutable message) {
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.rcvMeta(this, message)) continue;
                return false;
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.rcv(this, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract ChannelId newChannelId(String var1);

    protected abstract AbstractSessionChannel newChannel(ChannelId var1);

    @Override
    public ClientSessionChannel getChannel(String channelName) {
        return this.getChannel(channelName, null);
    }

    public ClientSessionChannel getChannel(ChannelId channelId) {
        return this.getChannel(channelId.getId(), channelId);
    }

    private ClientSessionChannel getChannel(String channelName, ChannelId channelId) {
        AbstractSessionChannel channel = (AbstractSessionChannel)this._channels.get(channelName);
        if (channel == null) {
            AbstractSessionChannel newChannel;
            if (channelId == null) {
                channelId = this.newChannelId(channelName);
            }
            if ((channel = this._channels.putIfAbsent(channelName, newChannel = this.newChannel(channelId))) == null) {
                channel = newChannel;
            }
        }
        return channel;
    }

    protected ConcurrentMap<String, AbstractSessionChannel> getChannels() {
        return this._channels;
    }

    @Override
    public void startBatch() {
        this._batch.incrementAndGet();
    }

    protected abstract void sendBatch();

    @Override
    public boolean endBatch() {
        if (this._batch.decrementAndGet() == 0) {
            this.sendBatch();
            return true;
        }
        return false;
    }

    @Override
    public void batch(Runnable batch) {
        this.startBatch();
        try {
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    protected boolean isBatching() {
        return this._batch.get() > 0;
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    @Override
    public Object removeAttribute(String name) {
        Object old = this._attributes.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    @Override
    public void remoteCall(String target, Object data, ClientSession.MessageListener callback) {
        if (!target.startsWith("/")) {
            target = "/" + target;
        }
        String channelName = "/service" + target;
        Message.Mutable message = this.newMessage();
        String messageId = this.newMessageId();
        message.setId(messageId);
        message.setChannel(channelName);
        message.setData(data);
        this._remoteCalls.put(messageId, callback);
        this.send(message);
    }

    protected abstract void send(Message.Mutable var1);

    protected Message.Mutable newMessage() {
        return new HashMapMessage();
    }

    protected void resetSubscriptions() {
        for (AbstractSessionChannel ch : this._channels.values()) {
            ch.resetSubscriptions();
        }
    }

    public void receive(Message.Mutable message) {
        String channelName = message.getChannel();
        if (channelName == null) {
            throw new IllegalArgumentException("Bayeux messages must have a channel, " + message);
        }
        if ("/meta/subscribe".equals(channelName)) {
            ClientSessionChannel.MessageListener subscriber = this.unregisterSubscriber(message.getId());
            if (!message.isSuccessful()) {
                String subscription = (String)message.get("subscription");
                MarkedReference<AbstractSessionChannel> channelRef = this.getReleasableChannel(subscription);
                AbstractSessionChannel channel = channelRef.getReference();
                channel.removeSubscription(subscriber);
                if (channelRef.isMarked()) {
                    channel.release();
                }
            }
        }
        if (!this.extendRcv(message)) {
            return;
        }
        if (this.handleRemoteCall(message)) {
            return;
        }
        this.notifyListeners(message);
    }

    private boolean handleRemoteCall(Message.Mutable message) {
        ClientSession.MessageListener listener;
        String messageId = message.getId();
        if (messageId != null && (listener = this._remoteCalls.remove(messageId)) != null) {
            this.notifyMessageListener(listener, message);
            return true;
        }
        return false;
    }

    private void notifyMessageListener(ClientSession.MessageListener listener, Message.Mutable message) {
        try {
            listener.onMessage(message);
        }
        catch (Throwable x) {
            logger.info("Exception while invoking listener " + listener, x);
        }
    }

    protected void notifyListeners(Message.Mutable message) {
        String messageId;
        ClientSessionChannel.MessageListener callback;
        if ((message.isMeta() || message.isPublishReply()) && (callback = this.unregisterCallback(messageId = message.getId())) != null) {
            this.notifyListener(callback, message);
        }
        MarkedReference<AbstractSessionChannel> channelRef = this.getReleasableChannel(message.getChannel());
        AbstractSessionChannel channel = channelRef.getReference();
        channel.notifyMessageListeners(message);
        if (channelRef.isMarked()) {
            channel.release();
        }
        ChannelId channelId = channel.getChannelId();
        for (String wildChannelName : channelId.getWilds()) {
            MarkedReference<AbstractSessionChannel> wildChannelRef = this.getReleasableChannel(wildChannelName);
            AbstractSessionChannel wildChannel = wildChannelRef.getReference();
            wildChannel.notifyMessageListeners(message);
            if (!wildChannelRef.isMarked()) continue;
            wildChannel.release();
        }
    }

    protected void notifyListener(ClientSessionChannel.MessageListener listener, Message.Mutable message) {
        MarkedReference<AbstractSessionChannel> channelRef = this.getReleasableChannel(message.getChannel());
        AbstractSessionChannel channel = channelRef.getReference();
        channel.notifyOnMessage(listener, message);
        if (channelRef.isMarked()) {
            channel.release();
        }
    }

    private MarkedReference<AbstractSessionChannel> getReleasableChannel(String id) {
        AbstractSessionChannel channel;
        AbstractSessionChannel abstractSessionChannel = channel = ChannelId.isMeta(id) ? (AbstractSessionChannel)this.getChannel(id) : (AbstractSessionChannel)this.getChannels().get(id);
        if (channel != null) {
            return new MarkedReference<AbstractSessionChannel>(channel, false);
        }
        return new MarkedReference<AbstractSessionChannel>(this.newChannel(this.newChannelId(id)), true);
    }

    protected void registerCallback(String messageId, ClientSessionChannel.MessageListener callback) {
        if (callback != null) {
            this._callbacks.put(messageId, callback);
        }
    }

    protected ClientSessionChannel.MessageListener unregisterCallback(String messageId) {
        if (messageId == null) {
            return null;
        }
        return this._callbacks.remove(messageId);
    }

    protected void registerSubscriber(String messageId, ClientSessionChannel.MessageListener subscriber) {
        if (subscriber != null) {
            this._subscribers.put(messageId, subscriber);
        }
    }

    protected ClientSessionChannel.MessageListener unregisterSubscriber(String messageId) {
        if (messageId == null) {
            return null;
        }
        return this._subscribers.remove(messageId);
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject(out, this);
        ArrayList<1> children = new ArrayList<1>();
        children.add(new Dumpable(){

            @Override
            public String dump() {
                return null;
            }

            @Override
            public void dump(Appendable out, String indent) throws IOException {
                Collection channels = AbstractClientSession.this.getChannels().values();
                ContainerLifeCycle.dumpObject(out, "channels: " + channels.size());
                ContainerLifeCycle.dump(out, indent, channels);
            }
        });
        ContainerLifeCycle.dump(out, indent, children);
    }

    protected abstract class AbstractSessionChannel
    implements ClientSessionChannel,
    Dumpable {
        private final ChannelId _id;
        private final AttributesMap _attributes = new AttributesMap();
        private final CopyOnWriteArrayList<ClientSessionChannel.MessageListener> _subscriptions = new CopyOnWriteArrayList();
        private final AtomicInteger _subscriptionCount = new AtomicInteger();
        private final CopyOnWriteArrayList<ClientSessionChannel.ClientSessionChannelListener> _listeners = new CopyOnWriteArrayList();
        private volatile boolean _released;

        protected AbstractSessionChannel(ChannelId id) {
            this._id = id;
        }

        @Override
        public ChannelId getChannelId() {
            return this._id;
        }

        @Override
        public void addListener(ClientSessionChannel.ClientSessionChannelListener listener) {
            this.throwIfReleased();
            this._listeners.add(listener);
        }

        @Override
        public void removeListener(ClientSessionChannel.ClientSessionChannelListener listener) {
            this.throwIfReleased();
            this._listeners.remove(listener);
        }

        @Override
        public List<ClientSessionChannel.ClientSessionChannelListener> getListeners() {
            return Collections.unmodifiableList(this._listeners);
        }

        @Override
        public void publish(Object data) {
            this.publish(data, null);
        }

        @Override
        public void publish(Object data, ClientSessionChannel.MessageListener callback) {
            if (data instanceof Message.Mutable) {
                this.publish((Message.Mutable)data, callback);
            } else {
                Message.Mutable message = AbstractClientSession.this.newMessage();
                message.setData(data);
                this.publish(message, callback);
            }
        }

        @Override
        public void publish(Message.Mutable message, ClientSessionChannel.MessageListener callback) {
            this.throwIfReleased();
            String messageId = AbstractClientSession.this.newMessageId();
            message.setId(messageId);
            message.setChannel(this.getId());
            AbstractClientSession.this.registerCallback(messageId, callback);
            AbstractClientSession.this.send(message);
        }

        @Override
        public void subscribe(ClientSessionChannel.MessageListener listener) {
            this.subscribe(listener, null);
        }

        @Override
        public void subscribe(ClientSessionChannel.MessageListener listener, ClientSessionChannel.MessageListener callback) {
            int count;
            this.throwIfReleased();
            boolean added = this._subscriptions.add(listener);
            if (added && (count = this._subscriptionCount.incrementAndGet()) == 1) {
                this.sendSubscribe(listener, callback);
            }
        }

        protected void sendSubscribe(ClientSessionChannel.MessageListener listener, ClientSessionChannel.MessageListener callback) {
            Message.Mutable message = AbstractClientSession.this.newMessage();
            String messageId = AbstractClientSession.this.newMessageId();
            message.setId(messageId);
            message.setChannel("/meta/subscribe");
            message.put("subscription", this.getId());
            AbstractClientSession.this.registerSubscriber(messageId, listener);
            AbstractClientSession.this.registerCallback(messageId, callback);
            AbstractClientSession.this.send(message);
        }

        @Override
        public void unsubscribe(ClientSessionChannel.MessageListener listener) {
            this.unsubscribe(listener, null);
        }

        @Override
        public void unsubscribe(ClientSessionChannel.MessageListener listener, ClientSessionChannel.MessageListener callback) {
            boolean removedLast = this.removeSubscription(listener);
            if (removedLast) {
                this.sendUnSubscribe(callback);
            }
        }

        private boolean removeSubscription(ClientSessionChannel.MessageListener listener) {
            this.throwIfReleased();
            boolean removed = this._subscriptions.remove(listener);
            if (removed) {
                return this._subscriptionCount.decrementAndGet() == 0;
            }
            return false;
        }

        protected void sendUnSubscribe(ClientSessionChannel.MessageListener callback) {
            Message.Mutable message = AbstractClientSession.this.newMessage();
            String messageId = AbstractClientSession.this.newMessageId();
            message.setId(messageId);
            message.setChannel("/meta/unsubscribe");
            message.put("subscription", this.getId());
            AbstractClientSession.this.registerCallback(messageId, callback);
            AbstractClientSession.this.send(message);
        }

        @Override
        public void unsubscribe() {
            this.throwIfReleased();
            for (ClientSessionChannel.MessageListener listener : this._subscriptions) {
                this.unsubscribe(listener);
            }
        }

        @Override
        public List<ClientSessionChannel.MessageListener> getSubscribers() {
            return Collections.unmodifiableList(this._subscriptions);
        }

        @Override
        public boolean release() {
            if (this._released) {
                return false;
            }
            if (this._subscriptions.isEmpty() && this._listeners.isEmpty()) {
                boolean removed;
                this._released = removed = AbstractClientSession.this._channels.remove(this.getId(), this);
                return removed;
            }
            return false;
        }

        @Override
        public boolean isReleased() {
            return this._released;
        }

        protected void resetSubscriptions() {
            this.throwIfReleased();
            for (ClientSessionChannel.MessageListener l : this._subscriptions) {
                if (!this._subscriptions.remove(l)) continue;
                this._subscriptionCount.decrementAndGet();
            }
        }

        @Override
        public String getId() {
            return this._id.getId();
        }

        @Override
        public boolean isDeepWild() {
            return this._id.isDeepWild();
        }

        @Override
        public boolean isMeta() {
            return this._id.isMeta();
        }

        @Override
        public boolean isService() {
            return this._id.isService();
        }

        @Override
        public boolean isBroadcast() {
            return !this.isMeta() && !this.isService();
        }

        @Override
        public boolean isWild() {
            return this._id.isWild();
        }

        protected void notifyMessageListeners(Message message) {
            this.throwIfReleased();
            for (ClientSessionChannel.ClientSessionChannelListener clientSessionChannelListener : this._listeners) {
                if (!(clientSessionChannelListener instanceof ClientSessionChannel.MessageListener)) continue;
                this.notifyOnMessage((ClientSessionChannel.MessageListener)clientSessionChannelListener, message);
            }
            for (ClientSessionChannel.ClientSessionChannelListener clientSessionChannelListener : this._subscriptions) {
                if (!(clientSessionChannelListener instanceof ClientSessionChannel.MessageListener) || message.isPublishReply()) continue;
                this.notifyOnMessage((ClientSessionChannel.MessageListener)clientSessionChannelListener, message);
            }
        }

        protected void notifyOnMessage(ClientSessionChannel.MessageListener listener, Message message) {
            this.throwIfReleased();
            try {
                listener.onMessage(this, message);
            }
            catch (Throwable x) {
                logger.info("Exception while invoking listener " + listener, x);
            }
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.throwIfReleased();
            this._attributes.setAttribute(name, value);
        }

        @Override
        public Object getAttribute(String name) {
            this.throwIfReleased();
            return this._attributes.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNames() {
            this.throwIfReleased();
            return this._attributes.getAttributeNameSet();
        }

        @Override
        public Object removeAttribute(String name) {
            this.throwIfReleased();
            Object old = this.getAttribute(name);
            this._attributes.removeAttribute(name);
            return old;
        }

        protected void throwIfReleased() {
            if (this.isReleased()) {
                throw new IllegalStateException("Channel " + this + " has been released");
            }
        }

        @Override
        public String dump() {
            return ContainerLifeCycle.dump(this);
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            ContainerLifeCycle.dumpObject(out, this);
            ArrayList<Dumpable> children = new ArrayList<Dumpable>();
            children.add(new Dumpable(){

                @Override
                public String dump() {
                    return null;
                }

                @Override
                public void dump(Appendable out, String indent) throws IOException {
                    List<ClientSessionChannel.ClientSessionChannelListener> listeners = AbstractSessionChannel.this.getListeners();
                    ContainerLifeCycle.dumpObject(out, "listeners: " + listeners.size());
                    ContainerLifeCycle.dump(out, indent, listeners);
                }
            });
            children.add(new Dumpable(){

                @Override
                public String dump() {
                    return null;
                }

                @Override
                public void dump(Appendable out, String indent) throws IOException {
                    List<ClientSessionChannel.MessageListener> subscribers = AbstractSessionChannel.this.getSubscribers();
                    ContainerLifeCycle.dumpObject(out, "subscribers: " + subscribers.size());
                    ContainerLifeCycle.dump(out, indent, subscribers);
                }
            });
            ContainerLifeCycle.dump(out, indent, children);
        }

        public String toString() {
            return String.format("%s@%s", this._id, AbstractClientSession.this);
        }
    }
}

