/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.jsr356.DecoderFactory;
import org.eclipse.jetty.websocket.jsr356.EncoderFactory;
import org.eclipse.jetty.websocket.jsr356.JsrExtension;
import org.eclipse.jetty.websocket.jsr356.JsrExtensionConfig;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.JsrSessionFactory;
import org.eclipse.jetty.websocket.jsr356.JsrUpgradeListener;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointScanner;
import org.eclipse.jetty.websocket.jsr356.client.AnnotatedClientEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.client.EmptyClientEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.client.SimpleEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.decoders.PrimitiveDecoderMetadataSet;
import org.eclipse.jetty.websocket.jsr356.encoders.PrimitiveEncoderMetadataSet;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.endpoints.JsrEventDriverFactory;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;

public class ClientContainer
extends ContainerLifeCycle
implements WebSocketContainer,
SessionListener {
    private static final Logger LOG = Log.getLogger(ClientContainer.class);
    private final DecoderFactory decoderFactory;
    private final EncoderFactory encoderFactory;
    private final Map<Class<?>, EndpointMetadata> endpointClientMetadataCache;
    private Set<Session> openSessions = new CopyOnWriteArraySet<Session>();
    private WebSocketClient client;

    public ClientContainer() {
        this(null);
        this.client.setDaemon(true);
    }

    public ClientContainer(Executor executor) {
        this.endpointClientMetadataCache = new ConcurrentHashMap();
        this.decoderFactory = new DecoderFactory(PrimitiveDecoderMetadataSet.INSTANCE);
        this.encoderFactory = new EncoderFactory(PrimitiveEncoderMetadataSet.INSTANCE);
        EmptyClientEndpointConfig empty = new EmptyClientEndpointConfig();
        this.decoderFactory.init(empty);
        this.encoderFactory.init(empty);
        boolean trustAll = Boolean.getBoolean("org.eclipse.jetty.websocket.jsr356.ssl-trust-all");
        this.client = new WebSocketClient(new SslContextFactory(trustAll), executor);
        this.client.setEventDriverFactory(new JsrEventDriverFactory(this.client.getPolicy()));
        this.client.setSessionFactory(new JsrSessionFactory(this, this, this.client));
        this.addBean(this.client);
        ShutdownThread.register(this);
    }

    private Session connect(EndpointInstance instance, URI path) throws IOException {
        Objects.requireNonNull(instance, "EndpointInstance cannot be null");
        Objects.requireNonNull(path, "Path cannot be null");
        ClientEndpointConfig config = (ClientEndpointConfig)instance.getConfig();
        ClientUpgradeRequest req = new ClientUpgradeRequest();
        JsrUpgradeListener upgradeListener = null;
        for (Extension ext : config.getExtensions()) {
            req.addExtensions(new JsrExtensionConfig(ext));
        }
        if (config.getPreferredSubprotocols().size() > 0) {
            req.setSubProtocols(config.getPreferredSubprotocols());
        }
        if (config.getConfigurator() != null) {
            upgradeListener = new JsrUpgradeListener(config.getConfigurator());
        }
        Future<org.eclipse.jetty.websocket.api.Session> futSess = this.client.connect(instance, path, req, upgradeListener);
        try {
            return (JsrSession)futSess.get();
        }
        catch (InterruptedException e) {
            throw new IOException("Connect failure", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Connect failure", cause);
        }
    }

    @Override
    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpointClass, config);
        return this.connect(instance, path);
    }

    @Override
    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(annotatedEndpointClass, null);
        return this.connect(instance, path);
    }

    @Override
    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpoint, config);
        return this.connect(instance, path);
    }

    @Override
    public Session connectToServer(Object endpoint, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpoint, null);
        return this.connect(instance, path);
    }

    @Override
    protected void doStop() throws Exception {
        ShutdownThread.deregister(this);
        this.endpointClientMetadataCache.clear();
        super.doStop();
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointMetadata getClientEndpointMetadata(Class<?> endpoint, EndpointConfig config) {
        EndpointMetadata metadata = null;
        Map<Class<?>, EndpointMetadata> map = this.endpointClientMetadataCache;
        synchronized (map) {
            metadata = this.endpointClientMetadataCache.get(endpoint);
            if (metadata != null) {
                return metadata;
            }
            ClientEndpoint anno = endpoint.getAnnotation(ClientEndpoint.class);
            if (anno != null) {
                AnnotatedClientEndpointMetadata annoMetadata = new AnnotatedClientEndpointMetadata(this, endpoint);
                AnnotatedEndpointScanner<ClientEndpoint, ClientEndpointConfig> scanner = new AnnotatedEndpointScanner<ClientEndpoint, ClientEndpointConfig>(annoMetadata);
                scanner.scan();
                metadata = annoMetadata;
            } else if (Endpoint.class.isAssignableFrom(endpoint)) {
                Class<?> eendpoint = endpoint;
                metadata = new SimpleEndpointMetadata(eendpoint, config);
            } else {
                StringBuilder err = new StringBuilder();
                err.append("Not a recognized websocket [");
                err.append(endpoint.getName());
                err.append("] does not extend @").append(ClientEndpoint.class.getName());
                err.append(" or extend from ").append(Endpoint.class.getName());
                throw new InvalidWebSocketException("Unable to identify as valid Endpoint: " + endpoint);
            }
            this.endpointClientMetadataCache.put(endpoint, metadata);
            return metadata;
        }
    }

    public DecoderFactory getDecoderFactory() {
        return this.decoderFactory;
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.client.getAsyncWriteTimeout();
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.client.getMaxBinaryMessageBufferSize();
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.client.getMaxIdleTimeout();
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.client.getMaxTextMessageBufferSize();
    }

    public EncoderFactory getEncoderFactory() {
        return this.encoderFactory;
    }

    @Override
    public Set<Extension> getInstalledExtensions() {
        HashSet<Extension> ret = new HashSet<Extension>();
        ExtensionFactory extensions = this.client.getExtensionFactory();
        for (String name : extensions.getExtensionNames()) {
            ret.add(new JsrExtension(name));
        }
        return ret;
    }

    public Set<Session> getOpenSessions() {
        return Collections.unmodifiableSet(this.openSessions);
    }

    private EndpointInstance newClientEndpointInstance(Class<?> endpointClass, ClientEndpointConfig config) {
        try {
            return this.newClientEndpointInstance(endpointClass.newInstance(), config);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InvalidWebSocketException("Unable to instantiate websocket: " + endpointClass.getClass());
        }
    }

    public EndpointInstance newClientEndpointInstance(Object endpoint, ClientEndpointConfig config) {
        EndpointMetadata metadata = this.getClientEndpointMetadata(endpoint.getClass(), config);
        ClientEndpointConfig cec = config;
        if (config == null) {
            cec = metadata instanceof AnnotatedClientEndpointMetadata ? ((AnnotatedClientEndpointMetadata)metadata).getConfig() : new EmptyClientEndpointConfig();
        }
        return new EndpointInstance(endpoint, cec, metadata);
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        if (session instanceof Session) {
            this.openSessions.remove((Session)((Object)session));
        } else {
            LOG.warn("JSR356 Implementation should not be mixed with native implementation: Expected {} to implement {}", session.getClass().getName(), Session.class.getName());
        }
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
        if (session instanceof Session) {
            this.openSessions.add((Session)((Object)session));
        } else {
            LOG.warn("JSR356 Implementation should not be mixed with native implementation: Expected {} to implement {}", session.getClass().getName(), Session.class.getName());
        }
    }

    @Override
    public void setAsyncSendTimeout(long ms) {
        this.client.setAsyncWriteTimeout(ms);
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.client.getPolicy().setMaxBinaryMessageSize(max);
        this.client.setMaxBinaryMessageBufferSize(max);
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long ms) {
        this.client.setMaxIdleTimeout(ms);
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.client.getPolicy().setMaxTextMessageSize(max);
        this.client.setMaxTextMessageBufferSize(max);
    }
}

