/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.benchmark.Atomics;

public class MonitoringThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicLong tasks = new AtomicLong();
    private final AtomicLong maxLatency = new AtomicLong();
    private final AtomicLong totalLatency = new AtomicLong();
    private final AtomicInteger threads = new AtomicInteger();
    private final AtomicInteger maxThreads = new AtomicInteger();
    private final MonitoringLinkedBlockingQueue queue = (MonitoringLinkedBlockingQueue)this.getQueue();

    public MonitoringThreadPoolExecutor(int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(maximumPoolSize, keepAliveTime, unit, new ThreadPoolExecutor.AbortPolicy());
    }

    public MonitoringThreadPoolExecutor(int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler) {
        super(maximumPoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new MonitoringLinkedBlockingQueue(), handler);
    }

    public void reset() {
        this.queue.reset();
        this.tasks.set(0L);
        this.maxLatency.set(0L);
        this.totalLatency.set(0L);
        this.threads.set(0);
        this.maxThreads.set(0);
    }

    public long getTasks() {
        return this.tasks.get();
    }

    public long getMaxQueueLatency() {
        return this.maxLatency.get();
    }

    public long getAverageQueueLatency() {
        long count = this.tasks.get();
        return count == 0L ? -1L : this.totalLatency.get() / count;
    }

    public int getMaxQueueSize() {
        return this.queue.maxSize.get();
    }

    public int getMaxActiveThreads() {
        return this.maxThreads.get();
    }

    @Override
    public void execute(final Runnable task) {
        final long begin = System.nanoTime();
        super.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long latency = System.nanoTime() - begin;
                Atomics.updateMax(MonitoringThreadPoolExecutor.this.maxLatency, latency);
                MonitoringThreadPoolExecutor.this.totalLatency.addAndGet(latency);
                MonitoringThreadPoolExecutor.this.tasks.incrementAndGet();
                Atomics.updateMax(MonitoringThreadPoolExecutor.this.maxThreads, MonitoringThreadPoolExecutor.this.threads.incrementAndGet());
                try {
                    task.run();
                }
                finally {
                    MonitoringThreadPoolExecutor.this.threads.decrementAndGet();
                }
            }
        });
    }

    private static class MonitoringLinkedBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private final AtomicInteger size = new AtomicInteger();
        private final AtomicInteger maxSize = new AtomicInteger();

        private MonitoringLinkedBlockingQueue() {
        }

        public void reset() {
            this.size.set(0);
            this.maxSize.set(0);
        }

        @Override
        public void clear() {
            this.reset();
            super.clear();
        }

        @Override
        public boolean offer(Runnable task) {
            boolean added = super.offer(task);
            if (added) {
                this.increment();
            }
            return added;
        }

        private void increment() {
            Atomics.updateMax(this.maxSize, this.size.incrementAndGet());
        }

        @Override
        public Runnable poll() {
            Runnable task = (Runnable)super.poll();
            if (task != null) {
                this.decrement();
            }
            return task;
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            Runnable task = (Runnable)super.poll(timeout, unit);
            if (task != null) {
                this.decrement();
            }
            return task;
        }

        @Override
        public Runnable take() throws InterruptedException {
            Runnable task = (Runnable)super.take();
            this.decrement();
            return task;
        }

        private void decrement() {
            this.size.decrementAndGet();
        }
    }
}

