/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicStampedReference;

public class Atomics {
    public static void updateMin(AtomicLong currentMin, long newValue) {
        long oldValue = currentMin.get();
        while (newValue < oldValue && !currentMin.compareAndSet(oldValue, newValue)) {
            oldValue = currentMin.get();
        }
    }

    public static void updateMax(AtomicLong currentMax, long newValue) {
        long oldValue = currentMax.get();
        while (newValue > oldValue && !currentMax.compareAndSet(oldValue, newValue)) {
            oldValue = currentMax.get();
        }
    }

    public static void updateMin(AtomicInteger currentMin, int newValue) {
        int oldValue = currentMin.get();
        while (newValue < oldValue && !currentMin.compareAndSet(oldValue, newValue)) {
            oldValue = currentMin.get();
        }
    }

    public static void updateMax(AtomicInteger currentMax, int newValue) {
        int oldValue = currentMax.get();
        while (newValue > oldValue && !currentMax.compareAndSet(oldValue, newValue)) {
            oldValue = currentMax.get();
        }
    }

    public static <T> int decrement(AtomicStampedReference<T> reference) {
        int oldCount = reference.getStamp();
        while (!reference.attemptStamp(reference.getReference(), oldCount - 1)) {
            oldCount = reference.getStamp();
        }
        return oldCount - 1;
    }
}

