/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.benchmark.Atomics;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class MonitoringQueuedThreadPool
extends QueuedThreadPool {
    private final AtomicLong tasks = new AtomicLong();
    private final AtomicLong maxLatency = new AtomicLong();
    private final AtomicLong totalLatency = new AtomicLong();
    private final AtomicInteger threads = new AtomicInteger();
    private final AtomicInteger maxThreads = new AtomicInteger();
    private final MonitoringBlockingArrayQueue queue = (MonitoringBlockingArrayQueue)((Object)this.getQueue());

    public MonitoringQueuedThreadPool(int maxThreads) {
        super(maxThreads, maxThreads, 86400000, (BlockingQueue)((Object)new MonitoringBlockingArrayQueue(maxThreads, maxThreads)));
        this.setStopTimeout(2000L);
    }

    public void execute(final Runnable job) {
        final long begin = System.nanoTime();
        super.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long latency = System.nanoTime() - begin;
                Atomics.updateMax(MonitoringQueuedThreadPool.this.maxLatency, latency);
                MonitoringQueuedThreadPool.this.totalLatency.addAndGet(latency);
                MonitoringQueuedThreadPool.this.tasks.incrementAndGet();
                Atomics.updateMax(MonitoringQueuedThreadPool.this.maxThreads, MonitoringQueuedThreadPool.this.threads.incrementAndGet());
                try {
                    job.run();
                }
                finally {
                    MonitoringQueuedThreadPool.this.threads.decrementAndGet();
                }
            }
        });
    }

    public void reset() {
        this.queue.reset();
        this.tasks.set(0L);
        this.maxLatency.set(0L);
        this.totalLatency.set(0L);
        this.threads.set(0);
        this.maxThreads.set(0);
    }

    public long getTasks() {
        return this.tasks.get();
    }

    public int getMaxActiveThreads() {
        return this.maxThreads.get();
    }

    public int getMaxQueueSize() {
        return this.queue.maxSize.get();
    }

    public long getAverageQueueLatency() {
        long count = this.tasks.get();
        return count == 0L ? -1L : this.totalLatency.get() / count;
    }

    public long getMaxQueueLatency() {
        return this.maxLatency.get();
    }

    public static class MonitoringBlockingArrayQueue
    extends BlockingArrayQueue<Runnable> {
        private final AtomicInteger size = new AtomicInteger();
        private final AtomicInteger maxSize = new AtomicInteger();

        public MonitoringBlockingArrayQueue(int capacity, int growBy) {
            super(capacity, growBy);
        }

        public void reset() {
            this.size.set(0);
            this.maxSize.set(0);
        }

        public void clear() {
            this.reset();
            super.clear();
        }

        public boolean offer(Runnable job) {
            boolean added = super.offer((Object)job);
            if (added) {
                this.increment();
            }
            return added;
        }

        private void increment() {
            Atomics.updateMax(this.maxSize, this.size.incrementAndGet());
        }

        public Runnable poll() {
            Runnable job = (Runnable)super.poll();
            if (job != null) {
                this.decrement();
            }
            return job;
        }

        public Runnable poll(long time, TimeUnit unit) throws InterruptedException {
            Runnable job = (Runnable)super.poll(time, unit);
            if (job != null) {
                this.decrement();
            }
            return job;
        }

        public Runnable take() throws InterruptedException {
            Runnable job = (Runnable)super.take();
            this.decrement();
            return job;
        }

        private void decrement() {
            this.size.decrementAndGet();
        }
    }
}

