/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark.server;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.benchmark.Atomics;
import org.cometd.benchmark.BenchmarkHelper;
import org.cometd.benchmark.MonitoringQueuedThreadPool;
import org.cometd.benchmark.MonitoringThreadPoolExecutor;
import org.cometd.server.AbstractService;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometDServlet;
import org.cometd.server.Jackson1JSONContextServer;
import org.cometd.server.transport.AsyncJSONTransport;
import org.cometd.server.transport.JSONTransport;
import org.cometd.websocket.server.JettyWebSocketTransport;
import org.cometd.websocket.server.WebSocketTransport;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class BayeuxLoadServer {
    public static void main(String[] args) throws Exception {
        BayeuxLoadServer server = new BayeuxLoadServer();
        server.run();
    }

    public void run() throws Exception {
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        int port = 8080;
        System.err.printf("listen port [%d]: ", port);
        String value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(port);
        }
        port = Integer.parseInt(value);
        boolean ssl = false;
        System.err.printf("use ssl [%b]: ", ssl);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(ssl);
        }
        ssl = Boolean.parseBoolean(value);
        int selectors = Runtime.getRuntime().availableProcessors();
        System.err.printf("selectors [%d]: ", selectors);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(selectors);
        }
        selectors = Integer.parseInt(value);
        int maxThreads = Integer.parseInt(System.getProperty("cometd.threads", "256"));
        System.err.printf("max threads [%d]: ", maxThreads);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(maxThreads);
        }
        maxThreads = Integer.parseInt(value);
        BayeuxServerImpl bayeuxServer = new BayeuxServerImpl();
        MonitoringQueuedThreadPool jettyThreadPool = new MonitoringQueuedThreadPool(maxThreads);
        MonitoringThreadPoolExecutor websocketThreadPool = new MonitoringThreadPoolExecutor(maxThreads, (long)jettyThreadPool.getIdleTimeout(), TimeUnit.MILLISECONDS, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        String availableTransports = "jsrws,jettyws,http,asynchttp";
        String transports = "jsrws,http";
        System.err.printf("transports (%s) [%s]: ", availableTransports, transports);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = transports;
        }
        block12: for (String token : value.split(",")) {
            switch (token.trim()) {
                case "jsrws": {
                    bayeuxServer.addTransport((ServerTransport)new LoadWebSocketTransport(bayeuxServer, (Executor)websocketThreadPool));
                    continue block12;
                }
                case "jettyws": {
                    bayeuxServer.addTransport((ServerTransport)new LoadJettyWebSocketTransport(bayeuxServer, (Executor)websocketThreadPool));
                    continue block12;
                }
                case "http": {
                    bayeuxServer.addTransport((ServerTransport)new JSONTransport(bayeuxServer));
                    continue block12;
                }
                case "asynchttp": {
                    bayeuxServer.addTransport((ServerTransport)new AsyncJSONTransport(bayeuxServer));
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transport: " + token);
                }
            }
        }
        boolean stats = true;
        System.err.printf("record statistics [%b]: ", stats);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(stats);
        }
        stats = Boolean.parseBoolean(value);
        boolean reqs = true;
        System.err.printf("record latencies [%b]: ", reqs);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(reqs);
        }
        reqs = Boolean.parseBoolean(value);
        boolean qos = false;
        System.err.printf("detect long requests [%b]: ", qos);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(qos);
        }
        qos = Boolean.parseBoolean(value);
        Server server = new Server((ThreadPool)jettyThreadPool);
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbeanContainer);
        SslContextFactory sslContextFactory = null;
        if (ssl) {
            Path keyStoreFile = Paths.get("src/main/resources/keystore.jks", new String[0]);
            if (Files.exists(keyStoreFile, new LinkOption[0])) {
                throw new FileNotFoundException(keyStoreFile.toString());
            }
            sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(keyStoreFile.toString());
            sslContextFactory.setKeyStorePassword("storepwd");
            sslContextFactory.setKeyManagerPassword("keypwd");
        }
        ConnectionFactory[] factories = AbstractConnectionFactory.getFactories(sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{new HttpConnectionFactory()});
        ServerConnector connector = new ServerConnector(server, null, null, null, 1, selectors, factories);
        connector.setAcceptQueueSize(2048);
        connector.setIdleTimeout(240000L);
        connector.setPort(port);
        server.addConnector((Connector)connector);
        Object handler = server;
        RequestLatencyHandler requestLatencyHandler = null;
        if (reqs) {
            requestLatencyHandler = new RequestLatencyHandler();
            handler.setHandler((Handler)requestLatencyHandler);
            handler = requestLatencyHandler;
        }
        if (qos) {
            RequestQoSHandler requestQoSHandler = new RequestQoSHandler();
            handler.setHandler((Handler)requestQoSHandler);
            handler = requestQoSHandler;
        }
        StatisticsHandler statisticsHandler = null;
        if (stats) {
            statisticsHandler = new StatisticsHandler();
            handler.setHandler((Handler)statisticsHandler);
            handler = statisticsHandler;
        }
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)handler, "/", 1);
        context.setAttribute("org.cometd.bayeux", (Object)bayeuxServer);
        context.setInitParameter("org.eclipse.jetty.server.context.ManagedAttributes", "org.cometd.bayeux");
        WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
        context.addServlet(DefaultServlet.class, "/");
        String cometdServletPath = "/cometd";
        String cometdURLMapping = cometdServletPath + "/*";
        CometDServlet cometServlet = new CometDServlet();
        ServletHolder cometdServletHolder = new ServletHolder((Servlet)cometServlet);
        context.addServlet(cometdServletHolder, cometdURLMapping);
        bayeuxServer.setOption("maxInterval", (Object)String.valueOf(60000));
        bayeuxServer.setOption("timeout", (Object)String.valueOf(30000));
        bayeuxServer.setOption("jsonContext", (Object)Jackson1JSONContextServer.class.getName());
        bayeuxServer.setOption("ws.cometdURLMapping", (Object)cometdURLMapping);
        bayeuxServer.setOption(ServletContext.class.getName(), (Object)context.getServletContext());
        server.start();
        new StatisticsService((BayeuxServer)bayeuxServer, jettyThreadPool, websocketThreadPool, statisticsHandler, requestLatencyHandler);
    }

    public static class LoadWebSocketTransport
    extends WebSocketTransport {
        private final Executor executor;

        public LoadWebSocketTransport(BayeuxServerImpl bayeux, Executor executor) {
            super(bayeux);
            this.executor = executor;
        }

        protected Executor newExecutor() {
            return this.executor;
        }
    }

    public static class LoadJettyWebSocketTransport
    extends JettyWebSocketTransport {
        private final Executor executor;

        public LoadJettyWebSocketTransport(BayeuxServerImpl bayeux, Executor executor) {
            super(bayeux);
            this.executor = executor;
        }

        protected Executor newExecutor() {
            return this.executor;
        }
    }

    private static class RequestLatencyHandler
    extends HandlerWrapper {
        private final AtomicLong requests = new AtomicLong();
        private final AtomicLong minLatency = new AtomicLong();
        private final AtomicLong maxLatency = new AtomicLong();
        private final AtomicLong totLatency = new AtomicLong();
        private final ConcurrentMap<Long, AtomicLong> latencies = new ConcurrentHashMap<Long, AtomicLong>();
        private final ThreadLocal<Boolean> currentEnabled = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };

        private RequestLatencyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            this.requests.incrementAndGet();
            long begin = System.nanoTime();
            try {
                super.handle(target, request, httpRequest, httpResponse);
            }
            finally {
                long end = System.nanoTime();
                if (this.currentEnabled.get().booleanValue()) {
                    this.updateLatencies(begin, end);
                } else {
                    this.currentEnabled.set(true);
                }
            }
        }

        private void reset() {
            this.requests.set(0L);
            this.minLatency.set(Long.MAX_VALUE);
            this.maxLatency.set(0L);
            this.totLatency.set(0L);
            this.latencies.clear();
        }

        private void updateLatencies(long begin, long end) {
            long latency = TimeUnit.MICROSECONDS.toNanos(TimeUnit.NANOSECONDS.toMicros(end - begin));
            Atomics.updateMin((AtomicLong)this.minLatency, (long)latency);
            Atomics.updateMax((AtomicLong)this.maxLatency, (long)latency);
            this.totLatency.addAndGet(latency);
            AtomicLong count = (AtomicLong)this.latencies.get(latency);
            if (count == null) {
                count = new AtomicLong();
                AtomicLong existing = this.latencies.put(latency, count);
                if (existing != null) {
                    count = existing;
                }
            }
            count.incrementAndGet();
        }

        private void print() {
            if (this.latencies.size() > 1) {
                long requestCount = this.requests.get();
                TreeMap<Long, AtomicLong> sortedLatencies = new TreeMap<Long, AtomicLong>(this.latencies);
                this.latencies.clear();
                long requests = 0L;
                long maxLatencyBucketFrequency = 0L;
                long previousLatency = 0L;
                long latencyAt50thPercentile = 0L;
                long latencyAt99thPercentile = 0L;
                long[] latencyBucketFrequencies = new long[20];
                long minLatency = this.minLatency.get();
                long latencyRange = this.maxLatency.get() - minLatency;
                Iterator entries = sortedLatencies.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    long latency = (Long)entry.getKey();
                    Long bucketIndex = latencyRange == 0L ? 0L : (latency - minLatency) * (long)latencyBucketFrequencies.length / latencyRange;
                    int index = bucketIndex.intValue() == latencyBucketFrequencies.length ? latencyBucketFrequencies.length - 1 : bucketIndex.intValue();
                    long value = ((AtomicLong)entry.getValue()).get();
                    requests += value;
                    int n = index;
                    latencyBucketFrequencies[n] = latencyBucketFrequencies[n] + value;
                    if (latencyBucketFrequencies[index] > maxLatencyBucketFrequency) {
                        maxLatencyBucketFrequency = latencyBucketFrequencies[index];
                    }
                    if (latencyAt50thPercentile == 0L && requests > requestCount / 2L) {
                        latencyAt50thPercentile = (previousLatency + latency) / 2L;
                    }
                    if (latencyAt99thPercentile == 0L && requests > requestCount - requestCount / 100L) {
                        latencyAt99thPercentile = (previousLatency + latency) / 2L;
                    }
                    previousLatency = latency;
                    entries.remove();
                }
                System.err.println("Requests - Latency Distribution Curve (X axis: Frequency, Y axis: Latency):");
                double percentile = 0.0;
                for (int i = 0; i < latencyBucketFrequencies.length; ++i) {
                    int j;
                    int value;
                    long latencyBucketFrequency = latencyBucketFrequencies[i];
                    int n = value = maxLatencyBucketFrequency == 0L ? 0 : Math.round((float)latencyBucketFrequency * (float)latencyBucketFrequencies.length / (float)maxLatencyBucketFrequency);
                    if (value == latencyBucketFrequencies.length) {
                        --value;
                    }
                    for (j = 0; j < value; ++j) {
                        System.err.print(" ");
                    }
                    System.err.print("@");
                    for (j = value + 1; j < latencyBucketFrequencies.length; ++j) {
                        System.err.print(" ");
                    }
                    System.err.print("  _  ");
                    System.err.print(TimeUnit.NANOSECONDS.toMillis(latencyRange * (long)(i + 1) / (long)latencyBucketFrequencies.length + minLatency));
                    System.err.printf(" ms (%d, %.2f%%)", latencyBucketFrequency, 100.0 * (double)latencyBucketFrequency / (double)requestCount);
                    double last = percentile;
                    percentile += 100.0 * (double)latencyBucketFrequency / (double)requestCount;
                    if (last < 50.0 && percentile >= 50.0) {
                        System.err.print(" ^50%");
                    }
                    if (last < 85.0 && percentile >= 85.0) {
                        System.err.print(" ^85%");
                    }
                    if (last < 95.0 && percentile >= 95.0) {
                        System.err.print(" ^95%");
                    }
                    if (last < 99.0 && percentile >= 99.0) {
                        System.err.print(" ^99%");
                    }
                    if (last < 99.9 && percentile >= 99.9) {
                        System.err.print(" ^99.9%");
                    }
                    System.err.println();
                }
                System.err.printf("Requests - Latency 50th%%/99th%% = %d/%d ms%n", TimeUnit.NANOSECONDS.toMillis(latencyAt50thPercentile), TimeUnit.NANOSECONDS.toMillis(latencyAt99thPercentile));
            }
        }

        public void doNotTrackCurrentRequest() {
            this.currentEnabled.set(false);
        }
    }

    private static class RequestQoSHandler
    extends HandlerWrapper {
        private final long maxRequestTime = 500L;
        private final AtomicLong requestIds = new AtomicLong();
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(50);

        private RequestQoSHandler() {
        }

        protected void doStop() throws Exception {
            super.doStop();
            this.scheduler.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request request, final HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            final long requestId = this.requestIds.incrementAndGet();
            final AtomicBoolean longRequest = new AtomicBoolean(false);
            final Thread thread = Thread.currentThread();
            ScheduledFuture<?> task = this.scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    longRequest.set(true);
                    RequestQoSHandler.this.onLongRequestDetected(requestId, httpRequest, thread);
                }
            }, 500L, 500L, TimeUnit.MILLISECONDS);
            long start = System.nanoTime();
            try {
                super.handle(target, request, httpRequest, httpResponse);
            }
            finally {
                long end = System.nanoTime();
                task.cancel(false);
                if (longRequest.get()) {
                    this.onLongRequestEnded(requestId, end - start);
                }
            }
        }

        private void onLongRequestDetected(long requestId, HttpServletRequest request, Thread thread) {
            try {
                long begin = System.nanoTime();
                StackTraceElement[] stackFrames = thread.getStackTrace();
                StringBuilder builder = new StringBuilder();
                this.formatRequest(request, builder);
                builder.append(thread).append("\n");
                this.formatStackFrames(stackFrames, builder);
                System.err.println("Request #" + requestId + " is too slow (> " + 500L + " ms)\n" + builder);
                long end = System.nanoTime();
                System.err.println("Request #" + requestId + " printed in " + TimeUnit.NANOSECONDS.toMicros(end - begin) + " \u00b5s");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        private void formatRequest(HttpServletRequest request, StringBuilder builder) {
            builder.append(request.getRequestURI()).append("\n");
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                builder.append(name).append("=").append(Collections.list(request.getHeaders(name))).append("\n");
            }
            builder.append(request.getRemoteAddr()).append(":").append(request.getRemotePort()).append(" => ");
            builder.append(request.getLocalAddr()).append(":").append(request.getLocalPort()).append("\n");
        }

        private void onLongRequestEnded(long requestId, long time) {
            System.err.println("Request #" + requestId + " lasted " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
        }

        private void formatStackFrames(StackTraceElement[] stackFrames, StringBuilder builder) {
            for (int i = 0; i < stackFrames.length; ++i) {
                StackTraceElement stackFrame = stackFrames[i];
                for (int j = 0; j < i; ++j) {
                    builder.append(" ");
                }
                builder.append(stackFrame).append("\n");
            }
        }
    }

    public static class StatisticsService
    extends AbstractService {
        private final BenchmarkHelper helper = new BenchmarkHelper();
        private final MonitoringQueuedThreadPool jettyThreadPool;
        private final MonitoringThreadPoolExecutor websocketThreadPool;
        private final StatisticsHandler statisticsHandler;
        private final RequestLatencyHandler requestLatencyHandler;

        private StatisticsService(BayeuxServer bayeux, MonitoringQueuedThreadPool jettyThreadPool, MonitoringThreadPoolExecutor websocketThreadPool, StatisticsHandler statisticsHandler, RequestLatencyHandler requestLatencyHandler) {
            super(bayeux, "statistics-service");
            this.jettyThreadPool = jettyThreadPool;
            this.websocketThreadPool = websocketThreadPool;
            this.statisticsHandler = statisticsHandler;
            this.requestLatencyHandler = requestLatencyHandler;
            this.addService("/service/statistics/start", "startStatistics");
            this.addService("/service/statistics/stop", "stopStatistics");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startStatistics(ServerSession remote, Message message) {
            StatisticsService statisticsService = this;
            synchronized (statisticsService) {
                boolean started = this.helper.startStatistics();
                if (started) {
                    if (this.jettyThreadPool != null) {
                        this.jettyThreadPool.reset();
                    }
                    if (this.websocketThreadPool != null) {
                        this.websocketThreadPool.reset();
                    }
                    if (this.statisticsHandler != null) {
                        this.statisticsHandler.statsReset();
                    }
                    if (this.requestLatencyHandler != null) {
                        this.requestLatencyHandler.reset();
                        this.requestLatencyHandler.doNotTrackCurrentRequest();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopStatistics(ServerSession remote, Message message) throws Exception {
            StatisticsService statisticsService = this;
            synchronized (statisticsService) {
                boolean stopped = this.helper.stopStatistics();
                if (stopped) {
                    if (this.requestLatencyHandler != null) {
                        this.requestLatencyHandler.print();
                        this.requestLatencyHandler.doNotTrackCurrentRequest();
                    }
                    if (this.statisticsHandler != null) {
                        System.err.printf("Requests times (total/avg/max - stddev): %d/%d/%d ms - %d%n", this.statisticsHandler.getDispatchedTimeTotal(), Double.valueOf(this.statisticsHandler.getDispatchedTimeMean()).longValue(), this.statisticsHandler.getDispatchedTimeMax(), Double.valueOf(this.statisticsHandler.getDispatchedTimeStdDev()).longValue());
                        System.err.printf("Requests (total/failed/max - rate): %d/%d/%d - %d requests/s%n", this.statisticsHandler.getDispatched(), this.statisticsHandler.getResponses4xx() + this.statisticsHandler.getResponses5xx(), this.statisticsHandler.getDispatchedActiveMax(), this.statisticsHandler.getStatsOnMs() == 0L ? -1L : (long)this.statisticsHandler.getDispatched() * 1000L / this.statisticsHandler.getStatsOnMs());
                    }
                    if (this.jettyThreadPool != null) {
                        System.err.printf("Jetty Thread Pool - Tasks = %d | Concurrent Threads max = %d | Queue Size max = %d | Queue Latency avg/max = %d/%d ms%n", this.jettyThreadPool.getTasks(), this.jettyThreadPool.getMaxActiveThreads(), this.jettyThreadPool.getMaxQueueSize(), TimeUnit.NANOSECONDS.toMillis(this.jettyThreadPool.getAverageQueueLatency()), TimeUnit.NANOSECONDS.toMillis(this.jettyThreadPool.getMaxQueueLatency()));
                    }
                    if (this.websocketThreadPool != null) {
                        System.err.printf("WebSocket Thread Pool - Tasks = %d | Concurrent Threads max = %d | Queue Size max = %d | Queue Latency avg/max = %d/%d ms%n", this.websocketThreadPool.getTasks(), this.websocketThreadPool.getMaxActiveThreads(), this.websocketThreadPool.getMaxQueueSize(), TimeUnit.NANOSECONDS.toMillis(this.websocketThreadPool.getAverageQueueLatency()), TimeUnit.NANOSECONDS.toMillis(this.websocketThreadPool.getMaxQueueLatency()));
                    }
                }
            }
        }
    }
}

