/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark.server;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.benchmark.Config;
import org.cometd.benchmark.MonitoringQueuedThreadPool;
import org.cometd.server.AbstractService;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometDServlet;
import org.cometd.server.JacksonJSONContextServer;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.cometd.server.http.AbstractHttpTransport;
import org.cometd.server.http.AsyncJSONTransport;
import org.cometd.server.http.JSONTransport;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.javax.WebSocketTransport;
import org.cometd.server.websocket.jetty.JettyWebSocketTransport;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.perf.HistogramSnapshot;
import org.eclipse.jetty.toolchain.perf.MeasureConverter;
import org.eclipse.jetty.toolchain.perf.PlatformMonitor;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class CometDLoadServer {
    private final MonitoringQueuedThreadPool jettyThreadPool = new MonitoringQueuedThreadPool(0);
    private final MonitoringQueuedThreadPool cometdThreadPool = new MonitoringQueuedThreadPool(0);
    private final BayeuxServerImpl bayeuxServer = new BayeuxServerImpl();
    private final Server server = new Server((ThreadPool)this.jettyThreadPool);
    private final MessageLatencyExtension messageLatencyExtension = new MessageLatencyExtension();
    private boolean interactive = true;
    private int port = 8080;
    private boolean tls = false;
    private int selectors = Runtime.getRuntime().availableProcessors();
    private int maxThreads = 256;
    private String transports = "jsrws,asynchttp";
    private boolean perMessageDeflate = false;
    private boolean statistics = true;
    private boolean latencies = true;
    private boolean longRequests = false;
    private RequestLatencyHandler requestLatencyHandler;
    private StatisticsHandler statisticsHandler;

    public static void main(String[] args) throws Exception {
        CometDLoadServer server = new CometDLoadServer();
        CometDLoadServer.parseArguments(args, server);
        server.run();
    }

    private static void parseArguments(String[] args, CometDLoadServer server) {
        for (String arg : args) {
            if (arg.equals("--auto")) {
                server.interactive = false;
                continue;
            }
            if (arg.startsWith("--port=")) {
                server.port = Integer.parseInt(arg.substring("--port=".length()));
                continue;
            }
            if (arg.equals("--tls")) {
                server.tls = true;
                continue;
            }
            if (arg.startsWith("--selectors=")) {
                server.selectors = Integer.parseInt(arg.substring("--selectors=".length()));
                continue;
            }
            if (arg.startsWith("--maxThreads=")) {
                server.maxThreads = Integer.parseInt(arg.substring("--maxThreads=".length()));
                continue;
            }
            if (arg.startsWith("--transports=")) {
                server.transports = arg.substring("--transports=".length());
                continue;
            }
            if (arg.equals("--permessage-deflate")) {
                server.perMessageDeflate = true;
                continue;
            }
            if (arg.equals("--statistics")) {
                server.statistics = true;
                continue;
            }
            if (arg.equals("--latencies")) {
                server.latencies = true;
                continue;
            }
            if (!arg.equals("--longRequests")) continue;
            server.longRequests = true;
        }
    }

    public void run() throws Exception {
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        int port = this.port;
        if (this.interactive) {
            System.err.printf("listen port [%d]: ", port);
            String value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(port);
            }
            port = Integer.parseInt(value);
        }
        boolean tls = this.tls;
        if (this.interactive) {
            System.err.printf("use tls [%b]: ", tls);
            String value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(tls);
            }
            tls = Boolean.parseBoolean(value);
        }
        int selectors = this.selectors;
        if (this.interactive) {
            System.err.printf("selectors [%d]: ", selectors);
            String value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(selectors);
            }
            selectors = Integer.parseInt(value);
        }
        int maxThreads = this.maxThreads;
        if (this.interactive) {
            maxThreads = Integer.parseInt(System.getProperty("cometd.threads", String.valueOf(maxThreads)));
            System.err.printf("max threads [%d]: ", maxThreads);
            String value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(maxThreads);
            }
            maxThreads = Integer.parseInt(value);
        }
        this.jettyThreadPool.setMaxThreads(maxThreads);
        this.cometdThreadPool.setMaxThreads(maxThreads);
        this.cometdThreadPool.setReservedThreads(0);
        String availableTransports = "jsrws,jettyws,http,asynchttp";
        Object transports = this.transports;
        if (this.interactive) {
            System.err.printf("transports (%s) [%s]: ", availableTransports, transports);
            Object value = console.readLine().trim();
            if (((String)value).length() == 0) {
                value = transports;
            }
            transports = value;
        }
        block12: for (String token : ((String)transports).split(",")) {
            String transport;
            switch (transport = token.trim()) {
                case "jsrws": {
                    boolean perMessageDeflate = this.readPerMessageDeflate(transport, console);
                    Object serverTransport = new WebSocketTransport(this.bayeuxServer){

                        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
                            CometDLoadServer.this.messageLatencyExtension.complete(messages);
                        }
                    };
                    serverTransport.setOption("enableExtension.permessage-deflate", (Object)perMessageDeflate);
                    this.bayeuxServer.addTransport((ServerTransport)serverTransport);
                    continue block12;
                }
                case "jettyws": {
                    boolean perMessageDeflate = this.readPerMessageDeflate(transport, console);
                    Object serverTransport = new JettyWebSocketTransport(this.bayeuxServer){

                        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
                            CometDLoadServer.this.messageLatencyExtension.complete(messages);
                        }
                    };
                    serverTransport.setOption("enableExtension.permessage-deflate", (Object)perMessageDeflate);
                    this.bayeuxServer.addTransport((ServerTransport)serverTransport);
                    continue block12;
                }
                case "http": {
                    this.bayeuxServer.addTransport((ServerTransport)new JSONTransport(this.bayeuxServer){

                        protected void writeComplete(AbstractHttpTransport.Context context, List<ServerMessage> messages) {
                            CometDLoadServer.this.messageLatencyExtension.complete(messages);
                        }
                    });
                    continue block12;
                }
                case "asynchttp": {
                    this.bayeuxServer.addTransport((ServerTransport)new AsyncJSONTransport(this.bayeuxServer){

                        protected void writeComplete(AbstractHttpTransport.Context context, List<ServerMessage> messages) {
                            CometDLoadServer.this.messageLatencyExtension.complete(messages);
                        }
                    });
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transport: " + token);
                }
            }
        }
        boolean statistics = this.statistics;
        if (this.interactive) {
            System.err.printf("record statistics [%b]: ", statistics);
            String value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(statistics);
            }
            statistics = Boolean.parseBoolean(value);
        }
        boolean latencies = this.latencies;
        if (this.interactive) {
            System.err.printf("record latencies [%b]: ", latencies);
            String value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(latencies);
            }
            latencies = Boolean.parseBoolean(value);
        }
        boolean longRequests = this.longRequests;
        if (this.interactive) {
            System.err.printf("detect long requests [%b]: ", longRequests);
            String value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(longRequests);
            }
            longRequests = Boolean.parseBoolean(value);
        }
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addBean((Object)mbeanContainer);
        SslContextFactory.Server sslContextFactory = null;
        if (tls) {
            Path keyStoreFile = Paths.get("src/main/resources/keystore.p12", new String[0]);
            if (!Files.exists(keyStoreFile, new LinkOption[0])) {
                throw new FileNotFoundException(keyStoreFile.toString());
            }
            sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(keyStoreFile.toString());
            sslContextFactory.setKeyStoreType("pkcs12");
            sslContextFactory.setKeyStorePassword("storepwd");
        }
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setDelayDispatchUntilContent(true);
        HttpConnectionFactory http = new HttpConnectionFactory(httpConfiguration);
        HTTP2ServerConnectionFactory http2 = tls ? new HTTP2ServerConnectionFactory(httpConfiguration) : new HTTP2CServerConnectionFactory(httpConfiguration);
        ConnectionFactory[] factories = new ConnectionFactory[]{http, http2};
        if (tls) {
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            alpn.setDefaultProtocol(http.getProtocol());
            factories = AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{alpn, http, http2});
        }
        ServerConnector connector = new ServerConnector(this.server, null, null, null, 1, selectors, factories);
        connector.setAcceptQueueSize(2048);
        connector.setIdleTimeout(70000L);
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        Object handler = this.server;
        if (latencies) {
            this.requestLatencyHandler = new RequestLatencyHandler();
            handler.setHandler((Handler)this.requestLatencyHandler);
            handler = this.requestLatencyHandler;
        }
        if (longRequests) {
            RequestQoSHandler requestQoSHandler = new RequestQoSHandler();
            handler.setHandler((Handler)requestQoSHandler);
            handler = requestQoSHandler;
        }
        if (statistics) {
            this.statisticsHandler = new StatisticsHandler();
            handler.setHandler((Handler)this.statisticsHandler);
            handler = this.statisticsHandler;
        }
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)handler, "/cometd", 1);
        context.getServletContext().setAttribute("org.cometd.bayeux", (Object)this.bayeuxServer);
        context.setInitParameter("org.eclipse.jetty.server.context.ManagedAttributes", "org.cometd.bayeux");
        WebSocketServerContainerInitializer.configure((ServletContextHandler)context, null);
        context.addServlet(DefaultServlet.class, "/");
        String cometdURLMapping = "/cometd/*";
        CometDServlet cometServlet = new CometDServlet();
        ServletHolder cometdServletHolder = new ServletHolder((Servlet)cometServlet);
        context.addServlet(cometdServletHolder, cometdURLMapping);
        this.bayeuxServer.setOption("maxInterval", (Object)String.valueOf(50000L));
        this.bayeuxServer.setOption("timeout", (Object)String.valueOf(20000L));
        this.bayeuxServer.setOption("jsonContext", (Object)JacksonJSONContextServer.class.getName());
        this.bayeuxServer.setOption("ws.cometdURLMapping", (Object)cometdURLMapping);
        this.bayeuxServer.setOption(ServletContext.class.getName(), (Object)context.getServletContext());
        this.bayeuxServer.addExtension((BayeuxServer.Extension)new AcknowledgedMessagesExtension());
        this.bayeuxServer.addExtension((BayeuxServer.Extension)this.messageLatencyExtension);
        this.bayeuxServer.setExecutor((Executor)this.cometdThreadPool);
        this.server.start();
        new StatisticsService(this);
    }

    private boolean readPerMessageDeflate(String transport, BufferedReader console) throws IOException {
        boolean perMessageDeflate = this.perMessageDeflate;
        if (this.interactive) {
            System.err.printf("enable %s permessage-deflate extension [%b]: ", transport, perMessageDeflate);
            String value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(perMessageDeflate);
            }
            perMessageDeflate = Boolean.parseBoolean(value);
        }
        return perMessageDeflate;
    }

    private static class MessageLatencyExtension
    implements BayeuxServer.Extension,
    MeasureConverter {
        private static final String SERVER_TIME_FIELD = "serverTime";
        private final Recorder latencies = new Recorder(TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MINUTES.toNanos(1L), 3);

        private MessageLatencyExtension() {
        }

        public boolean rcv(ServerSession session, ServerMessage.Mutable message) {
            String id;
            if (message.getChannel().startsWith("/bench/") && (id = (String)message.getDataAsMap().get("msg_id")) != null) {
                message.put((Object)SERVER_TIME_FIELD, (Object)System.nanoTime());
            }
            return true;
        }

        private void complete(List<ServerMessage> messages) {
            for (ServerMessage message : messages) {
                Long serverTime;
                String id;
                if (!message.getChannel().startsWith("/bench/") || (id = (String)message.getDataAsMap().get("msg_id")) == null || (serverTime = (Long)message.get((Object)SERVER_TIME_FIELD)) == null) continue;
                this.latencies.recordValue(System.nanoTime() - serverTime);
            }
        }

        public long convert(long measure) {
            return TimeUnit.NANOSECONDS.toMicros(measure);
        }

        private void print() {
            Histogram histogram = this.latencies.getIntervalHistogram();
            if (histogram.getTotalCount() > 0L) {
                System.err.println("========================================");
                System.err.println(new HistogramSnapshot(histogram, 20L, "Messages - Processing", "\u00b5s", (MeasureConverter)this));
            }
        }
    }

    private static class RequestLatencyHandler
    extends HandlerWrapper
    implements MeasureConverter {
        private final Collection<Histogram> allHistograms = new CopyOnWriteArrayList<Histogram>();
        private final ThreadLocal<Histogram> histogram = ThreadLocal.withInitial(() -> {
            Histogram histogram = new Histogram(TimeUnit.MINUTES.toNanos(1L), 3);
            this.allHistograms.add(histogram);
            return histogram;
        });
        private final ThreadLocal<Boolean> currentEnabled = ThreadLocal.withInitial(() -> Boolean.TRUE);

        private RequestLatencyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            long begin = System.nanoTime();
            try {
                super.handle(target, request, httpRequest, httpResponse);
            }
            finally {
                long end = System.nanoTime();
                if (this.currentEnabled.get().booleanValue()) {
                    if (!request.getHttpFields().contains(HttpHeader.UPGRADE)) {
                        this.updateLatencies(begin, end);
                    }
                } else {
                    this.currentEnabled.set(true);
                }
            }
        }

        public long convert(long measure) {
            return TimeUnit.NANOSECONDS.toMicros(measure);
        }

        private void reset() {
            this.allHistograms.forEach(AbstractHistogram::reset);
        }

        private void updateLatencies(long begin, long end) {
            this.histogram.get().recordValue(end - begin);
        }

        private void print() {
            Histogram histogram = this.allHistograms.stream().reduce(new Histogram(TimeUnit.MINUTES.toNanos(1L), 3), (h1, h2) -> {
                h1.add((AbstractHistogram)h2);
                return h1;
            });
            if (histogram.getTotalCount() > 0L) {
                System.err.println(new HistogramSnapshot(histogram, 20L, "Requests - Latency", "\u00b5s", (MeasureConverter)this));
            }
        }

        public void doNotTrackCurrentRequest() {
            this.currentEnabled.set(false);
        }
    }

    private static class RequestQoSHandler
    extends HandlerWrapper {
        private final long maxRequestTime = 500L;
        private final AtomicLong requestIds = new AtomicLong();
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(50);

        private RequestQoSHandler() {
        }

        protected void doStop() throws Exception {
            super.doStop();
            this.scheduler.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            long requestId = this.requestIds.incrementAndGet();
            AtomicBoolean longRequest = new AtomicBoolean(false);
            Thread thread = Thread.currentThread();
            ScheduledFuture<?> task = this.scheduler.scheduleWithFixedDelay(() -> {
                longRequest.set(true);
                this.onLongRequestDetected(requestId, httpRequest, thread);
            }, 500L, 500L, TimeUnit.MILLISECONDS);
            long start = System.nanoTime();
            try {
                super.handle(target, request, httpRequest, httpResponse);
            }
            finally {
                long end = System.nanoTime();
                task.cancel(false);
                if (longRequest.get()) {
                    this.onLongRequestEnded(requestId, end - start);
                }
            }
        }

        private void onLongRequestDetected(long requestId, HttpServletRequest request, Thread thread) {
            try {
                long begin = System.nanoTime();
                StackTraceElement[] stackFrames = thread.getStackTrace();
                StringBuilder builder = new StringBuilder();
                this.formatRequest(request, builder);
                builder.append(thread).append("\n");
                this.formatStackFrames(stackFrames, builder);
                System.err.println("Request #" + requestId + " is too slow (> " + 500L + " ms)\n" + builder);
                long end = System.nanoTime();
                System.err.println("Request #" + requestId + " printed in " + TimeUnit.NANOSECONDS.toMicros(end - begin) + " \u00b5s");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        private void formatRequest(HttpServletRequest request, StringBuilder builder) {
            builder.append(request.getRequestURI()).append("\n");
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                builder.append(name).append("=").append(Collections.list(request.getHeaders(name))).append("\n");
            }
            builder.append(request.getRemoteAddr()).append(":").append(request.getRemotePort()).append(" => ");
            builder.append(request.getLocalAddr()).append(":").append(request.getLocalPort()).append("\n");
        }

        private void onLongRequestEnded(long requestId, long time) {
            System.err.println("Request #" + requestId + " lasted " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
        }

        private void formatStackFrames(StackTraceElement[] stackFrames, StringBuilder builder) {
            for (int i = 0; i < stackFrames.length; ++i) {
                StackTraceElement stackFrame = stackFrames[i];
                for (int j = 0; j < i; ++j) {
                    builder.append(" ");
                }
                builder.append(stackFrame).append("\n");
            }
        }
    }

    public static class StatisticsService
    extends AbstractService {
        private final PlatformMonitor monitor = new PlatformMonitor();
        private final CometDLoadServer server;

        private StatisticsService(CometDLoadServer server) {
            super((BayeuxServer)server.bayeuxServer, "statistics-service");
            this.server = server;
            this.addService("/service/statistics/start", "startStatistics");
            this.addService("/service/statistics/stop", "stopStatistics");
            this.addService("/service/statistics/exit", "exit");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startStatistics(ServerSession remote, ServerMessage message) {
            StatisticsService statisticsService = this;
            synchronized (statisticsService) {
                PlatformMonitor.Start start = this.monitor.start();
                if (start != null) {
                    System.err.println();
                    System.err.println(start);
                    this.server.jettyThreadPool.reset();
                    this.server.cometdThreadPool.reset();
                    if (this.server.statisticsHandler != null) {
                        this.server.statisticsHandler.statsReset();
                    }
                    if (this.server.requestLatencyHandler != null) {
                        this.server.requestLatencyHandler.reset();
                        this.server.requestLatencyHandler.doNotTrackCurrentRequest();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopStatistics(ServerSession remote, ServerMessage message) {
            StatisticsService statisticsService = this;
            synchronized (statisticsService) {
                PlatformMonitor.Stop stop = this.monitor.stop();
                if (stop != null) {
                    int dispatched;
                    System.err.println(stop);
                    if (this.server.requestLatencyHandler != null) {
                        this.server.requestLatencyHandler.print();
                        this.server.requestLatencyHandler.doNotTrackCurrentRequest();
                    }
                    if (this.server.statisticsHandler != null && (dispatched = this.server.statisticsHandler.getDispatched()) > 0) {
                        System.err.printf("Requests times (total/avg/max - stddev): %d/%d/%d ms - %d%n", this.server.statisticsHandler.getDispatchedTimeTotal(), Double.valueOf(this.server.statisticsHandler.getDispatchedTimeMean()).longValue(), this.server.statisticsHandler.getDispatchedTimeMax(), Double.valueOf(this.server.statisticsHandler.getDispatchedTimeStdDev()).longValue());
                        System.err.printf("Requests (total/failed/max - rate): %d/%d/%d - %d requests/s%n", dispatched, this.server.statisticsHandler.getResponses4xx() + this.server.statisticsHandler.getResponses5xx(), this.server.statisticsHandler.getDispatchedActiveMax(), this.server.statisticsHandler.getStatsOnMs() == 0L ? -1L : (long)this.server.statisticsHandler.getDispatched() * 1000L / this.server.statisticsHandler.getStatsOnMs());
                    }
                    this.server.messageLatencyExtension.print();
                    System.err.println("========================================");
                    Config.printThreadPool((String)"Jetty Thread Pool", (MonitoringQueuedThreadPool)this.server.jettyThreadPool);
                    Config.printThreadPool((String)"CometD Thread Pool", (MonitoringQueuedThreadPool)this.server.cometdThreadPool);
                    System.err.println();
                }
            }
        }

        public void exit(ServerSession remote, ServerMessage message) {
            remote.disconnect();
            new Thread(() -> {
                try {
                    if (!this.server.interactive) {
                        this.server.server.stop();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }).start();
        }
    }
}

