/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.AbstractTransport;
import org.cometd.common.JSONContext;
import org.cometd.common.JettyJSONContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientTransport
extends AbstractTransport {
    public static final String URL_OPTION = "url";
    public static final String MAX_NETWORK_DELAY_OPTION = "maxNetworkDelay";
    public static final String JSON_CONTEXT_OPTION = "jsonContext";
    public static final String SCHEDULER_OPTION = "scheduler";
    public static final String MAX_MESSAGE_SIZE_OPTION = "maxMessageSize";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String url;
    private long maxNetworkDelay;
    private JSONContext.Client jsonContext;

    protected ClientTransport(String name, String url, Map<String, Object> options) {
        super(name, options);
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void init() {
        Object jsonContextOption;
        Object urlOption = this.getOption(URL_OPTION);
        if (this.url == null) {
            this.url = (String)urlOption;
        }
        if ((jsonContextOption = this.getOption(JSON_CONTEXT_OPTION)) == null) {
            this.jsonContext = new JettyJSONContextClient();
        } else if (jsonContextOption instanceof String) {
            try {
                Class<?> jsonContextClass = Thread.currentThread().getContextClassLoader().loadClass((String)jsonContextOption);
                if (!JSONContext.Client.class.isAssignableFrom(jsonContextClass)) {
                    throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + jsonContextOption);
                }
                this.jsonContext = (JSONContext.Client)jsonContextClass.newInstance();
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + jsonContextOption, x);
            }
        } else if (jsonContextOption instanceof JSONContext.Client) {
            this.jsonContext = (JSONContext.Client)jsonContextOption;
        } else {
            throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + jsonContextOption);
        }
        this.setOption(JSON_CONTEXT_OPTION, this.jsonContext);
    }

    public abstract void abort(Throwable var1);

    public void terminate() {
    }

    public abstract boolean accept(String var1);

    public abstract void send(TransportListener var1, List<Message.Mutable> var2);

    protected List<Message.Mutable> parseMessages(String content) throws ParseException {
        return new ArrayList<Message.Mutable>(Arrays.asList(this.jsonContext.parse(content)));
    }

    protected String generateJSON(List<Message.Mutable> messages) {
        return this.jsonContext.generate(messages);
    }

    public long getMaxNetworkDelay() {
        this.maxNetworkDelay = this.getOption(MAX_NETWORK_DELAY_OPTION, this.maxNetworkDelay);
        return this.maxNetworkDelay;
    }

    protected void setMaxNetworkDelay(long maxNetworkDelay) {
        this.maxNetworkDelay = maxNetworkDelay;
    }

    public static interface FailureHandler {
        public void handle(FailureInfo var1);
    }

    public static class FailureInfo {
        public ClientTransport transport;
        public Throwable cause;
        public String error;
        public String action;
        public String url;
        public long delay;

        public BayeuxClient.State actionToState() {
            switch (this.action) {
                case "handshake": {
                    return BayeuxClient.State.REHANDSHAKING;
                }
                case "none": {
                    return BayeuxClient.State.TERMINATING;
                }
            }
            return BayeuxClient.State.UNCONNECTED;
        }

        public String toString() {
            return String.format("%s@%x[transport=%s,cause=%s,action=%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.transport, this.cause, this.action});
        }
    }

    public static interface Factory {
        public ClientTransport newClientTransport(String var1, Map<String, Object> var2);
    }
}

