/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.MessageClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.transport.TransportRegistry;
import org.cometd.common.AbstractClientSession;
import org.cometd.common.AsyncFoldLeft;
import org.cometd.common.TransportException;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayeuxClient
extends AbstractClientSession
implements Bayeux {
    public static final String BACKOFF_INCREMENT_OPTION = "backoffIncrement";
    public static final String MAX_BACKOFF_OPTION = "maxBackoff";
    public static final String BAYEUX_VERSION = "1.0";
    private final Logger logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Integer.toHexString(System.identityHashCode((Object)this))));
    private final AutoLock.WithCondition lock = new AutoLock.WithCondition();
    private final CopyOnWriteArrayList<TransportListener> transportListeners = new CopyOnWriteArrayList();
    private final TransportRegistry transportRegistry = new TransportRegistry();
    private final Map<String, Object> options = new ConcurrentHashMap<String, Object>();
    private final List<Message.Mutable> messageQueue = new ArrayList<Message.Mutable>(32);
    private final CookieStore cookieStore = new CookieManager().getCookieStore();
    private final TransportListener messageListener = new MessageTransportListener();
    private final SessionState sessionState = new SessionState();
    private final String url;
    private ScheduledExecutorService scheduler;
    private boolean ownScheduler;
    private BackOffStrategy backOffStrategy = new BackOffStrategy.Linear();

    public BayeuxClient(String url, ClientTransport transport, ClientTransport ... transports) {
        this(url, (ScheduledExecutorService)null, transport, transports);
    }

    public BayeuxClient(String url, ScheduledExecutorService scheduler, ClientTransport transport, ClientTransport ... transports) {
        this.url = Objects.requireNonNull(url);
        this.scheduler = scheduler;
        Objects.requireNonNull(transport);
        this.transportRegistry.add(transport);
        for (ClientTransport t : transports) {
            this.transportRegistry.add(t);
        }
        for (String transportName : this.transportRegistry.getKnownTransports()) {
            ClientTransport clientTransport = this.transportRegistry.getTransport(transportName);
            clientTransport.setOption("url", url);
            if (clientTransport instanceof MessageClientTransport) {
                ((MessageClientTransport)((Object)clientTransport)).setMessageTransportListener(this.messageListener);
            }
            if (!(clientTransport instanceof HttpClientTransport)) continue;
            HttpClientTransport httpTransport = (HttpClientTransport)clientTransport;
            httpTransport.setCookieStore(this.cookieStore);
        }
    }

    public String getURL() {
        return this.url;
    }

    public BackOffStrategy getBackOffStrategy() {
        return this.backOffStrategy;
    }

    public void setBackOffStrategy(BackOffStrategy backOffStrategy) {
        this.backOffStrategy = backOffStrategy;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public HttpCookie getCookie(String name) {
        for (HttpCookie cookie : this.getCookieStore().get(URI.create(this.getURL()))) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public void putCookie(HttpCookie cookie) {
        URI uri = URI.create(this.getURL());
        if (cookie.getPath() == null) {
            String path = uri.getPath();
            path = path == null || !path.contains("/") ? "/" : path.substring(0, path.lastIndexOf("/") + 1);
            cookie.setPath(path);
        }
        if (cookie.getDomain() == null) {
            cookie.setDomain(uri.getHost());
        }
        this.getCookieStore().add(uri, cookie);
    }

    public String getId() {
        return this.sessionState.getSessionId();
    }

    public boolean isHandshook() {
        State state = this.getState();
        return state == State.HANDSHAKEN || state == State.CONNECTING || state == State.CONNECTED || state == State.UNCONNECTED;
    }

    public boolean isConnected() {
        return this.getState() == State.CONNECTED;
    }

    public boolean isDisconnected() {
        State state = this.getState();
        return state == State.TERMINATING || state == State.DISCONNECTED;
    }

    protected State getState() {
        return this.sessionState.getState();
    }

    public void addTransportListener(TransportListener listener) {
        this.transportListeners.add(listener);
    }

    public void removeTransportListener(TransportListener listener) {
        this.transportListeners.remove(listener);
    }

    private void notifyTransportSending(List<? extends Message> messages) {
        for (TransportListener listener : this.transportListeners) {
            try {
                listener.onSending(messages);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + String.valueOf(listener), x);
            }
        }
    }

    private void notifyTransportMessages(List<Message.Mutable> messages) {
        for (TransportListener listener : this.transportListeners) {
            try {
                listener.onMessages(messages);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + String.valueOf(listener), x);
            }
        }
    }

    private void notifyTransportFailure(Throwable failure, List<? extends Message> messages) {
        for (TransportListener listener : this.transportListeners) {
            try {
                listener.onFailure(failure, messages);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + String.valueOf(listener), x);
            }
        }
    }

    private void notifyTransportTimeout(List<? extends Message> messages, Promise<Long> promise) {
        AsyncFoldLeft.run(this.transportListeners, (Object)0L, (result, listener, loop) -> {
            try {
                listener.onTimeout(messages, (Promise<Long>)Promise.from(r -> {
                    if (r > 0L) {
                        loop.leave(r);
                    } else {
                        loop.proceed((Object)0L);
                    }
                }, arg_0 -> ((AsyncFoldLeft.Loop)loop).fail(arg_0)));
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + String.valueOf(listener), x);
                loop.fail(x);
            }
        }, promise);
    }

    public void handshake(ClientSession.MessageListener callback) {
        this.handshake(null, callback);
    }

    public void handshake(Map<String, Object> fields, ClientSession.MessageListener callback) {
        State state = this.getState();
        if (state != State.DISCONNECTED) {
            throw new IllegalStateException("Invalid state " + String.valueOf((Object)state));
        }
        this.sessionState.submit(() -> this.sessionState.handshaking(fields, callback));
    }

    public State handshake(long waitMs) {
        return this.handshake(null, waitMs);
    }

    public State handshake(Map<String, Object> template, long waitMs) {
        this.handshake(template);
        this.waitFor(waitMs, State.CONNECTING, State.CONNECTED, State.DISCONNECTED);
        return this.getState();
    }

    protected void sendHandshake() {
        List<ClientTransport> transports = this.transportRegistry.negotiate(this.getAllowedTransports().toArray(), BAYEUX_VERSION);
        ArrayList<String> transportNames = new ArrayList<String>(transports.size());
        for (ClientTransport transport : transports) {
            transportNames.add(transport.getName());
        }
        Message.Mutable message = this.newMessage();
        Map<String, Object> handshakeFields = this.sessionState.getHandshakeFields();
        if (handshakeFields != null) {
            message.putAll(handshakeFields);
        }
        String messageId = this.newMessageId();
        message.setId(messageId);
        message.setChannel("/meta/handshake");
        message.put((Object)"supportedConnectionTypes", transportNames);
        message.put((Object)"version", (Object)BAYEUX_VERSION);
        this.registerCallback(messageId, this.sessionState.getHandshakeCallback());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Handshaking on transport {}: {}", (Object)this.getTransport(), (Object)message);
        }
        List<Message.Mutable> messages = List.of(message);
        this.sendMessages(messages, (Promise<Boolean>)Promise.complete((r, x) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} handshake {}", (Object)(x == null ? "Sent" : "Failed"), (Object)message);
            }
        }));
    }

    public boolean waitFor(long waitMs, State state, State ... states) {
        ArrayList<State> waitForStates = new ArrayList<State>();
        waitForStates.add(state);
        waitForStates.addAll(List.of(states));
        try (AutoLock.WithCondition l = this.lock.lock();){
            while (waitMs > 0L) {
                if (this.sessionState.isIdle()) {
                    State currentState = this.getState();
                    for (State s : waitForStates) {
                        if (!currentState.implies(s)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Waiting {}ms for {}", (Object)waitMs, waitForStates);
                }
                long start = System.nanoTime();
                if (this.sessionState.await(waitMs)) break;
                long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Waited {}/{}ms for {}, state is {}", new Object[]{elapsed, waitMs, waitForStates, this.sessionState.getState()});
                }
                waitMs -= elapsed;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected void sendConnect() {
        ClientTransport transport = this.getTransport();
        if (transport == null) {
            return;
        }
        Message.Mutable message = this.newMessage();
        message.setId(this.newMessageId());
        message.setChannel("/meta/connect");
        message.put((Object)"connectionType", (Object)transport.getName());
        State state = this.getState();
        if (state == State.CONNECTING || state == State.UNCONNECTED) {
            message.getAdvice(true).put("timeout", 0);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connecting, transport {}", (Object)transport);
        }
        List<Message.Mutable> messages = List.of(message);
        this.sendMessages(messages, (Promise<Boolean>)Promise.complete((r, x) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} connect {}", (Object)(x == null ? "Sent" : "Failed"), (Object)message);
            }
        }));
    }

    protected ChannelId newChannelId(String channelId) {
        AbstractClientSession.AbstractSessionChannel channel = (AbstractClientSession.AbstractSessionChannel)this.getChannels().get(channelId);
        return channel == null ? new ChannelId(channelId) : channel.getChannelId();
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new BayeuxClientChannel(channelId);
    }

    protected void sendBatch() {
        List<Message.Mutable> messages;
        if (this.canSend() && !(messages = this.takeMessages()).isEmpty()) {
            this.sendMessages(messages, (Promise<Boolean>)Promise.complete((r, x) -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} batch {}", (Object)(x == null ? "Sent" : "Failed"), (Object)messages);
                }
            }));
        }
    }

    protected void sendMessages(List<Message.Mutable> messages, Promise<Boolean> promise) {
        AsyncFoldLeft.run(messages, new ArrayList(messages.size()), (toSend, message, loop) -> {
            String messageId = message.getId();
            message.setClientId(this.sessionState.sessionId);
            this.extendOutgoing((Message.Mutable)message, Promise.from(extPass -> {
                message.setId(messageId);
                if (extPass.booleanValue()) {
                    toSend.add(message);
                }
                loop.proceed(toSend);
            }, arg_0 -> ((AsyncFoldLeft.Loop)loop).fail(arg_0)));
        }, (Promise)Promise.from(toSend -> {
            List deleted = List.of();
            if (toSend.size() != messages.size()) {
                deleted = new ArrayList(messages);
                deleted.removeAll((Collection<?>)toSend);
            }
            AsyncFoldLeft.run(deleted, null, (result, message, loop) -> {
                Message.Mutable failed = this.newReply((Message)message);
                failed.setSuccessful(false);
                failed.put((Object)"error", (Object)"404::message_deleted");
                this.receive(failed, Promise.from(arg_0 -> ((AsyncFoldLeft.Loop)loop).proceed(arg_0), arg_0 -> ((AsyncFoldLeft.Loop)loop).fail(arg_0)));
            }, (Promise)Promise.from(r -> {
                if (toSend.isEmpty()) {
                    promise.succeed((Object)false);
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Sending messages {}", toSend);
                    }
                    promise.succeed((Object)this.sessionState.send(this.messageListener, (List<Message.Mutable>)toSend));
                }
            }, arg_0 -> ((Promise)promise).fail(arg_0)));
        }, arg_0 -> promise.fail(arg_0)));
    }

    private List<Message.Mutable> takeMessages() {
        ArrayList<Message.Mutable> messages;
        try (AutoLock.WithCondition l = this.lock.lock();){
            messages = new ArrayList<Message.Mutable>(this.messageQueue);
            this.messageQueue.clear();
        }
        return messages;
    }

    public void disconnect(ClientSession.MessageListener callback) {
        this.sessionState.submit(() -> this.sessionState.disconnecting(callback));
    }

    public boolean disconnect(long timeout) {
        if (this.isDisconnected()) {
            return true;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ClientSessionChannel.MessageListener lastConnectListener = (channel, message) -> {
            Map advice = message.getAdvice();
            if (!message.isSuccessful() || advice != null && "none".equals(advice.get("reconnect"))) {
                latch.countDown();
            }
        };
        this.getChannel("/meta/connect").addListener((ClientSessionChannel.ClientSessionChannelListener)lastConnectListener);
        this.disconnect();
        boolean disconnected = this.waitFor(timeout, State.DISCONNECTED, new State[0]);
        try {
            latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        this.getChannel("/meta/connect").removeListener((ClientSessionChannel.ClientSessionChannelListener)lastConnectListener);
        SessionState sessionState = this.sessionState;
        Objects.requireNonNull(sessionState);
        SessionState sessionState2 = sessionState;
        this.sessionState.submit(() -> sessionState2.terminating());
        return disconnected;
    }

    public void abort() {
        this.abort(new IOException("Abort"));
    }

    private void abort(Throwable failure) {
        this.sessionState.submit(() -> {
            if (this.sessionState.update(State.TERMINATING)) {
                this.sessionState.terminate(failure);
            }
        });
    }

    private void processMessages(List<Message.Mutable> messages) {
        for (Message.Mutable message : messages) {
            String channel;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Processing {}", (Object)message);
            }
            if ("/meta/handshake".equals(channel = message.getChannel())) {
                this.processHandshake(message);
                continue;
            }
            if ("/meta/connect".equals(channel)) {
                this.processConnect(message);
                continue;
            }
            if ("/meta/disconnect".equals(channel)) {
                this.processDisconnect(message);
                continue;
            }
            this.processMessage(message);
        }
    }

    protected void messagesFailure(Throwable cause, List<? extends Message> messages) {
        for (Message message : messages) {
            String channel;
            ClientTransport transport;
            Map fields;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Failing {}", (Object)message);
            }
            Message.Mutable failed = this.newReply(message);
            failed.setSuccessful(false);
            HashMap<String, Object> failure = new HashMap<String, Object>();
            failed.put((Object)"failure", failure);
            failure.put("message", message);
            if (cause != null) {
                failure.put("exception", cause);
            }
            if (cause instanceof TransportException && (fields = ((TransportException)cause).getFields()) != null) {
                failure.putAll(fields);
            }
            if ((transport = this.getTransport()) != null) {
                failure.put("connectionType", transport.getName());
            }
            if ("/meta/handshake".equals(channel = message.getChannel())) {
                this.handshakeFailure(failed, cause);
                continue;
            }
            if ("/meta/connect".equals(channel)) {
                this.connectFailure(failed, cause);
                continue;
            }
            if ("/meta/disconnect".equals(channel)) {
                this.disconnectFailure(failed, cause);
                continue;
            }
            this.messageFailure(failed, cause);
        }
    }

    private Message.Mutable newReply(Message message) {
        Message.Mutable reply = this.newMessage();
        reply.setId(message.getId());
        reply.setChannel(message.getChannel());
        if (message.containsKey((Object)"subscription")) {
            reply.put((Object)"subscription", message.get((Object)"subscription"));
        }
        return reply;
    }

    protected void processHandshake(Message.Mutable handshake) {
        if (handshake.isSuccessful()) {
            ClientTransport oldTransport = this.getTransport();
            Object field = handshake.get((Object)"supportedConnectionTypes");
            Object[] serverTransports = field instanceof List ? ((List)field).toArray() : (Object[])field;
            List<ClientTransport> negotiatedTransports = this.transportRegistry.negotiate(serverTransports, BAYEUX_VERSION);
            if (negotiatedTransports.isEmpty()) {
                ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
                failureInfo.transport = null;
                failureInfo.cause = null;
                failureInfo.error = String.format("405:c%s,s%s:no_transport", this.getAllowedTransports(), Arrays.toString(serverTransports));
                failureInfo.action = "none";
                handshake.setSuccessful(false);
                handshake.put((Object)"error", (Object)failureInfo.error);
                this.failHandshake(handshake, failureInfo);
            } else {
                Number messagesField = (Number)handshake.get((Object)"x-messages");
                int messages = messagesField == null ? 0 : messagesField.intValue();
                ClientTransport newTransport = negotiatedTransports.get(0);
                if (newTransport != oldTransport) {
                    this.prepareTransport(oldTransport, newTransport);
                }
                this.sessionState.submit(() -> this.sessionState.handshaken(newTransport, handshake, messages));
            }
        } else {
            ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
            failureInfo.transport = this.getTransport();
            failureInfo.cause = null;
            failureInfo.error = null;
            failureInfo.action = this.sessionState.getAdviceAction(handshake.getAdvice(), "handshake");
            this.failHandshake(handshake, failureInfo);
        }
    }

    private void handshakeFailure(Message.Mutable handshake, Throwable failure) {
        ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
        failureInfo.transport = null;
        failureInfo.cause = failure;
        failureInfo.error = null;
        failureInfo.action = "handshake";
        this.failHandshake(handshake, failureInfo);
    }

    private void failHandshake(Message.Mutable handshake, ClientTransport.FailureInfo failureInfo) {
        this.receive(handshake, Promise.from(r -> {
            if (this.isDisconnected()) {
                failureInfo.action = "none";
            }
            this.onTransportFailure((Message)handshake, failureInfo, this.sessionState);
        }, x -> this.logger.info("Failure while receiving " + String.valueOf(handshake), x)));
    }

    protected void processConnect(Message.Mutable connect) {
        if (this.sessionState.matchMetaConnect(connect)) {
            if (connect.isSuccessful()) {
                this.receive(connect, Promise.from(r -> this.sessionState.submit(() -> this.sessionState.connected((Message)connect)), x -> this.logger.info("Failure while receiving " + String.valueOf(connect), x)));
            } else {
                ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
                failureInfo.transport = this.getTransport();
                failureInfo.cause = null;
                failureInfo.error = null;
                failureInfo.action = this.sessionState.getAdviceAction(connect.getAdvice(), "retry");
                this.failConnect(connect, failureInfo);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mismatched /meta/connect reply: expected reply for {}, received {}", (Object)this.sessionState.getMetaConnect(), (Object)connect);
        }
    }

    private void connectFailure(Message.Mutable connect, Throwable failure) {
        if (this.sessionState.matchMetaConnect(connect)) {
            ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
            failureInfo.transport = null;
            failureInfo.cause = failure;
            failureInfo.error = null;
            failureInfo.action = "retry";
            this.failConnect(connect, failureInfo);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mismatched /meta/connect failure: expected {}, got {}", (Object)this.sessionState.getMetaConnect(), (Object)connect);
        }
    }

    private void failConnect(Message.Mutable connect, ClientTransport.FailureInfo failureInfo) {
        this.receive(connect, Promise.from(r -> {
            if (this.isDisconnected()) {
                failureInfo.action = "none";
            }
            this.onTransportFailure((Message)connect, failureInfo, this.sessionState);
        }, x -> this.logger.info("Failure while receiving " + String.valueOf(connect), x)));
    }

    protected void processDisconnect(Message.Mutable disconnect) {
        if (disconnect.isSuccessful()) {
            this.receive(disconnect, Promise.complete((r, x) -> {
                SessionState sessionState = this.sessionState;
                Objects.requireNonNull(sessionState);
                SessionState rec$ = sessionState;
                this.sessionState.submit(() -> rec$.terminating());
            }));
        } else {
            this.disconnectFailure(disconnect, null);
        }
    }

    private void disconnectFailure(Message.Mutable disconnect, Throwable failure) {
        ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
        failureInfo.transport = this.getTransport();
        failureInfo.cause = failure;
        failureInfo.error = null;
        failureInfo.action = "none";
        this.failDisconnect(disconnect, failureInfo);
    }

    private void failDisconnect(Message.Mutable disconnect, ClientTransport.FailureInfo failureInfo) {
        this.receive(disconnect, Promise.complete((r, x) -> this.onTransportFailure((Message)disconnect, failureInfo, this.sessionState)));
    }

    protected void processMessage(Message.Mutable message) {
        this.receive(message, Promise.from(r -> {
            if (this.getState() == State.HANDSHAKEN) {
                SessionState sessionState = this.sessionState;
                Objects.requireNonNull(sessionState);
                SessionState rec$ = sessionState;
                this.sessionState.submit(() -> rec$.afterHandshaken());
            }
        }, this::abort));
    }

    private void messageFailure(Message.Mutable message, Throwable failure) {
        this.failMessage(message);
    }

    private void failMessage(Message.Mutable message) {
        this.receive(message, Promise.from(r -> {}, x -> this.logger.info("Failure while receiving " + String.valueOf(message), x)));
    }

    protected boolean scheduleHandshake(long interval, long backOff) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Scheduled handshake in {}+{} ms", (Object)interval, (Object)backOff);
        }
        return this.scheduleAction(this::sendHandshake, interval, backOff);
    }

    protected boolean scheduleConnect(long interval, long backOff) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Scheduled connect in {}+{} ms", (Object)interval, (Object)backOff);
        }
        return this.scheduleAction(this::sendConnect, interval, backOff);
    }

    private boolean scheduleAction(Runnable action, long interval, long backoff) {
        ScheduledExecutorService scheduler = this.scheduler;
        if (scheduler != null) {
            try {
                scheduler.schedule(action, interval + backoff, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (RejectedExecutionException x) {
                this.logger.trace("", (Throwable)x);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Could not schedule action {} to scheduler {}", (Object)action, (Object)scheduler);
        }
        return false;
    }

    public List<String> getAllowedTransports() {
        return this.transportRegistry.getAllowedTransports();
    }

    public Set<String> getKnownTransportNames() {
        return this.transportRegistry.getKnownTransports();
    }

    public ClientTransport getTransport(String transport) {
        return this.transportRegistry.getTransport(transport);
    }

    public ClientTransport getTransport() {
        return this.sessionState.getTransport();
    }

    protected void initialize() {
        BackOffStrategy backOffStrategy = this.getBackOffStrategy();
        if (backOffStrategy instanceof BackOffStrategy.Linear) {
            BackOffStrategy.Linear linear = (BackOffStrategy.Linear)backOffStrategy;
            Number value = (Number)this.getOption(BACKOFF_INCREMENT_OPTION);
            long increment = linear.increment;
            if (value != null) {
                increment = value.longValue();
            }
            value = (Number)this.getOption(MAX_BACKOFF_OPTION);
            long maximum = linear.maximum;
            if (value != null) {
                maximum = value.longValue();
            }
            if (increment > 0L && increment != linear.increment || maximum != linear.maximum) {
                this.setBackOffStrategy(new BackOffStrategy.Linear(increment, maximum));
            }
        }
        if (this.scheduler == null) {
            this.scheduler = new Scheduler(1);
            this.ownScheduler = true;
        }
        this.setOption("scheduler", this.scheduler);
    }

    protected void terminate(Throwable failure) {
        List<Message.Mutable> messages = this.takeMessages();
        this.messagesFailure(failure, messages);
        this.cookieStore.removeAll();
        if (this.ownScheduler) {
            this.scheduler.shutdown();
            this.scheduler = null;
            this.ownScheduler = false;
        }
    }

    public Object getOption(String qualifiedName) {
        return this.options.get(qualifiedName);
    }

    public void setOption(String qualifiedName, Object value) {
        this.options.put(qualifiedName, value);
        for (String name : this.transportRegistry.getKnownTransports()) {
            ClientTransport transport = this.transportRegistry.getTransport(name);
            transport.setOption(qualifiedName, value);
        }
    }

    public Set<String> getOptionNames() {
        return this.options.keySet();
    }

    public Map<String, Object> getOptions() {
        return Map.copyOf(this.options);
    }

    protected void send(Message.Mutable message) {
        this.enqueueSend(message);
    }

    protected void enqueueSend(Message.Mutable message) {
        if (this.canSend()) {
            List<Message.Mutable> messages = List.of(message);
            this.sendMessages(messages, (Promise<Boolean>)Promise.complete((r, x) -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} message {}", (Object)(x == null ? "Sent" : "Failed"), (Object)message);
                }
            }));
        } else {
            try (AutoLock.WithCondition l = this.lock.lock();){
                this.messageQueue.add(message);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Enqueued message {} (batching: {})", (Object)message, (Object)this.isBatching());
            }
        }
    }

    private boolean canSend() {
        State state = this.getState();
        boolean handshaking = state == State.HANDSHAKING || state == State.REHANDSHAKING;
        return !this.isBatching() && !handshaking;
    }

    private void prepareTransport(ClientTransport oldTransport, ClientTransport newTransport) {
        if (oldTransport != null) {
            oldTransport.terminate();
        }
        newTransport.init();
    }

    protected void onTransportFailure(Message message, ClientTransport.FailureInfo failureInfo, ClientTransport.FailureHandler handler) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Transport failure: {} for {}", (Object)failureInfo, (Object)message);
        }
        if ("none".equals(failureInfo.action)) {
            ClientTransport transport;
            if ("/meta/handshake".equals(message.getChannel()) && (transport = this.getTransport()) != null && failureInfo.transport == null) {
                this.onTransportFailure(transport.getName(), null, failureInfo.cause);
            }
        } else {
            failureInfo.delay = this.getBackOffStrategy().current();
            if ("/meta/handshake".equals(message.getChannel())) {
                if (failureInfo.transport == null) {
                    List<ClientTransport> transports = this.transportRegistry.negotiate(this.getAllowedTransports().toArray(), BAYEUX_VERSION);
                    if (transports.isEmpty()) {
                        this.onTransportFailure(this.getTransport().getName(), null, failureInfo.cause);
                        failureInfo.action = "none";
                    } else {
                        ClientTransport oldTransport = this.getTransport();
                        ClientTransport newTransport = transports.get(0);
                        if (newTransport != oldTransport) {
                            this.prepareTransport(oldTransport, newTransport);
                        }
                        this.onTransportFailure(oldTransport.getName(), newTransport.getName(), failureInfo.cause);
                        failureInfo.transport = newTransport;
                        failureInfo.action = "handshake";
                    }
                }
                if (!"none".equals(failureInfo.action)) {
                    this.sessionState.increaseBackOff();
                }
            } else {
                this.sessionState.initUnconnectTime();
                if ("retry".equals(failureInfo.action)) {
                    failureInfo.delay = this.sessionState.increaseBackOff();
                    if (this.sessionState.nextConnectExceedsMaxInterval()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Switching to handshake retries");
                        }
                        failureInfo.action = "handshake";
                    }
                }
                if ("handshake".equals(failureInfo.action)) {
                    failureInfo.delay = 0L;
                    this.sessionState.resetBackOff();
                }
            }
        }
        handler.handle(failureInfo);
    }

    protected void onTransportFailure(String oldTransportName, String newTransportName, Throwable failure) {
    }

    public String toString() {
        return String.format("%s@%x[%s][%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getId(), this.sessionState);
    }

    private class MessageTransportListener
    implements TransportListener {
        private MessageTransportListener() {
        }

        @Override
        public void onSending(List<? extends Message> messages) {
            BayeuxClient.this.notifyTransportSending(messages);
        }

        @Override
        public void onMessages(List<Message.Mutable> messages) {
            BayeuxClient.this.notifyTransportMessages(messages);
            BayeuxClient.this.processMessages(messages);
        }

        @Override
        public void onFailure(Throwable failure, List<? extends Message> messages) {
            BayeuxClient.this.notifyTransportFailure(failure, messages);
            BayeuxClient.this.messagesFailure(failure, messages);
        }

        @Override
        public void onTimeout(List<? extends Message> messages, Promise<Long> promise) {
            BayeuxClient.this.notifyTransportTimeout(messages, promise);
        }
    }

    private class SessionState
    implements ClientTransport.FailureHandler {
        private final Queue<Runnable> actions = new ArrayDeque<Runnable>();
        private State state = State.DISCONNECTED;
        private ClientTransport transport;
        private Map<String, Object> handshakeFields;
        private ClientSession.MessageListener handshakeCallback;
        private Map<String, Object> advice;
        private String sessionId;
        private long unconnectTime;
        private boolean active;
        private int handshakeMessages;
        private Message metaConnect;

        private SessionState() {
        }

        private void reset() {
            this.actions.clear();
            this.state = State.DISCONNECTED;
            this.transport = null;
            this.handshakeFields = null;
            this.handshakeCallback = null;
            this.advice = null;
            this.sessionId = null;
            this.resetBackOff();
            this.unconnectTime = 0L;
            this.active = false;
            this.handshakeMessages = 0;
            this.metaConnect = null;
        }

        private State getState() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                State state = this.state;
                return state;
            }
        }

        private ClientTransport getTransport() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                ClientTransport clientTransport = this.transport;
                return clientTransport;
            }
        }

        private Map<String, Object> getHandshakeFields() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                Map<String, Object> map = this.handshakeFields;
                return map;
            }
        }

        private ClientSession.MessageListener getHandshakeCallback() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                ClientSession.MessageListener messageListener = this.handshakeCallback;
                return messageListener;
            }
        }

        private Map<String, Object> getAdvice() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                Map<String, Object> map = this.advice;
                return map;
            }
        }

        private String getSessionId() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                String string = this.sessionId;
                return string;
            }
        }

        private long getUnconnectTime() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                if (this.unconnectTime == 0L) {
                    long l2 = 0L;
                    return l2;
                }
                long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.unconnectTime);
                return l3;
            }
        }

        private long getTimeout() {
            return this.getAdviceLong("timeout");
        }

        private long getInterval() {
            return this.getAdviceLong("interval");
        }

        private long getMaxInterval() {
            return this.getAdviceLong("maxInterval");
        }

        private String getAdviceAction(Map<String, Object> advice, String defaultAction) {
            String result = null;
            if (advice == null) {
                advice = this.getAdvice();
            }
            if (advice != null) {
                result = (String)advice.get("reconnect");
            }
            return result == null ? defaultAction : result;
        }

        private long getAdviceLong(String field) {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                long result = 0L;
                if (this.advice != null && this.advice.containsKey(field)) {
                    result = ((Number)this.advice.get(field)).longValue();
                }
                long l2 = result;
                return l2;
            }
        }

        private long increaseBackOff() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                long l2 = BayeuxClient.this.getBackOffStrategy().next();
                return l2;
            }
        }

        private void resetBackOff() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                BayeuxClient.this.getBackOffStrategy().reset();
            }
        }

        private void handshaking(Map<String, Object> handshakeFields, ClientSession.MessageListener handshakeCallback) {
            if (this.update(State.HANDSHAKING)) {
                BayeuxClient.this.initialize();
                List<String> allowedTransports = BayeuxClient.this.getAllowedTransports();
                ClientTransport transport = BayeuxClient.this.transportRegistry.negotiate(allowedTransports.toArray(), BayeuxClient.BAYEUX_VERSION).get(0);
                BayeuxClient.this.prepareTransport(null, transport);
                if (BayeuxClient.this.logger.isDebugEnabled()) {
                    BayeuxClient.this.logger.debug("Using initial transport {} from {}", (Object)transport.getName(), allowedTransports);
                }
                try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                    this.transport = transport;
                    this.handshakeFields = handshakeFields;
                    this.handshakeCallback = handshakeCallback;
                }
                BayeuxClient.this.resetSubscriptions();
                BayeuxClient.this.sendHandshake();
            }
        }

        private void rehandshaking(long backOff) {
            boolean result;
            State oldState;
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                oldState = this.state;
                result = this.update(State.REHANDSHAKING);
            }
            if (result) {
                if (oldState != State.HANDSHAKING) {
                    BayeuxClient.this.resetSubscriptions();
                }
                BayeuxClient.this.scheduleHandshake(this.getInterval(), backOff);
            }
        }

        private void handshaken(ClientTransport transport, Message.Mutable handshake, int messages) {
            boolean updated;
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                updated = this.update(State.HANDSHAKEN);
                if (updated) {
                    this.transport = transport;
                    this.advice = handshake.getAdvice();
                    this.sessionId = handshake.getClientId();
                    this.handshakeMessages = messages;
                    this.resetBackOff();
                }
            }
            if (updated) {
                BayeuxClient.this.receive(handshake, Promise.from(r -> {
                    BayeuxClient.this.sendBatch();
                    if (messages == 0) {
                        this.connecting();
                    }
                }, x -> BayeuxClient.this.logger.info("Failure while receiving " + String.valueOf(handshake), x)));
            }
        }

        private void afterHandshaken() {
            boolean connect = false;
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                if (this.getState() == State.HANDSHAKEN) {
                    if (this.handshakeMessages > 0) {
                        --this.handshakeMessages;
                    }
                    connect = this.handshakeMessages == 0;
                }
            }
            if (connect) {
                this.connecting();
            }
        }

        private void connecting() {
            if (this.update(State.CONNECTING)) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), 0L);
            }
        }

        private void connected(Message connect) {
            boolean updated;
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                updated = this.update(State.CONNECTED);
                if (updated) {
                    this.resetBackOff();
                    this.unconnectTime = 0L;
                    Map advice = connect.getAdvice();
                    if (advice != null) {
                        this.advice = advice;
                    }
                }
            }
            if (updated) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), 0L);
            }
        }

        private void unconnected(long backOff) {
            if (this.update(State.UNCONNECTED)) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), backOff);
            }
        }

        private boolean nextConnectExceedsMaxInterval() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                long maxInterval = this.getMaxInterval();
                if (maxInterval > 0L) {
                    long expiration = this.getTimeout() + this.getInterval() + maxInterval;
                    boolean bl = this.getUnconnectTime() + BayeuxClient.this.getBackOffStrategy().current() > expiration;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }

        private void disconnecting(ClientSession.MessageListener callback) {
            if (this.update(State.DISCONNECTING)) {
                Message.Mutable message = BayeuxClient.this.newMessage();
                String messageId = BayeuxClient.this.newMessageId();
                message.setId(messageId);
                message.setChannel("/meta/disconnect");
                BayeuxClient.this.registerCallback(messageId, callback);
                List<Message.Mutable> messages = List.of(message);
                BayeuxClient.this.sendMessages(messages, (Promise<Boolean>)Promise.complete((r, x) -> {
                    if (BayeuxClient.this.logger.isDebugEnabled()) {
                        BayeuxClient.this.logger.debug("{} disconnect {}", (Object)(x == null ? "Sent" : "Failed"), (Object)message);
                    }
                }));
            }
        }

        private void terminating() {
            if (this.update(State.TERMINATING)) {
                this.terminate(null);
            }
        }

        private boolean update(State newState) {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                State oldState = this.state;
                boolean result = this.state.isUpdateableTo(newState);
                if (result) {
                    this.state = newState;
                }
                if (BayeuxClient.this.logger.isDebugEnabled()) {
                    BayeuxClient.this.logger.debug("State {}updated: {} -> {}", new Object[]{result ? "" : "not ", oldState, newState});
                }
                boolean bl = result;
                return bl;
            }
        }

        private void terminate(Throwable failure) {
            if (failure != null) {
                this.transport.abort(failure);
            } else {
                this.transport.terminate();
            }
            BayeuxClient.this.terminate(failure);
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                this.update(State.DISCONNECTED);
                this.reset();
            }
        }

        private void submit(Runnable action) {
            boolean empty;
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                empty = this.actions.isEmpty();
                this.actions.offer(action);
            }
            if (empty && this.process()) {
                l = BayeuxClient.this.lock.lock();
                try {
                    if (BayeuxClient.this.logger.isDebugEnabled()) {
                        BayeuxClient.this.logger.debug("Notifying threads in waitFor()");
                    }
                    l.signalAll();
                }
                finally {
                    if (l != null) {
                        l.close();
                    }
                }
            }
        }

        private boolean process() {
            boolean looping = false;
            while (true) {
                Runnable action;
                try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                    if (!looping && this.active) {
                        boolean bl = false;
                        return bl;
                    }
                    action = this.actions.poll();
                    if (action == null) {
                        this.active = false;
                        boolean bl = true;
                        return bl;
                    }
                    if (!looping) {
                        looping = true;
                        this.active = true;
                    }
                }
                action.run();
            }
        }

        private boolean send(TransportListener messageListener, List<Message.Mutable> messages) {
            if (BayeuxClient.this.isDisconnected()) {
                BayeuxClient.this.messagesFailure((Throwable)new TransportException(null), messages);
                return false;
            }
            for (Message.Mutable message : messages) {
                Message existing;
                if (!"/meta/connect".equals(message.getChannel())) continue;
                try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                    existing = this.metaConnect;
                    this.metaConnect = message;
                }
                if (!BayeuxClient.this.logger.isDebugEnabled()) continue;
                if (existing != null) {
                    BayeuxClient.this.logger.debug("Overwriting existing /meta/connect {}", (Object)existing);
                }
                BayeuxClient.this.logger.debug("Sending /meta/connect {}", (Object)message);
            }
            this.transport.send(messageListener, messages);
            return true;
        }

        private boolean matchMetaConnect(Message.Mutable connect) {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                if (State.DISCONNECTED.implies(this.state)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.metaConnect != null && this.metaConnect.getId().equals(connect.getId())) {
                    this.metaConnect = null;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        private Message getMetaConnect() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                Message message = this.metaConnect;
                return message;
            }
        }

        private boolean isIdle() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                boolean bl = !this.active;
                return bl;
            }
        }

        private boolean await(long time) {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                l.await(time, TimeUnit.MILLISECONDS);
                boolean bl = false;
                return bl;
            }
        }

        private void initUnconnectTime() {
            try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                if (this.unconnectTime == 0L) {
                    this.unconnectTime = System.nanoTime();
                }
            }
        }

        @Override
        public void handle(ClientTransport.FailureInfo failureInfo) {
            if (BayeuxClient.this.logger.isDebugEnabled()) {
                BayeuxClient.this.logger.debug("Transport failure handling: {}", (Object)failureInfo);
            }
            this.submit(() -> {
                State newState = failureInfo.actionToState();
                try (AutoLock.WithCondition l = BayeuxClient.this.lock.lock();){
                    String url;
                    ClientTransport newTransport = failureInfo.transport;
                    if (newTransport != null) {
                        this.transport = newTransport;
                    }
                    if ((url = failureInfo.url) != null) {
                        this.transport.setURL(url);
                    }
                }
                switch (newState.ordinal()) {
                    case 2: {
                        this.rehandshaking(failureInfo.delay);
                        break;
                    }
                    case 0: {
                        this.unconnected(failureInfo.delay);
                        break;
                    }
                    case 7: {
                        this.terminating();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Could not handle transport failure in state " + String.valueOf((Object)newState));
                    }
                }
            });
        }

        public String toString() {
            return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.state});
        }
    }

    public static interface BackOffStrategy {
        public long current();

        public long next();

        public void reset();

        public static class Linear
        implements BackOffStrategy {
            private final AutoLock lock = new AutoLock();
            private final long increment;
            private final long maximum;
            private long backOff;

            public Linear() {
                this(1000L, 30000L);
            }

            public Linear(long increment, long maximum) {
                this.increment = increment;
                this.maximum = maximum;
            }

            @Override
            public long current() {
                try (AutoLock l = this.lock.lock();){
                    long l2 = this.backOff;
                    return l2;
                }
            }

            @Override
            public long next() {
                try (AutoLock l = this.lock.lock();){
                    long newBackOff = this.backOff + this.increment;
                    if (this.maximum > 0L && newBackOff > this.maximum) {
                        newBackOff = this.maximum;
                    }
                    long l2 = this.backOff = newBackOff;
                    return l2;
                }
            }

            @Override
            public void reset() {
                try (AutoLock l = this.lock.lock();){
                    this.backOff = 0L;
                }
            }
        }

        public static class Constant
        implements BackOffStrategy {
            private final long delay;
            private volatile long backOff;

            public Constant(long delay) {
                this.delay = delay;
            }

            @Override
            public long current() {
                return this.backOff;
            }

            @Override
            public long next() {
                this.backOff = this.delay;
                return this.backOff;
            }

            @Override
            public void reset() {
                this.backOff = 0L;
            }
        }
    }

    public static enum State {
        UNCONNECTED(new State[0]),
        HANDSHAKING(new State[0]),
        REHANDSHAKING(new State[0]),
        HANDSHAKEN(HANDSHAKING, REHANDSHAKING),
        CONNECTING(HANDSHAKING, REHANDSHAKING, HANDSHAKEN),
        CONNECTED(HANDSHAKING, REHANDSHAKING, HANDSHAKEN, CONNECTING),
        DISCONNECTING(new State[0]),
        TERMINATING(DISCONNECTING),
        DISCONNECTED(DISCONNECTING, TERMINATING);

        private final State[] implieds;

        private State(State ... implieds) {
            this.implieds = implieds;
        }

        private boolean implies(State state) {
            if (state == this) {
                return true;
            }
            for (State implied : this.implieds) {
                if (state != implied) continue;
                return true;
            }
            return false;
        }

        private boolean isUpdateableTo(State newState) {
            switch (this.ordinal()) {
                case 8: {
                    return newState == HANDSHAKING;
                }
                case 1: 
                case 2: {
                    return EnumSet.of(REHANDSHAKING, HANDSHAKEN, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case 3: {
                    return EnumSet.of(CONNECTING, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case 0: 
                case 4: 
                case 5: {
                    return EnumSet.of(REHANDSHAKING, CONNECTED, UNCONNECTED, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case 6: {
                    return newState == TERMINATING;
                }
                case 7: {
                    return newState == DISCONNECTED;
                }
            }
            throw new IllegalStateException("Could not update state from " + String.valueOf((Object)this) + " to " + String.valueOf((Object)newState));
        }
    }

    protected class BayeuxClientChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected BayeuxClientChannel(ChannelId channelId) {
            super((AbstractClientSession)BayeuxClient.this, channelId);
        }

        public ClientSession getSession() {
            this.throwIfReleased();
            return BayeuxClient.this;
        }

        protected void nonFirstSubscribe(Message.Mutable message, ClientSessionChannel.MessageListener listener, ClientSession.MessageListener callback) {
            BayeuxClient.this.scheduleAction(() -> super.nonFirstSubscribe(message, listener, callback), 0L, 0L);
        }

        protected void nonLastUnSubscribe(Message.Mutable message, ClientSessionChannel.MessageListener listener, ClientSession.MessageListener callback) {
            BayeuxClient.this.scheduleAction(() -> super.nonLastUnSubscribe(message, listener, callback), 0L, 0L);
        }
    }

    public static class Scheduler
    extends ScheduledThreadPoolExecutor {
        public Scheduler(int threads) {
            super(threads);
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.setRemoveOnCancelPolicy(true);
        }
    }
}

