/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.http.common;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClientTransport
extends HttpClientTransport {
    public static final String NAME = "long-polling";
    public static final String PREFIX = "long-polling.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpClientTransport.class);
    private boolean _aborted;
    private int _maxMessageSize;
    private boolean _appendMessageType;
    private Map<String, Object> _advice;

    @Deprecated
    protected AbstractHttpClientTransport(String url, Map<String, Object> options) {
        this(url, options, null);
    }

    protected AbstractHttpClientTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler) {
        super(NAME, url, options, scheduler);
        this.setOptionPrefix(PREFIX);
    }

    public boolean accept(String bayeuxVersion) {
        return true;
    }

    public void init() {
        super.init();
        this._aborted = false;
        this._maxMessageSize = this.getOption("maxMessageSize", 0x100000);
        Pattern uriRegexp = Pattern.compile("(^https?://(((\\[[^]]+])|([^:/?#]+))(:(\\d+))?))?([^?#]*)(.*)?");
        Matcher uriMatcher = uriRegexp.matcher(this.getURL());
        if (uriMatcher.matches()) {
            String afterPath = uriMatcher.group(9);
            this._appendMessageType = afterPath == null || afterPath.trim().length() == 0;
        }
        this.initScheduler();
    }

    public void terminate() {
        this.shutdownScheduler();
        super.terminate();
    }

    public void abort(Throwable failure) {
        this._aborted = true;
        this.shutdownScheduler();
    }

    protected boolean isAborted() {
        return this._aborted;
    }

    public int getMaxMessageSize() {
        return this._maxMessageSize;
    }

    protected boolean isAppendMessageType() {
        return this._appendMessageType;
    }

    protected String newRequestURI(List<Message.Mutable> messages) {
        Message.Mutable message;
        String url = this.getURL();
        if (this.isAppendMessageType() && messages.size() == 1 && (message = messages.get(0)).isMeta()) {
            String type = message.getChannel().substring("/meta".length());
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url + type;
        }
        return url;
    }

    protected Map<String, Object> getAdvice() {
        return this._advice;
    }

    protected void setAdvice(Map<String, Object> advice) {
        this._advice = advice;
    }

    protected long calculateMaxNetworkDelay(List<Message.Mutable> messages) {
        Message.Mutable message;
        long maxNetworkDelay = this.getMaxNetworkDelay();
        if (messages.size() == 1 && "/meta/connect".equals((message = messages.get(0)).getChannel())) {
            Map<String, Object> advice = message.getAdvice();
            if (advice == null) {
                advice = this.getAdvice();
            }
            if (advice != null) {
                Object timeout = advice.get("timeout");
                if (timeout instanceof Number) {
                    maxNetworkDelay += ((Number)timeout).longValue();
                } else if (timeout != null) {
                    maxNetworkDelay += Long.parseLong(timeout.toString());
                }
            }
        }
        return maxNetworkDelay;
    }

    protected void processResponseContent(TransportListener listener, List<Message.Mutable> requestMessages, String content) {
        if (content != null && content.length() > 0) {
            try {
                List messages = this.parseMessages(content);
                this.processResponseMessages(listener, messages);
            }
            catch (ParseException x) {
                listener.onFailure((Throwable)x, requestMessages);
            }
        } else {
            HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
            failure.put("httpCode", 204);
            TransportException x = new TransportException(failure);
            listener.onFailure((Throwable)x, requestMessages);
        }
    }

    protected void processResponseMessages(TransportListener listener, List<Message.Mutable> messages) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received messages {}", messages);
        }
        for (Message.Mutable message : messages) {
            Map advice;
            if (!message.isSuccessful() || !"/meta/connect".equals(message.getChannel()) || (advice = message.getAdvice()) == null || !advice.containsKey("timeout")) continue;
            this.setAdvice(advice);
        }
        listener.onMessages(messages);
    }

    protected void processWrongResponseCode(TransportListener listener, List<Message.Mutable> messages, int code) {
        HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
        failure.put("httpCode", code);
        TransportException x = new TransportException(failure);
        listener.onFailure((Throwable)x, messages);
    }
}

