/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.websocket.javax;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpCookie;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.websocket.common.AbstractWebSocketTransport;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends AbstractWebSocketTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketTransport.class);
    private final WebSocketContainer _webSocketContainer;
    private boolean _webSocketSupported;
    private boolean _webSocketConnected;

    public WebSocketTransport(Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketContainer webSocketContainer) {
        this(null, options, scheduler, webSocketContainer);
    }

    public WebSocketTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketContainer webSocketContainer) {
        super(url, options, scheduler);
        this._webSocketContainer = webSocketContainer;
        this._webSocketSupported = true;
    }

    public boolean accept(String version) {
        return this._webSocketSupported;
    }

    public void init() {
        super.init();
        this._webSocketContainer.setDefaultMaxSessionIdleTimeout(this.getIdleTimeout());
        int maxMessageSize = this.getOption("maxMessageSize", this._webSocketContainer.getDefaultMaxTextMessageBufferSize());
        this._webSocketContainer.setDefaultMaxTextMessageBufferSize(maxMessageSize);
        this._webSocketSupported = true;
        this._webSocketConnected = false;
    }

    protected AbstractWebSocketTransport.Delegate connect(String uri, TransportListener listener, List<Message.Mutable> messages) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Opening websocket session to {}", (Object)uri);
            }
            this._webSocketContainer.setDefaultMaxSessionIdleTimeout(this.getIdleTimeout());
            Configurator configurator = new Configurator();
            String protocol = this.getProtocol();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().preferredSubprotocols(protocol == null ? null : List.of(protocol)).configurator((ClientEndpointConfig.Configurator)configurator).build();
            AbstractWebSocketTransport.Delegate delegate = this.connect(this._webSocketContainer, config, uri);
            this._webSocketConnected = true;
            return delegate;
        }
        catch (ConnectException | SocketTimeoutException | UnresolvedAddressException x) {
            listener.onFailure((Throwable)x, messages);
        }
        catch (Throwable x) {
            this._webSocketSupported = this.isStickyReconnect() && this._webSocketConnected;
            listener.onFailure(x, messages);
        }
        return null;
    }

    protected AbstractWebSocketTransport.Delegate connect(WebSocketContainer container, ClientEndpointConfig configuration, String uri) throws IOException {
        try {
            WebSocketDelegate delegate = this.newDelegate();
            container.connectToServer(delegate._endpoint, configuration, new URI(uri));
            return delegate;
        }
        catch (URISyntaxException | DeploymentException x) {
            throw new IOException(x);
        }
    }

    protected WebSocketDelegate newDelegate() {
        return new WebSocketDelegate();
    }

    protected void onHandshakeRequest(Map<String, List<String>> headers) {
        List cookies = this.getCookies(URI.create(this.getURL()));
        if (!cookies.isEmpty()) {
            List<String> cookieHeader = headers.get("Cookie");
            if (cookieHeader == null) {
                cookieHeader = headers.get("Cookie".toLowerCase(Locale.ENGLISH));
            }
            if (cookieHeader == null) {
                cookieHeader = new ArrayList<String>();
                headers.put("Cookie", cookieHeader);
            }
            for (HttpCookie cookie : cookies) {
                cookieHeader.add(cookie.getName() + "=" + cookie.getValue());
            }
        }
    }

    protected void onHandshakeResponse(HandshakeResponse response) {
        Map headers = response.getHeaders();
        this.storeCookies(URI.create(this.getURL()), headers);
        this._webSocketSupported = false;
        for (String name : headers.keySet()) {
            if (!"Sec-WebSocket-Accept".equalsIgnoreCase(name)) continue;
            this._webSocketSupported = true;
            break;
        }
    }

    private class Configurator
    extends ClientEndpointConfig.Configurator {
        private Configurator() {
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            WebSocketTransport.this.onHandshakeRequest(headers);
        }

        public void afterResponse(HandshakeResponse hr) {
            WebSocketTransport.this.onHandshakeResponse(hr);
        }
    }

    public class WebSocketDelegate
    extends AbstractWebSocketTransport.Delegate
    implements MessageHandler.Whole<String> {
        private final Endpoint _endpoint;
        private Session _session;

        public WebSocketDelegate() {
            super((AbstractWebSocketTransport)WebSocketTransport.this);
            this._endpoint = new WebSocketEndpoint();
        }

        private void onOpen(Session session) {
            WebSocketTransport.this.locked(() -> {
                this._session = session;
                return this._session;
            });
            session.addMessageHandler((MessageHandler)this);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Opened websocket session {}", (Object)session);
            }
        }

        public void onMessage(String data) {
            this.onData(data);
        }

        public void send(String content) {
            Session session = (Session)WebSocketTransport.this.locked(() -> this._session);
            try {
                if (session == null) {
                    throw new IOException("Unconnected");
                }
                long timeout = WebSocketTransport.this.getIdleTimeout() + 1000L;
                session.getAsyncRemote().sendText(content).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException x) {
                this.fail(x, "Timeout");
            }
            catch (ExecutionException x) {
                this.fail(x.getCause(), "Exception");
            }
            catch (Throwable x) {
                this.fail(x, "Failure");
            }
        }

        protected void shutdown(String reason) {
            Session session = (Session)WebSocketTransport.this.locked(() -> {
                Session result = this._session;
                this.close();
                return result;
            });
            if (session != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing ({}) websocket session {}", (Object)reason, (Object)session);
                }
                try {
                    reason = this.trimCloseReason(reason);
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, reason));
                }
                catch (Throwable x) {
                    LOGGER.trace("Could not close websocket session " + session, x);
                }
            }
        }

        protected boolean isOpen() {
            return (Boolean)WebSocketTransport.this.locked(() -> super.isOpen() && this._session != null);
        }

        protected void close() {
            WebSocketTransport.this.locked(() -> {
                this._session = null;
                return null;
            });
        }

        public class WebSocketEndpoint
        extends Endpoint {
            public void onOpen(Session session, EndpointConfig config) {
                WebSocketDelegate.this.onOpen(session);
            }

            public void onClose(Session session, CloseReason closeReason) {
                WebSocketDelegate.this.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
            }

            public void onError(Session session, Throwable failure) {
                WebSocketDelegate.this.failMessages(failure);
            }
        }
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final WebSocketContainer container = ContainerProvider.getWebSocketContainer();

        public Factory() {
            this.addBean(this.container, false);
        }

        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)options.get("scheduler");
            return new WebSocketTransport(url, options, scheduler, this.container);
        }
    }
}

