/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.websocket.jetty;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.websocket.common.AbstractWebSocketTransport;
import org.cometd.common.TransportException;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.exceptions.UpgradeException;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.JettyUpgradeListener;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport
implements JettyUpgradeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyWebSocketTransport.class);
    private final WebSocketClient _webSocketClient;
    private boolean _webSocketSupported;
    private boolean _webSocketConnected;

    public JettyWebSocketTransport(Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketClient webSocketClient) {
        this(null, options, scheduler, webSocketClient);
    }

    public JettyWebSocketTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketClient webSocketClient) {
        super(url, options, scheduler);
        this._webSocketClient = webSocketClient;
        this._webSocketSupported = true;
    }

    public boolean accept(String version) {
        return this._webSocketSupported;
    }

    public void init() {
        super.init();
        this._webSocketClient.setConnectTimeout(this.getConnectTimeout());
        this._webSocketClient.setIdleTimeout(Duration.ofMillis(this.getIdleTimeout()));
        long maxMessageSize = this.getOption("maxMessageSize", this._webSocketClient.getMaxTextMessageSize());
        this._webSocketClient.setMaxTextMessageSize(maxMessageSize);
        this._webSocketSupported = true;
        this._webSocketConnected = false;
    }

    protected AbstractWebSocketTransport.Delegate connect(String uriString, TransportListener listener, List<Message.Mutable> messages) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Opening websocket session to {}", (Object)uriString);
            }
            URI uri = URI.create(uriString);
            ClientUpgradeRequest request = new ClientUpgradeRequest(uri);
            List cookies = this.getHttpCookieStore().match(uri);
            request.setCookies(cookies.stream().map(HttpCookie::asJavaNetHttpCookie).toList());
            String protocol = this.getProtocol();
            if (protocol != null) {
                request.setSubProtocols(new String[]{protocol});
            }
            if (this.isPerMessageDeflateEnabled()) {
                request.addExtensions(new String[]{"permessage-deflate"});
            }
            AbstractWebSocketTransport.Delegate delegate = this.connect(this._webSocketClient, request);
            this._webSocketConnected = true;
            return delegate;
        }
        catch (ConnectException | SocketTimeoutException | UnknownHostException | UnresolvedAddressException x) {
            listener.onFailure((Throwable)x, messages);
        }
        catch (UpgradeException x) {
            this._webSocketSupported = false;
            HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
            failure.put("websocketCode", 1002);
            failure.put("httpCode", x.getResponseStatusCode());
            listener.onFailure((Throwable)new TransportException((Throwable)x, failure), messages);
        }
        catch (Throwable x) {
            this._webSocketSupported = this.isStickyReconnect() && this._webSocketConnected;
            listener.onFailure(x, messages);
        }
        return null;
    }

    protected AbstractWebSocketTransport.Delegate connect(WebSocketClient client, ClientUpgradeRequest request) throws IOException, InterruptedException {
        try {
            AbstractWebSocketTransport.Delegate delegate = this.newDelegate();
            long timeout = this.getConnectTimeout() + 1000L;
            client.connect((Object)delegate, request, (JettyUpgradeListener)this).get(timeout, TimeUnit.MILLISECONDS);
            return delegate;
        }
        catch (TimeoutException e) {
            throw new ConnectException("Connect timeout");
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
    }

    protected AbstractWebSocketTransport.Delegate newDelegate() {
        return new JettyWebSocketDelegate();
    }

    public void onHandshakeRequest(Request request) {
    }

    public void onHandshakeResponse(Request request, Response response) {
        this.storeCookies(URI.create(this.getURL()), JettyWebSocketTransport.headersToMap(response.getHeaders()));
    }

    public static Map<String, List<String>> headersToMap(HttpFields headers) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        headers.forEach(field -> {
            String name = field.getName();
            result.compute(name, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<String>(1);
                }
                if (HttpHeader.SET_COOKIE.is(k)) {
                    v.add(field.getValue());
                } else {
                    v.addAll(field.getValueList());
                }
                return v;
            });
        });
        return result;
    }

    public class JettyWebSocketDelegate
    extends AbstractWebSocketTransport.Delegate
    implements Session.Listener.AutoDemanding {
        private Session _session;

        public JettyWebSocketDelegate() {
            super((AbstractWebSocketTransport)JettyWebSocketTransport.this);
        }

        public void onWebSocketOpen(Session session) {
            JettyWebSocketTransport.this.locked(() -> {
                this._session = session;
                return this._session;
            });
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Opened websocket session {}", (Object)session);
            }
        }

        public void onWebSocketText(String data) {
            this.onData(data);
        }

        public void onWebSocketClose(int closeCode, String reason, Callback callback) {
            this.onClose(closeCode, reason);
            callback.succeed();
        }

        public void onWebSocketError(Throwable failure) {
            this.failMessages(failure);
        }

        public void send(String content) {
            Session session = (Session)JettyWebSocketTransport.this.locked(() -> this._session);
            try {
                if (session == null) {
                    throw new IOException("Unconnected");
                }
                session.sendText(content, Callback.NOOP);
            }
            catch (Throwable x) {
                this.fail(x, "Failure");
            }
        }

        protected void shutdown(String reason) {
            Session session = (Session)JettyWebSocketTransport.this.locked(() -> {
                Session result = this._session;
                this.close();
                return result;
            });
            if (session != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing websocket session {}", (Object)session);
                }
                session.close(1000, reason, Callback.NOOP);
            }
        }

        protected boolean isOpen() {
            return (Boolean)JettyWebSocketTransport.this.locked(() -> super.isOpen() && this._session != null);
        }

        protected void close() {
            JettyWebSocketTransport.this.locked(() -> {
                this._session = null;
                return null;
            });
        }
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final WebSocketClient wsClient;

        public Factory() {
            this(new WebSocketClient());
        }

        public Factory(WebSocketClient wsClient) {
            this.wsClient = wsClient;
            this.addBean(wsClient);
        }

        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)options.get("scheduler");
            return new JettyWebSocketTransport(url, options, scheduler, this.wsClient);
        }
    }
}

