/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.websocket.okhttp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpCookie;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.websocket.common.AbstractWebSocketTransport;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpWebSocketTransport
extends AbstractWebSocketTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkHttpWebSocketTransport.class);
    private static final String SEC_WEBSOCKET_EXTENSIONS_HEADER = "Sec-WebSocket-Extensions";
    private static final String SEC_WEBSOCKET_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    private static final String SEC_WEBSOCKET_ACCEPT_HEADER = "Sec-WebSocket-Accept";
    private final OkHttpClient okHttpClient;
    private boolean webSocketSupported;
    private boolean webSocketConnected;

    public OkHttpWebSocketTransport(Map<String, Object> options, OkHttpClient okHttpClient) {
        this(null, options, null, okHttpClient);
    }

    public OkHttpWebSocketTransport(String uri, Map<String, Object> options, ScheduledExecutorService scheduler, OkHttpClient okHttpClient) {
        super(uri, options, scheduler);
        OkHttpClient.Builder enrichedClient = okHttpClient.newBuilder().connectTimeout(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        if (okHttpClient.pingIntervalMillis() == 0) {
            enrichedClient.pingInterval(20L, TimeUnit.SECONDS);
        }
        this.okHttpClient = enrichedClient.build();
        this.webSocketSupported = true;
    }

    public void init() {
        super.init();
        this.webSocketSupported = true;
        this.webSocketConnected = false;
    }

    public boolean accept(String s) {
        return this.webSocketSupported;
    }

    protected AbstractWebSocketTransport.Delegate connect(String uri, TransportListener listener, List<Message.Mutable> messages) {
        try {
            OkHttpDelegate delegate = this.newDelegate();
            Request upgradeRequest = this.buildUpgradeRequest(uri);
            this.okHttpClient.newWebSocket(upgradeRequest, delegate.listener);
            Throwable connectFailure = delegate.connectFuture.get(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (connectFailure != null) {
                throw connectFailure;
            }
            this.webSocketConnected = true;
            return delegate;
        }
        catch (ConnectException | ProtocolException | SocketTimeoutException | UnknownHostException | UnresolvedAddressException | TimeoutException e) {
            listener.onFailure((Throwable)e, messages);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            listener.onFailure((Throwable)e, messages);
        }
        catch (Throwable e) {
            this.webSocketSupported = this.isStickyReconnect() && this.webSocketConnected;
            listener.onFailure(e, messages);
        }
        return null;
    }

    protected OkHttpDelegate newDelegate() {
        return new OkHttpDelegate();
    }

    private Request buildUpgradeRequest(String uri) {
        Request.Builder upgradeRequest = new Request.Builder();
        this.onHandshakeRequest(uri, upgradeRequest);
        return upgradeRequest.build();
    }

    protected void onHandshakeRequest(String uri, Request.Builder upgradeRequest) {
        upgradeRequest.url(uri);
        String protocol = this.getProtocol();
        if (protocol != null && !protocol.isEmpty()) {
            upgradeRequest.header(SEC_WEBSOCKET_PROTOCOL_HEADER, protocol);
        }
        if (this.isPerMessageDeflateEnabled()) {
            upgradeRequest.addHeader(SEC_WEBSOCKET_EXTENSIONS_HEADER, "permessage-deflate");
        }
        List cookies = this.getCookies(URI.create(uri));
        for (HttpCookie cookie : cookies) {
            String cookieValue = cookie.getName() + "=" + cookie.getValue();
            upgradeRequest.addHeader("Cookie", cookieValue);
        }
    }

    protected void onHandshakeResponse(Response response) {
        this.webSocketSupported = response.header(SEC_WEBSOCKET_ACCEPT_HEADER) != null;
        this.storeCookies(URI.create(this.getURL()), OkHttpWebSocketTransport.headersToMap(response.headers()));
    }

    public static Map<String, List<String>> headersToMap(Headers headers) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        headers.names().forEach(name -> result.put((String)name, headers.values(name)));
        return result;
    }

    protected class OkHttpDelegate
    extends AbstractWebSocketTransport.Delegate {
        private final WebSocketListener listener;
        private final CompletableFuture<Throwable> connectFuture;
        private WebSocket webSocket;

        public OkHttpDelegate() {
            super((AbstractWebSocketTransport)OkHttpWebSocketTransport.this);
            this.listener = new OkHttpListener();
            this.connectFuture = new CompletableFuture();
        }

        private void onOpen(WebSocket webSocket, Response response) {
            OkHttpWebSocketTransport.this.locked(() -> {
                this.webSocket = webSocket;
                return this.webSocket;
            });
            OkHttpWebSocketTransport.this.onHandshakeResponse(response);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Opened {}", (Object)webSocket);
            }
        }

        protected void send(String payload) {
            WebSocket webSocket = (WebSocket)OkHttpWebSocketTransport.this.locked(() -> this.webSocket);
            try {
                if (webSocket == null) {
                    throw new IOException("Unconnected!");
                }
                boolean enqueued = webSocket.send(payload);
                if (!enqueued) {
                    throw new IOException("Not enqueued! Current queue size: " + webSocket.queueSize());
                }
            }
            catch (Throwable throwable) {
                LOGGER.warn("Failure sending " + payload, throwable);
                this.fail(throwable, "Exception");
            }
        }

        protected boolean isOpen() {
            return (Boolean)OkHttpWebSocketTransport.this.locked(() -> super.isOpen() && this.webSocket != null);
        }

        protected void close() {
            OkHttpWebSocketTransport.this.locked(() -> {
                this.webSocket = null;
                return null;
            });
        }

        protected void shutdown(String reason) {
            WebSocket webSocket = (WebSocket)OkHttpWebSocketTransport.this.locked(() -> {
                WebSocket result = this.webSocket;
                this.close();
                return result;
            });
            if (webSocket != null) {
                int code = 1000;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing websocket {}/{}", (Object)code, (Object)reason);
                }
                try {
                    reason = this.trimCloseReason(reason);
                    webSocket.close(code, reason);
                }
                catch (Throwable t) {
                    LOGGER.warn(String.format("Unable to close websocket %d/%s", code, reason), t);
                }
            }
        }

        private final class OkHttpListener
        extends WebSocketListener {
            private OkHttpListener() {
            }

            public void onOpen(WebSocket webSocket, Response response) {
                OkHttpDelegate.this.onOpen(webSocket, response);
                OkHttpDelegate.this.connectFuture.complete(null);
            }

            public void onMessage(WebSocket webSocket, String text) {
                OkHttpDelegate.this.onData(text);
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                OkHttpDelegate.this.onClose(code, reason);
            }

            public void onFailure(WebSocket webSocket, Throwable failure, Response response) {
                if (!OkHttpDelegate.this.connectFuture.complete(failure)) {
                    OkHttpDelegate.this.fail(failure, "WebSocketListener Failure");
                }
            }
        }
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final OkHttpClient okHttpClient;

        public Factory() {
            this(new OkHttpClient());
        }

        public Factory(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            this.addBean(okHttpClient);
        }

        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)options.get("scheduler");
            return new OkHttpWebSocketTransport(url, options, scheduler, this.okHttpClient);
        }
    }
}

