/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import junit.framework.TestCase;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.client.BayeuxClient;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.MessageImpl;
import org.cometd.server.continuation.ContinuationCometdServlet;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class BayeuxClientTest
extends TestCase {
    Server _server;
    ContinuationCometdServlet _cometd;

    protected void setUp() throws Exception {
        super.setUp();
        this._server = new Server();
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setMinThreads(5);
        qtp.setMaxThreads(20);
        this._server.setThreadPool((ThreadPool)qtp);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(0);
        this._server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this._server, "/");
        context.setBaseResource(Resource.newResource((String)"./src/test"));
        this._cometd = new ContinuationCometdServlet();
        ServletHolder cometd_holder = new ServletHolder((Servlet)this._cometd);
        cometd_holder.setInitParameter("timeout", "10000");
        cometd_holder.setInitParameter("interval", "100");
        cometd_holder.setInitParameter("maxInterval", "5000");
        cometd_holder.setInitParameter("multiFrameInterval", "2000");
        cometd_holder.setInitParameter("logLevel", "1");
        context.addServlet(cometd_holder, "/cometd/*");
        context.addServlet("org.eclipse.jetty.servlet.DefaultServlet", "/");
    }

    public void testClient() throws Exception {
        this._server.start();
        AbstractBayeux bayeux = this._cometd.getBayeux();
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        final Exchanger<Object> exchanger = new Exchanger<Object>();
        BayeuxClient client = new BayeuxClient(httpClient, "http://localhost:" + this._server.getConnectors()[0].getLocalPort() + "/cometd"){
            volatile boolean connected;

            protected void metaConnect(boolean success, Message message) {
                super.metaConnect(success, message);
                if (!this.connected) {
                    this.connected = true;
                    try {
                        ((MessageImpl)message).incRef();
                        exchanger.exchange(message, 1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            protected void metaHandshake(boolean success, boolean reestablish, Message message) {
                this.connected = false;
                super.metaHandshake(success, reestablish, message);
                try {
                    ((MessageImpl)message).incRef();
                    exchanger.exchange(message, 1L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        client.addListener((ClientListener)new MessageListener(){

            public void deliver(Client fromClient, Client toClient, Message message) {
                if (message.getData() != null || "/meta/subscribe".equals(message.getChannel()) || "/meta/disconnect".equals(message.getChannel())) {
                    try {
                        ((MessageImpl)message).incRef();
                        exchanger.exchange(message, 1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        client.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStarted(LifeCycle event) {
            }

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleStopped(LifeCycle event) {
                try {
                    exchanger.exchange(event, 1L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void lifeCycleStopping(LifeCycle event) {
            }
        });
        client.start();
        MessageImpl message = exchanger.exchange(null, 1L, TimeUnit.SECONDS);
        BayeuxClientTest.assertEquals((String)"/meta/handshake", (String)message.getChannel());
        BayeuxClientTest.assertTrue((boolean)message.isSuccessful());
        String id = client.getId();
        BayeuxClientTest.assertTrue((id != null ? 1 : 0) != 0);
        message.decRef();
        message = exchanger.exchange(null, 1L, TimeUnit.SECONDS);
        BayeuxClientTest.assertEquals((String)"/meta/connect", (String)message.getChannel());
        BayeuxClientTest.assertTrue((boolean)message.isSuccessful());
        message.decRef();
        client.subscribe("/a/channel");
        message = exchanger.exchange(null, 1L, TimeUnit.SECONDS);
        BayeuxClientTest.assertEquals((String)"/meta/subscribe", (String)message.getChannel());
        BayeuxClientTest.assertTrue((boolean)message.isSuccessful());
        message.decRef();
        client.publish("/a/channel", (Object)"data", "id");
        message = exchanger.exchange(null, 1L, TimeUnit.SECONDS);
        BayeuxClientTest.assertEquals((Object)"data", (Object)message.getData());
        message.decRef();
        client.disconnect();
        message = exchanger.exchange(null, 1L, TimeUnit.SECONDS);
        BayeuxClientTest.assertEquals((String)"/meta/disconnect", (String)message.getChannel());
        BayeuxClientTest.assertTrue((boolean)message.isSuccessful());
        message.decRef();
        Object o = exchanger.exchange(null, 1L, TimeUnit.SECONDS);
        BayeuxClientTest.assertTrue((boolean)client.isStopped());
    }
}

