/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Map;
import java.util.Timer;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.client.BayeuxClient;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class SimpleEchoBayeuxClient {
    public static long _id = 0L;
    String _who;
    BayeuxClient _client;
    Timer _timer;
    HttpClient _httpClient;
    boolean _connected;

    public SimpleEchoBayeuxClient(String host, int port, String uri, String who) throws Exception {
        this._who = who;
        if (this._who == null) {
            this._who = "anonymous";
        }
        this._timer = new Timer("SharedBayeuxClientTimer", true);
        this._httpClient = new HttpClient();
        this._httpClient.setConnectorType(2);
        this._httpClient.setMaxConnectionsPerAddress(40000);
        QueuedThreadPool pool = new QueuedThreadPool();
        pool.setMaxThreads(500);
        pool.setDaemon(true);
        this._httpClient.setThreadPool((ThreadPool)pool);
        this._httpClient.start();
        Address address = new Address(host, port);
        this._client = new BayeuxClient(this._httpClient, address, uri, this._timer){

            public void metaConnect(boolean success, Message message) {
                super.metaConnect(success, message);
                if (success && !SimpleEchoBayeuxClient.this._connected) {
                    System.err.println("Reconnected!");
                } else if (!success && SimpleEchoBayeuxClient.this._connected) {
                    System.err.println("Server disconnected");
                }
                SimpleEchoBayeuxClient.this._connected = success;
            }

            public void metaHandshake(boolean success, boolean reestablish, Message message) {
                super.metaHandshake(success, reestablish, message);
                if (success && reestablish) {
                    SimpleEchoBayeuxClient.this._client.subscribe("/foo/alpha");
                    System.err.println("Resubscribed");
                }
            }

            public void metaPublishFail(Throwable th, Message[] messages) {
                super.metaPublishFail(th, messages);
            }
        };
        this._client.addListener((ClientListener)new MessageListener(){

            public void deliver(Client fromClient, Client toClient, Message msg) {
                if (msg == null) {
                    return;
                }
                if ("/foo/alpha".equals(msg.getChannel())) {
                    Object data = msg.get((Object)"data");
                    String user = "unknown";
                    if (data != null) {
                        user = (String)((Map)data).get("user");
                        String chat = (String)((Map)data).get("chat");
                        if (user == null) {
                            user = "unknown";
                        }
                        if (user.equals(SimpleEchoBayeuxClient.this._who)) {
                            user = "I";
                        }
                        System.err.println("\n\t" + user + " said: " + chat);
                    }
                }
            }
        });
    }

    public void start() throws Exception {
        this._client.start();
        this._client.subscribe("/foo/alpha");
        JSON.Literal msg = new JSON.Literal("{\"user\":\"" + this._who + "\",\"chat\":\"Has joined\"}");
        this._client.publish("/foo/alpha", (Object)msg, String.valueOf(_id++));
        this._connected = true;
    }

    public void stop() throws Exception {
        this._client.stop();
        this._connected = false;
    }

    public void publish(String say) {
        JSON.Literal msg = new JSON.Literal("{\"user\":\"" + this._who + "\",\"chat\":\"" + say + "\"}");
        this._client.publish("/foo/alpha", (Object)msg, String.valueOf(_id++));
    }

    public static final void main(String[] args) {
        try {
            String serverCometdUrl = args.length > 0 ? args[0] : "/cometd/cometd";
            int serverPort = args.length >= 2 ? Integer.valueOf(args[1]) : 8080;
            String user = args.length >= 3 ? args[2] : "anonymous";
            SimpleEchoBayeuxClient sbc = new SimpleEchoBayeuxClient("localhost", serverPort, serverCometdUrl, user);
            sbc.start();
            LineNumberReader in = new LineNumberReader(new InputStreamReader(System.in));
            while (true) {
                try {
                    while (true) {
                        System.err.print("Enter something to say > ");
                        String say = in.readLine().trim();
                        if (say.equalsIgnoreCase("stop")) {
                            sbc.stop();
                            continue;
                        }
                        if (say.equalsIgnoreCase("start")) {
                            sbc.start();
                            continue;
                        }
                        sbc.publish(say);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

