/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.ajax.JSON;

public class LongPollingTransport
extends ClientTransport {
    private final HttpClient _httpClient;

    public LongPollingTransport(Map<String, Object> options) {
        super("long-polling", options);
        this._httpClient = new HttpClient();
    }

    public LongPollingTransport(Map<String, Object> options, HttpClient httpClient) {
        super("long-polling", options);
        this._httpClient = httpClient;
    }

    @Override
    public boolean accept(String bayeuxVersion) {
        return true;
    }

    @Override
    public void init(BayeuxClient bayeux, HttpURI uri, TransportListener listener) {
        super.init(bayeux, uri, listener);
    }

    @Override
    public void send(Message ... messages) {
        TransportExchange httpExchange = new TransportExchange();
        httpExchange.setMethod("POST");
        if (messages.length == 1 && messages[0].isMeta()) {
            httpExchange.setURL(this._uri + messages[0].getChannel());
        } else {
            httpExchange.setURL(this._uri.toString());
        }
        String content = JSON.toString((Object[])messages);
        httpExchange.setRequestContentType("application/json;charset=UTF-8");
        try {
            httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(content, "UTF-8"));
            if (this._bayeux != null) {
                this._bayeux.customize((HttpExchange)httpExchange);
            }
            this._httpClient.send((HttpExchange)httpExchange);
        }
        catch (Exception x) {
            this.notifyException(x);
        }
    }

    @Override
    public void reset() {
    }

    private class TransportExchange
    extends ContentExchange {
        private TransportExchange() {
            super(true);
        }

        protected void onResponseComplete() throws IOException {
            if (this.getResponseStatus() == 200) {
                String content = this.getResponseContent();
                if (content != null && content.length() > 0) {
                    List<Message.Mutable> messages = LongPollingTransport.this.toMessages(this.getResponseContent());
                    LongPollingTransport.this.notifyMessages(messages);
                } else {
                    LongPollingTransport.this.notifyProtocolError((Object)((Object)this) + " 200 null content");
                }
            } else {
                LongPollingTransport.this.notifyProtocolError((Object)((Object)this) + " " + this.getResponseStatus());
            }
        }

        protected void onConnectionFailed(Throwable x) {
            LongPollingTransport.this.notifyConnectException(x);
        }

        protected void onException(Throwable x) {
            LongPollingTransport.this.notifyException(x);
        }

        protected void onExpire() {
            LongPollingTransport.this.notifyExpire();
        }
    }
}

