package org.cometd.client.transport;

import java.util.List;

import org.cometd.bayeux.Message;

/**
 * @version $Revision: 902 $ $Date: 2010-10-02 06:45:07 +1000 (Sat, 02 Oct 2010) $
 */
public interface TransportListener
{
    void onSending(Message[] messages);

    void onMessages(List<Message.Mutable> messages);

    void onConnectException(Throwable x, Message[] messages);

    void onException(Throwable x, Message[] messages);

    void onExpire(Message[] messages);

    void onProtocolError(String info, Message[] messages);
}
