/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.TransportException;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.QuotedStringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongPollingTransport
extends HttpClientTransport {
    public static final String NAME = "long-polling";
    public static final String PREFIX = "long-polling.json";
    private final HttpClient _httpClient;
    private final List<TransportExchange> _exchanges = new ArrayList<TransportExchange>();
    private volatile boolean _aborted;
    private volatile long _maxNetworkDelay;
    private volatile boolean _appendMessageType;
    private volatile Map<String, Object> _advice;

    public static LongPollingTransport create(Map<String, Object> options) {
        HttpClient httpClient = new HttpClient();
        httpClient.setIdleTimeout(5000L);
        httpClient.setConnectorType(2);
        httpClient.setMaxConnectionsPerAddress(32768);
        return LongPollingTransport.create(options, httpClient);
    }

    public static LongPollingTransport create(Map<String, Object> options, HttpClient httpClient) {
        LongPollingTransport transport = new LongPollingTransport(options, httpClient);
        if (!httpClient.isStarted()) {
            try {
                httpClient.start();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return transport;
    }

    public LongPollingTransport(Map<String, Object> options, HttpClient httpClient) {
        super(NAME, options);
        this._httpClient = httpClient;
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public boolean accept(String bayeuxVersion) {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this._aborted = false;
        this._maxNetworkDelay = this.getOption("maxNetworkDelay", this._httpClient.getTimeout());
        Pattern uriRegexp = Pattern.compile("(^https?://(((\\[[^\\]]+\\])|([^:/\\?#]+))(:(\\d+))?))?([^\\?#]*)(.*)?");
        Matcher uriMatcher = uriRegexp.matcher(this.getURL());
        if (uriMatcher.matches()) {
            String afterPath = uriMatcher.group(9);
            this._appendMessageType = afterPath == null || afterPath.trim().length() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        ArrayList<TransportExchange> exchanges = new ArrayList<TransportExchange>();
        LongPollingTransport longPollingTransport = this;
        synchronized (longPollingTransport) {
            this._aborted = true;
            exchanges.addAll(this._exchanges);
            this._exchanges.clear();
        }
        for (TransportExchange exchange : exchanges) {
            exchange.cancel();
            exchange._listener.onException(new IOException("Aborted"), exchange._messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(TransportListener listener, Message.Mutable ... messages) {
        TransportExchange httpExchange = new TransportExchange(listener, (Message[])messages);
        httpExchange.setMethod("POST");
        String url = this.getURL();
        httpExchange.setURL(url);
        if (this._appendMessageType && messages.length == 1 && messages[0].isMeta()) {
            String type = messages[0].getChannel().substring("/meta".length());
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url + type;
            httpExchange.setURL(url);
        }
        String content = this.generateJSON(messages);
        httpExchange.setRequestContentType("application/json;charset=UTF-8");
        try {
            httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(content, "UTF-8"));
            this.customize(httpExchange);
            LongPollingTransport longPollingTransport = this;
            synchronized (longPollingTransport) {
                if (this._aborted) {
                    throw new IllegalStateException("Aborted");
                }
                this._exchanges.add(httpExchange);
            }
            long maxNetworkDelay = this._maxNetworkDelay;
            if (messages.length == 1 && "/meta/connect".equals(messages[0].getChannel())) {
                Map<String, Object> advice = messages[0].getAdvice();
                if (advice == null) {
                    advice = this._advice;
                }
                if (advice != null) {
                    Object timeout = advice.get("timeout");
                    if (timeout instanceof Number) {
                        maxNetworkDelay += ((Number)timeout).longValue();
                    } else if (timeout != null) {
                        maxNetworkDelay += Long.parseLong(timeout.toString());
                    }
                }
            }
            httpExchange.setTimeout(maxNetworkDelay);
            this._httpClient.send((HttpExchange)httpExchange);
        }
        catch (Exception x) {
            listener.onException(x, (Message[])messages);
        }
    }

    protected void customize(ContentExchange exchange) {
        HttpClientTransport.CookieProvider cookieProvider = this.getCookieProvider();
        if (cookieProvider != null) {
            StringBuilder builder = new StringBuilder();
            for (HttpClientTransport.Cookie cookie : cookieProvider.getCookies()) {
                if (builder.length() > 0) {
                    builder.append("; ");
                }
                builder.append(cookie.asString());
            }
            if (builder.length() > 0) {
                exchange.setRequestHeader("Cookie", builder.toString());
            }
        }
    }

    private class TransportExchange
    extends ContentExchange {
        private final TransportListener _listener;
        private final Message[] _messages;

        private TransportExchange(TransportListener listener, Message ... messages) {
            super(true);
            this._listener = listener;
            this._messages = messages;
        }

        protected void onRequestCommitted() throws IOException {
            this._listener.onSending(this._messages);
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            super.onResponseHeader(name, value);
            int headerName = HttpHeaders.CACHE.getOrdinal(name);
            if (headerName == 53) {
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(value.toString(), "=;", false, false);
                tokenizer.setSingle(false);
                String cookieName = null;
                if (tokenizer.hasMoreTokens()) {
                    cookieName = tokenizer.nextToken();
                }
                String cookieValue = null;
                if (tokenizer.hasMoreTokens()) {
                    cookieValue = tokenizer.nextToken();
                }
                if (cookieName != null && cookieValue != null) {
                    int version = 0;
                    String comment = null;
                    String path = null;
                    String domain = null;
                    int maxAge = -1;
                    boolean secure = false;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if ("Version".equalsIgnoreCase(token)) {
                            version = Integer.parseInt(tokenizer.nextToken());
                            continue;
                        }
                        if ("Comment".equalsIgnoreCase(token)) {
                            comment = tokenizer.nextToken();
                            continue;
                        }
                        if ("Path".equalsIgnoreCase(token)) {
                            path = tokenizer.nextToken();
                            continue;
                        }
                        if ("Domain".equalsIgnoreCase(token)) {
                            domain = tokenizer.nextToken();
                            continue;
                        }
                        if ("Expires".equalsIgnoreCase(token)) {
                            try {
                                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.US);
                                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                                Date date = dateFormat.parse(tokenizer.nextToken());
                                Long maxAgeValue = TimeUnit.MILLISECONDS.toSeconds(date.getTime() - System.currentTimeMillis());
                                maxAge = maxAgeValue > 0L ? maxAgeValue.intValue() : 0;
                            }
                            catch (ParseException ignored) {}
                            continue;
                        }
                        if ("Max-Age".equalsIgnoreCase(token)) {
                            try {
                                maxAge = Integer.parseInt(tokenizer.nextToken());
                            }
                            catch (NumberFormatException ignored) {}
                            continue;
                        }
                        if (!"Secure".equalsIgnoreCase(token)) continue;
                        secure = true;
                    }
                    HttpClientTransport.Cookie cookie = new HttpClientTransport.Cookie(cookieName, cookieValue, domain, path, maxAge, secure, version, comment);
                    LongPollingTransport.this.setCookie(cookie);
                }
            }
        }

        protected void onResponseComplete() throws IOException {
            boolean completed = this.complete();
            if (!completed) {
                return;
            }
            if (this.getResponseStatus() == 200) {
                String content = this.getResponseContent();
                if (content != null && content.length() > 0) {
                    try {
                        List<Message.Mutable> messages = LongPollingTransport.this.parseMessages(this.getResponseContent());
                        LongPollingTransport.this.debug("Received messages {}", messages);
                        for (Message.Mutable message : messages) {
                            Map advice;
                            if (!message.isSuccessful() || !"/meta/connect".equals(message.getChannel()) || (advice = message.getAdvice()) == null || advice.get("timeout") == null) continue;
                            LongPollingTransport.this._advice = advice;
                        }
                        this._listener.onMessages(messages);
                    }
                    catch (ParseException x) {
                        this.onException(x);
                    }
                } else {
                    HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
                    failure.put("httpCode", 204);
                    TransportException x = new TransportException(failure);
                    this._listener.onException((Throwable)x, this._messages);
                }
            } else {
                HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
                failure.put("httpCode", this.getResponseStatus());
                TransportException x = new TransportException(failure);
                this._listener.onException((Throwable)x, this._messages);
            }
        }

        protected void onConnectionFailed(Throwable x) {
            if (this.complete()) {
                this._listener.onConnectException(x, this._messages);
            }
        }

        protected void onException(Throwable x) {
            if (this.complete()) {
                this._listener.onException(x, this._messages);
            }
        }

        protected void onExpire() {
            if (this.complete()) {
                this._listener.onExpire(this._messages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean complete() {
            LongPollingTransport longPollingTransport = LongPollingTransport.this;
            synchronized (longPollingTransport) {
                return LongPollingTransport.this._exchanges.remove((Object)this);
            }
        }
    }
}

