/*
 * Copyright (c) 2008-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cometd.client.transport;

import java.net.CookieStore;
import java.util.Map;

public abstract class HttpClientTransport extends ClientTransport {
    private volatile String url;
    private volatile CookieStore cookieStore;

    protected HttpClientTransport(String name, String url, Map<String, Object> options) {
        super(name, options);
        this.url = url;
    }

    protected String getURL() {
        return url;
    }

    public void setURL(String url) {
        if (this.url == null) {
            this.url = url;
        }
    }

    protected CookieStore getCookieStore() {
        return cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }
}
