/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.AbstractTransport;
import org.cometd.common.JSONContext;
import org.cometd.common.JettyJSONContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientTransport
extends AbstractTransport {
    public static final String MAX_NETWORK_DELAY_OPTION = "maxNetworkDelay";
    public static final String JSON_CONTEXT_OPTION = "jsonContext";
    public static final String SCHEDULER_OPTION = "scheduler";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private long maxNetworkDelay;
    private JSONContext.Client jsonContext;

    protected ClientTransport(String name, Map<String, Object> options) {
        super(name, options);
    }

    public void init() {
        Object option = this.getOption(JSON_CONTEXT_OPTION);
        if (option == null) {
            this.jsonContext = new JettyJSONContextClient();
        } else if (option instanceof String) {
            try {
                Class<?> jsonContextClass = Thread.currentThread().getContextClassLoader().loadClass((String)option);
                if (!JSONContext.Client.class.isAssignableFrom(jsonContextClass)) {
                    throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + option);
                }
                this.jsonContext = (JSONContext.Client)jsonContextClass.newInstance();
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + option, x);
            }
        } else if (option instanceof JSONContext.Client) {
            this.jsonContext = (JSONContext.Client)option;
        } else {
            throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + option);
        }
        this.setOption(JSON_CONTEXT_OPTION, this.jsonContext);
    }

    public abstract void abort();

    public void terminate() {
    }

    public abstract boolean accept(String var1);

    public abstract void send(TransportListener var1, List<Message.Mutable> var2);

    protected List<Message.Mutable> parseMessages(String content) throws ParseException {
        return new ArrayList<Message.Mutable>(Arrays.asList(this.jsonContext.parse(content)));
    }

    protected String generateJSON(List<Message.Mutable> messages) {
        return this.jsonContext.generate(messages);
    }

    public long getMaxNetworkDelay() {
        this.maxNetworkDelay = this.getOption(MAX_NETWORK_DELAY_OPTION, this.maxNetworkDelay);
        return this.maxNetworkDelay;
    }

    protected void setMaxNetworkDelay(long maxNetworkDelay) {
        this.maxNetworkDelay = maxNetworkDelay;
    }

    public static interface Factory {
        public ClientTransport newClientTransport(String var1, Map<String, Object> var2);
    }
}

