/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.net.HttpCookie;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.TransportException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class LongPollingTransport
extends HttpClientTransport {
    public static final String NAME = "long-polling";
    public static final String PREFIX = "long-polling.json";
    @Deprecated
    public static final String MAX_BUFFER_SIZE_OPTION = "maxBufferSize";
    private final HttpClient _httpClient;
    private final List<Request> _requests = new ArrayList<Request>();
    private volatile boolean _aborted;
    private volatile int _maxMessageSize;
    private volatile boolean _appendMessageType;
    private volatile Map<String, Object> _advice;

    public LongPollingTransport(Map<String, Object> options, HttpClient httpClient) {
        this(null, options, httpClient);
    }

    public LongPollingTransport(String url, Map<String, Object> options, HttpClient httpClient) {
        super(NAME, url, options);
        this._httpClient = httpClient;
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public boolean accept(String bayeuxVersion) {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this._aborted = false;
        long defaultMaxNetworkDelay = this._httpClient.getIdleTimeout();
        if (defaultMaxNetworkDelay <= 0L) {
            defaultMaxNetworkDelay = 10000L;
        }
        this.setMaxNetworkDelay(defaultMaxNetworkDelay);
        this._maxMessageSize = this.getOption("maxMessageSize", this.getOption(MAX_BUFFER_SIZE_OPTION, 0x100000));
        Pattern uriRegexp = Pattern.compile("(^https?://(((\\[[^\\]]+\\])|([^:/\\?#]+))(:(\\d+))?))?([^\\?#]*)(.*)?");
        Matcher uriMatcher = uriRegexp.matcher(this.getURL());
        if (uriMatcher.matches()) {
            String afterPath = uriMatcher.group(9);
            this._appendMessageType = afterPath == null || afterPath.trim().length() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        ArrayList<Request> requests;
        LongPollingTransport longPollingTransport = this;
        synchronized (longPollingTransport) {
            requests = new ArrayList<Request>(this._requests);
            this._requests.clear();
            this._aborted = true;
        }
        for (Request request : requests) {
            request.abort((Throwable)new Exception("Transport " + (Object)((Object)this) + " aborted"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(final TransportListener listener, final List<Message.Mutable> messages) {
        Message.Mutable message;
        Message.Mutable message2;
        String url = this.getURL();
        final URI uri = URI.create(url);
        if (this._appendMessageType && messages.size() == 1 && (message2 = messages.get(0)).isMeta()) {
            String type = message2.getChannel().substring("/meta".length());
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url + type;
        }
        Request request = this._httpClient.newRequest(url).method(HttpMethod.POST);
        request.header(HttpHeader.CONTENT_TYPE.asString(), "application/json;charset=UTF-8");
        List<HttpCookie> cookies = this.getCookies(uri);
        StringBuilder value = new StringBuilder(cookies.size() * 32);
        for (HttpCookie cookie : cookies) {
            if (value.length() > 0) {
                value.append("; ");
            }
            value.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        request.header(HttpHeader.COOKIE.asString(), value.toString());
        request.content((ContentProvider)new StringContentProvider(this.generateJSON(messages)));
        this.customize(request);
        Object object = this;
        synchronized (object) {
            if (this._aborted) {
                throw new IllegalStateException("Aborted");
            }
            this._requests.add(request);
        }
        request.listener((Request.Listener)new Request.Listener.Adapter(){

            public void onHeaders(Request request) {
                listener.onSending(messages);
            }
        });
        long maxNetworkDelay = this.getMaxNetworkDelay();
        if (messages.size() == 1 && "/meta/connect".equals((message = messages.get(0)).getChannel())) {
            Map<String, Object> advice = message.getAdvice();
            if (advice == null) {
                advice = this._advice;
            }
            if (advice != null) {
                Object timeout = advice.get("timeout");
                if (timeout instanceof Number) {
                    maxNetworkDelay += ((Number)timeout).longValue();
                } else if (timeout != null) {
                    maxNetworkDelay += Long.parseLong(timeout.toString());
                }
            }
        }
        request.idleTimeout(maxNetworkDelay * 2L, TimeUnit.MILLISECONDS);
        request.timeout(maxNetworkDelay, TimeUnit.MILLISECONDS);
        request.send((Response.CompleteListener)new BufferingResponseListener(this._maxMessageSize){

            public boolean onHeader(Response response, HttpField field) {
                HttpHeader header = field.getHeader();
                if (header == HttpHeader.SET_COOKIE || header == HttpHeader.SET_COOKIE2) {
                    HashMap<String, List<String>> cookies = new HashMap<String, List<String>>(1);
                    cookies.put(field.getName(), Collections.singletonList(field.getValue()));
                    LongPollingTransport.this.storeCookies(uri, cookies);
                    return false;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Result result) {
                LongPollingTransport longPollingTransport = LongPollingTransport.this;
                synchronized (longPollingTransport) {
                    LongPollingTransport.this._requests.remove(result.getRequest());
                }
                if (result.isFailed()) {
                    listener.onFailure(result.getFailure(), messages);
                    return;
                }
                Response response = result.getResponse();
                int status = response.getStatus();
                if (status == 200) {
                    String content = this.getContentAsString();
                    if (content != null && content.length() > 0) {
                        try {
                            List<Message.Mutable> messages2 = LongPollingTransport.this.parseMessages(content);
                            if (LongPollingTransport.this.logger.isDebugEnabled()) {
                                LongPollingTransport.this.logger.debug("Received messages {}", messages2);
                            }
                            for (Message.Mutable message : messages2) {
                                Map advice;
                                if (!message.isSuccessful() || !"/meta/connect".equals(message.getChannel()) || (advice = message.getAdvice()) == null || advice.get("timeout") == null) continue;
                                LongPollingTransport.this._advice = advice;
                            }
                            listener.onMessages(messages2);
                        }
                        catch (ParseException x) {
                            listener.onFailure(x, messages);
                        }
                    } else {
                        HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
                        failure.put("httpCode", 204);
                        TransportException x = new TransportException(failure);
                        listener.onFailure((Throwable)x, messages);
                    }
                } else {
                    HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
                    failure.put("httpCode", status);
                    TransportException x = new TransportException(failure);
                    listener.onFailure((Throwable)x, messages);
                }
            }
        });
    }

    protected void customize(Request request) {
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final HttpClient httpClient;

        public Factory(HttpClient httpClient) {
            this.httpClient = httpClient;
            this.addBean(httpClient);
        }

        @Override
        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            return new LongPollingTransport(url, options, this.httpClient);
        }
    }
}

