/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.SessionChannel;
import org.cometd.common.ChannelId;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.log.Log;

public abstract class AbstractClientSession
implements ClientSession {
    protected final List<ClientSession.Extension> _extensions = new CopyOnWriteArrayList<ClientSession.Extension>();
    protected final AttributesMap _attributes = new AttributesMap();
    protected final ConcurrentMap<String, AbstractSessionChannel> _channels = new ConcurrentHashMap<String, AbstractSessionChannel>();
    protected final AtomicInteger _batch = new AtomicInteger();
    protected final List<AbstractSessionChannel> _wild = new CopyOnWriteArrayList<AbstractSessionChannel>();
    protected final AtomicInteger _idGen = new AtomicInteger(0);

    protected AbstractClientSession() {
    }

    public void addExtension(ClientSession.Extension extension) {
        this._extensions.add(extension);
    }

    protected abstract ChannelId newChannelId(String var1);

    protected abstract AbstractSessionChannel newChannel(ChannelId var1);

    public SessionChannel getChannel(String channelId) {
        ChannelId id;
        AbstractSessionChannel new_channel;
        AbstractSessionChannel channel = (AbstractSessionChannel)this._channels.get(channelId);
        if (channel == null && (channel = this._channels.putIfAbsent(channelId, new_channel = this.newChannel(id = this.newChannelId(channelId)))) == null) {
            channel = new_channel;
        }
        if (channel.isWild()) {
            this._wild.add(channel);
        }
        return channel;
    }

    public void startBatch() {
        this._batch.incrementAndGet();
    }

    protected abstract void sendBatch();

    public void endBatch() {
        if (this._batch.decrementAndGet() == 0) {
            this.sendBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(Runnable batch) {
        this.startBatch();
        try {
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    public Object removeAttribute(String name) {
        Object old = this._attributes.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public void receive(Message message, Message.Mutable mutable) {
        ChannelId channelId;
        String id = message.getChannel();
        AbstractSessionChannel channel = id == null ? null : (AbstractSessionChannel)this.getChannel(id);
        ChannelId channelId2 = channelId = channel == null ? null : channel.getChannelId();
        if (channel != null && channel._handler != null) {
            channel._handler.handle(this, mutable);
        }
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.rcvMeta((ClientSession)this, mutable)) continue;
                return;
            }
            String error = (String)message.get((Object)"error");
            boolean successful = message.isSuccessful();
            if (channelId != null) {
                for (AbstractSessionChannel wild : this._wild) {
                    if (!wild._id.matches(channelId)) continue;
                    for (SessionChannel.SessionChannelListener listener : wild._listeners) {
                        try {
                            if (listener instanceof SessionChannel.MetaChannelListener) {
                                ((SessionChannel.MetaChannelListener)listener).onMetaMessage((SessionChannel)channel, message, successful, error);
                            }
                            if (!(listener instanceof SessionChannel.MessageListener)) continue;
                            ((SessionChannel.MessageListener)listener).onMessage((ClientSession)this, message);
                        }
                        catch (Exception e) {
                            Log.warn((Throwable)e);
                        }
                    }
                }
                for (SessionChannel.SessionChannelListener listener : channel._listeners) {
                    try {
                        if (!(listener instanceof SessionChannel.MetaChannelListener)) continue;
                        ((SessionChannel.MetaChannelListener)listener).onMetaMessage((SessionChannel)channel, message, message.isSuccessful(), error);
                    }
                    catch (Exception e) {
                        Log.warn((Throwable)e);
                    }
                }
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.rcv((ClientSession)this, mutable)) continue;
                return;
            }
            if (channelId != null) {
                for (AbstractSessionChannel wild : this._wild) {
                    try {
                        if (!wild._id.matches(channel._id)) continue;
                        for (SessionChannel.SessionChannelListener listener : wild._listeners) {
                            if (!(listener instanceof SessionChannel.MessageListener)) continue;
                            ((SessionChannel.MessageListener)listener).onMessage((ClientSession)this, message);
                        }
                    }
                    catch (Exception e) {
                        Log.warn((Throwable)e);
                    }
                }
            }
        }
        if (channel != null && (channel.isMeta() || message.getData() != null)) {
            for (SessionChannel.SubscriberListener listener : channel._subscriptions) {
                try {
                    listener.onMessage((SessionChannel)channel, message);
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
            }
        }
        if ("/meta/disconnect".equals(id) && message.isSuccessful()) {
            this.doDisconnected();
        }
    }

    protected abstract void doDisconnected();

    protected static abstract class AbstractSessionChannel
    implements SessionChannel {
        protected final ChannelId _id;
        protected CopyOnWriteArrayList<SessionChannel.SubscriberListener> _subscriptions = new CopyOnWriteArrayList();
        protected CopyOnWriteArrayList<SessionChannel.SessionChannelListener> _listeners = new CopyOnWriteArrayList();
        protected Handler _handler;

        protected AbstractSessionChannel(ChannelId id) {
            this._id = id;
        }

        public ChannelId getChannelId() {
            return this._id;
        }

        public void addListener(SessionChannel.SessionChannelListener listener) {
            this._listeners.add(listener);
        }

        public void removeListener(SessionChannel.SessionChannelListener listener) {
            this._listeners.remove(listener);
        }

        protected abstract void sendSubscribe();

        protected abstract void sendUnSubscribe();

        public void subscribe(SessionChannel.SubscriberListener listener) {
            this._subscriptions.add(listener);
            if (this._subscriptions.size() == 1) {
                this.sendSubscribe();
            }
        }

        public void unsubscribe(SessionChannel.SubscriberListener listener) {
            if (this._subscriptions.remove(listener) && this._subscriptions.size() == 0) {
                this.sendUnSubscribe();
            }
        }

        public void unsubscribe() {
            for (SessionChannel.SubscriberListener listener : this._subscriptions) {
                this.unsubscribe(listener);
            }
        }

        public String getId() {
            return this._id.toString();
        }

        public boolean isDeepWild() {
            return this._id.isDeepWild();
        }

        public boolean isMeta() {
            return this._id.isMeta();
        }

        public boolean isService() {
            return this._id.isService();
        }

        public boolean isWild() {
            return this._id.isWild();
        }

        public void setHandler(Handler handler) {
            this._handler = handler;
        }

        public String toString() {
            return this._id.toString();
        }
    }

    protected static interface Handler {
        public void handle(AbstractClientSession var1, Message.Mutable var2);
    }
}

