/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

public class ChannelId {
    public static final String WILD = "*";
    public static final String DEEPWILD = "**";
    private static final String[] ROOT = new String[0];
    private final String _name;
    private final String[] _segments;
    private final int _wild;

    public ChannelId(String name) {
        this._name = name;
        if (name == null || name.length() == 0 || name.charAt(0) != '/') {
            throw new IllegalArgumentException(name);
        }
        if ("/".equals(name)) {
            this._segments = ROOT;
        } else {
            if (name.charAt(name.length() - 1) == '/') {
                name = name.substring(0, name.length() - 1);
            }
            for (String s : this._segments = name.substring(1).split("/")) {
                if (s != null && s.length() != 0) continue;
                throw new IllegalArgumentException(name);
            }
        }
        this._wild = this._segments.length == 0 ? 0 : (WILD.equals(this._segments[this._segments.length - 1]) ? 1 : (DEEPWILD.equals(this._segments[this._segments.length - 1]) ? 2 : 0));
    }

    public boolean isWild() {
        return this._wild > 0;
    }

    public boolean isDeepWild() {
        return this._wild > 1;
    }

    public boolean isMeta() {
        return this._segments.length > 0 && "meta".equals(this._segments[0]);
    }

    public boolean isService() {
        return this._segments.length > 0 && "service".equals(this._segments[0]);
    }

    public boolean equals(Object obj) {
        ChannelId id;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChannelId && (id = (ChannelId)obj).depth() == this.depth()) {
            int i = id.depth();
            while (i-- > 0) {
                if (id.getSegment(i).equals(this.getSegment(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(ChannelId name) {
        if (name.isWild()) {
            return this.equals(name);
        }
        switch (this._wild) {
            case 0: {
                return this.equals(name);
            }
            case 1: {
                if (name._segments.length != this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(name._segments[i])) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                if (name._segments.length < this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(name._segments[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }

    public int depth() {
        return this._segments.length;
    }

    public boolean isParentOf(ChannelId id) {
        if (this.isWild() || this.depth() >= id.depth()) {
            return false;
        }
        for (int i = this._segments.length - 1; i >= 0; --i) {
            if (this._segments[i].equals(id._segments[i])) continue;
            return false;
        }
        return true;
    }

    public String getSegment(int i) {
        if (i > this._segments.length) {
            return null;
        }
        return this._segments[i];
    }

    public static boolean isMeta(String channelId) {
        return channelId != null && channelId.startsWith("/meta/");
    }

    public static boolean isService(String channelId) {
        return channelId != null && channelId.startsWith("/service/");
    }
}

