/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ImmutableHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final DualEntry[] _entries;
    private final Mutable _mutable;
    private final ImmutableEntrySet _immutableSet;
    private final MutableEntrySet _mutableSet;
    private int _size;

    public ImmutableHashMap() {
        this(16);
    }

    public ImmutableHashMap(int nominalSize) {
        int capacity;
        for (capacity = 1; capacity < nominalSize; capacity <<= 1) {
        }
        this._entries = new DualEntry[capacity];
        this._mutable = new Mutable();
        this._immutableSet = new ImmutableEntrySet();
        this._mutableSet = new MutableEntrySet();
    }

    public Mutable asMutable() {
        return this._mutable;
    }

    public Map.Entry<K, V> getEntry(K key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int hash = key.hashCode();
        int index = hash & this._entries.length - 1;
        DualEntry e = this._entries[index];
        while (e != null) {
            if (e._hash == hash && key.equals(e._key)) {
                return e;
            }
            e = e._next;
        }
        return null;
    }

    protected void onChange(K key) throws UnsupportedOperationException {
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._immutableSet;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._mutable.containsKey(key);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int hash = key.hashCode();
        int index = hash & this._entries.length - 1;
        DualEntry e = this._entries[index];
        while (e != null) {
            if (e._hash == hash && key.equals(e._key)) {
                return e.getValue();
            }
            e = e._next;
        }
        return null;
    }

    @Override
    public int size() {
        return this._size;
    }

    class MutableEntryIterator
    extends EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        MutableEntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry()._mutable;
        }

        @Override
        public void remove() {
            if (this._last == null) {
                throw new NoSuchElementException();
            }
            this._last._mutable.setValue(null);
        }
    }

    class ImmutableEntryIterator
    extends EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        ImmutableEntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class EntryIterator {
        protected int _index = 0;
        protected DualEntry<K, V> _entry;
        protected DualEntry<K, V> _last;

        EntryIterator() {
            while (this._entry == null && this._index < ImmutableHashMap.this._entries.length) {
                this._entry = ImmutableHashMap.this._entries[this._index++];
                while (this._entry != null && this._entry._value == null) {
                    this._entry = this._entry._next;
                }
            }
        }

        public boolean hasNext() {
            return this._entry != null;
        }

        protected DualEntry<K, V> nextEntry() {
            if (this._entry == null) {
                throw new NoSuchElementException();
            }
            DualEntry entry = this._entry;
            this._entry = this._entry._next;
            while (this._entry != null && this._entry._value == null) {
                this._entry = this._entry._next;
            }
            while (this._entry == null && this._index < ImmutableHashMap.this._entries.length) {
                this._entry = ImmutableHashMap.this._entries[this._index++];
                while (this._entry != null && this._entry._value == null) {
                    this._entry = this._entry._next;
                }
            }
            this._last = entry;
            return entry;
        }
    }

    static class DualEntry<K, V>
    implements Map.Entry<K, V> {
        private final ImmutableHashMap<K, V> _map;
        private final K _key;
        private final int _hash;
        private V _value;
        private DualEntry<K, V> _next;
        private Map.Entry<K, V> _mutable = new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return DualEntry.this._key;
            }

            @Override
            public V getValue() {
                if (DualEntry.this._value instanceof ImmutableHashMap) {
                    return ((ImmutableHashMap)DualEntry.this._value).asMutable();
                }
                return DualEntry.this._value;
            }

            @Override
            public V setValue(V value) {
                DualEntry.this._map.onChange(DualEntry.this._key);
                Object old = DualEntry.this._value;
                DualEntry.this._value = value;
                if (old != null && DualEntry.this._value == null) {
                    DualEntry.this._map._size--;
                } else if (old == null && DualEntry.this._value != null) {
                    DualEntry.this._map._size++;
                }
                return old;
            }
        };

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            if (this._value instanceof Mutable) {
                return (V)((Mutable)this._value).asImmutable();
            }
            if (this._value instanceof Map) {
                return (V)Collections.unmodifiableMap((Map)this._value);
            }
            return this._value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        DualEntry(ImmutableHashMap<K, V> map, int hash, K k, V v) {
            this._map = map;
            this._value = v;
            if (this._value != null) {
                ((ImmutableHashMap)this._map)._size++;
            }
            this._key = k;
            this._hash = hash;
        }
    }

    class ImmutableEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        ImmutableEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ImmutableEntryIterator();
        }

        @Override
        public int size() {
            return ImmutableHashMap.this._size;
        }
    }

    class MutableEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        MutableEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MutableEntryIterator();
        }

        @Override
        public int size() {
            return ImmutableHashMap.this._size;
        }
    }

    public class Mutable
    extends AbstractMap<K, V>
    implements Map<K, V> {
        public ImmutableHashMap<K, V> asImmutable() {
            return ImmutableHashMap.this;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return ImmutableHashMap.this._mutableSet;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            int hash = key.hashCode();
            int index = hash & ImmutableHashMap.this._entries.length - 1;
            DualEntry e = ImmutableHashMap.this._entries[index];
            while (e != null) {
                if (e._hash == hash && key.equals(e._key)) {
                    return true;
                }
                e = e._next;
            }
            return false;
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            int hash = key.hashCode();
            int index = hash & ImmutableHashMap.this._entries.length - 1;
            DualEntry e = ImmutableHashMap.this._entries[index];
            while (e != null) {
                if (e._hash == hash && key.equals(e._key)) {
                    return e._mutable.getValue();
                }
                e = e._next;
            }
            return null;
        }

        public Map.Entry<K, V> getEntry(K key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            int hash = key.hashCode();
            int index = hash & ImmutableHashMap.this._entries.length - 1;
            DualEntry e = ImmutableHashMap.this._entries[index];
            while (e != null) {
                if (e._hash == hash && key.equals(e._key)) {
                    return e._mutable;
                }
                e = e._next;
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            ImmutableHashMap.this.onChange(key);
            int hash = key.hashCode();
            int index = hash & ImmutableHashMap.this._entries.length - 1;
            DualEntry last = null;
            DualEntry e = ImmutableHashMap.this._entries[index];
            while (e != null) {
                if (e._hash == hash && key.equals(e._key)) {
                    Object old = e._mutable.setValue(value);
                    return old;
                }
                last = e;
                e = e._next;
            }
            e = new DualEntry(ImmutableHashMap.this, hash, key, value);
            if (last == null) {
                ((ImmutableHashMap)ImmutableHashMap.this)._entries[index] = e;
            } else {
                last._next = e;
            }
            return null;
        }

        @Override
        public void clear() {
            ImmutableHashMap.this.onChange(null);
            int i = ImmutableHashMap.this._entries.length;
            block0: while (i-- > 0) {
                int depth = 0;
                DualEntry e = ImmutableHashMap.this._entries[i];
                while (e != null) {
                    e._mutable.setValue(null);
                    if (++depth > ImmutableHashMap.this._entries.length) {
                        e._next = null;
                        continue block0;
                    }
                    e = e._next;
                }
            }
            ImmutableHashMap.this._size = 0;
        }

        @Override
        public V remove(Object key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            ImmutableHashMap.this.onChange(key);
            int hash = key.hashCode();
            int index = hash & ImmutableHashMap.this._entries.length - 1;
            DualEntry e = ImmutableHashMap.this._entries[index];
            while (e != null) {
                if (e._hash == hash && key.equals(e._key)) {
                    Object old = e._mutable.setValue(null);
                    return old;
                }
                e = e._next;
            }
            return null;
        }

        @Override
        public int size() {
            return ImmutableHashMap.this._size;
        }
    }
}

