/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cometd.bayeux.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTransport
implements Transport {
    private final String _name;
    protected Map<String, Object> _options;
    protected final List<String> _prefix = new ArrayList<String>();

    protected AbstractTransport(String name, Map<String, Object> options) {
        this._name = name;
        this._options = options == null ? new HashMap() : options;
    }

    public String getName() {
        return this._name;
    }

    public Object getOption(String name) {
        Object value = this._options.get(name);
        String prefix = null;
        for (String segment : this._prefix) {
            String key = (prefix = prefix == null ? segment : prefix + "." + segment) + "." + name;
            if (!this._options.containsKey(key)) continue;
            value = this._options.get(key);
        }
        return value;
    }

    public void setOption(String name, Object value) {
        String prefix = this.getOptionPrefix();
        this._options.put(prefix == null ? name : prefix + "." + name, value);
    }

    public String getOptionPrefix() {
        String prefix = null;
        for (String segment : this._prefix) {
            prefix = prefix == null ? segment : prefix + "." + segment;
        }
        return prefix;
    }

    public Set<String> getOptionNames() {
        HashSet<String> names = new HashSet<String>();
        return names;
    }

    public String getOption(String option, String dftValue) {
        Object value = this.getOption(option);
        return value == null ? dftValue : value.toString();
    }

    public long getOption(String option, long dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return -1L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public int getOption(String option, int dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public boolean getOption(String option, boolean dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }
}

