/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.eclipse.jetty.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapMessage
extends HashMap<String, Object>
implements Message.Mutable,
JSON.Generator,
Serializable {
    private static final long serialVersionUID = 4318697940670212190L;
    protected static JSON jsonParser = new JSON();
    private static JSON _messageParser = new JSON(){

        protected Map<String, Object> newMap() {
            return new HashMapMessage();
        }

        protected JSON contextFor(String field) {
            return jsonParser;
        }
    };
    private static JSON messagesParser = new JSON(){

        protected Map<String, Object> newMap() {
            return new HashMapMessage();
        }

        protected Object[] newArray(int size) {
            return new Message.Mutable[size];
        }

        protected JSON contextFor(String field) {
            return jsonParser;
        }

        protected JSON contextForArray() {
            return _messageParser;
        }
    };

    public HashMapMessage() {
    }

    public HashMapMessage(Message message) {
        this.putAll(message);
    }

    public void addJSON(Appendable buffer) {
        try {
            buffer.append(this.getJSON());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getAdvice() {
        Object advice = this.get("advice");
        if (advice instanceof JSON.Literal) {
            advice = JSON.parse((String)advice.toString());
            this.put("advice", advice);
        }
        return (Map)advice;
    }

    public String getChannel() {
        return (String)this.get("channel");
    }

    public ChannelId getChannelId() {
        return new ChannelId(this.getChannel());
    }

    public String getClientId() {
        return (String)this.get("clientId");
    }

    public Object getData() {
        return this.get("data");
    }

    public Map<String, Object> getDataAsMap() {
        Object data = this.get("data");
        if (data instanceof JSON.Literal) {
            data = JSON.parse((String)data.toString());
            this.put("data", data);
        }
        return (Map)data;
    }

    public Map<String, Object> getExt() {
        Object ext = this.get("ext");
        if (ext instanceof JSON.Literal) {
            ext = JSON.parse((String)ext.toString());
            this.put("ext", ext);
        }
        return (Map)ext;
    }

    public String getId() {
        Object id = this.get("id");
        return id == null ? null : String.valueOf(id);
    }

    public String getJSON() {
        StringBuilder buf = new StringBuilder(jsonParser.getStringBufferSize());
        jsonParser.appendMap((Appendable)buf, (Map)this);
        return ((Object)buf).toString();
    }

    public Map<String, Object> getAdvice(boolean create) {
        Map<String, Object> advice = this.getAdvice();
        if (create && advice == null) {
            advice = new HashMap<String, Object>();
            this.put("advice", advice);
        }
        return advice;
    }

    public Map<String, Object> getDataAsMap(boolean create) {
        Map<String, Object> data = this.getDataAsMap();
        if (create && data == null) {
            data = new HashMap<String, Object>();
            this.put("data", data);
        }
        return data;
    }

    public Map<String, Object> getExt(boolean create) {
        Map<String, Object> ext = this.getExt();
        if (create && ext == null) {
            ext = new HashMap<String, Object>();
            this.put("ext", ext);
        }
        return ext;
    }

    public boolean isMeta() {
        return ChannelId.isMeta((String)this.getChannel());
    }

    public boolean isSuccessful() {
        Boolean value = (Boolean)this.get("successful");
        return value != null && value != false;
    }

    @Override
    public String toString() {
        return this.getJSON();
    }

    public void setChannel(String channel) {
        this.put("channel", channel);
    }

    public void setClientId(String clientId) {
        this.put("clientId", clientId);
    }

    public void setData(Object data) {
        this.put("data", data);
    }

    public void setId(String id) {
        this.put("id", id);
    }

    public void setSuccessful(boolean successful) {
        this.put("successful", successful);
    }

    public static List<Message.Mutable> parseMessages(String content) {
        Object object = messagesParser.parse((JSON.Source)new JSON.StringSource(content));
        if (object instanceof Message.Mutable) {
            return Collections.singletonList((Message.Mutable)object);
        }
        return Arrays.asList((Message.Mutable[])object);
    }
}

