/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.cometd.bayeux.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JacksonJSONContext<T extends Message.Mutable, I extends T> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JavaType rootArrayType = this.objectMapper.constructType(this.rootArrayClass());

    protected JacksonJSONContext() {
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected abstract Class<I[]> rootArrayClass();

    public T[] parse(InputStream stream) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(stream, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public T[] parse(Reader reader) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(reader, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public T[] parse(String json) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(json, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException(json, -1).initCause(x);
        }
    }

    public String generate(T message) {
        try {
            return this.getObjectMapper().writeValueAsString(message);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public String generate(T[] messages) {
        try {
            return this.getObjectMapper().writeValueAsString(messages);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }
}

