/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.common.JSONContext;
import org.eclipse.jetty.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JettyJSONContext<T extends Message.Mutable> {
    private final FieldJSON _jsonParser = new FieldJSON();
    private final FieldJSON _messageParser = new MessageJSON();
    private final FieldJSON _messagesParser = new MessagesJSON();

    protected JettyJSONContext() {
    }

    public JSON getJSON() {
        return this._jsonParser;
    }

    protected abstract T newRoot();

    protected abstract T[] newRootArray(int var1);

    public T[] parse(InputStream stream) throws ParseException {
        return this.parse(new InputStreamReader(stream, Charset.forName("UTF-8")));
    }

    public T[] parse(Reader reader) throws ParseException {
        try {
            Object object = this._messagesParser.parse((JSON.Source)new JSON.ReaderSource(reader));
            return this.adapt(object);
        }
        catch (Exception x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public T[] parse(String json) throws ParseException {
        try {
            Object object = this._messagesParser.parse((JSON.Source)new JSON.StringSource(json));
            return this.adapt(object);
        }
        catch (Exception x) {
            throw (ParseException)new ParseException(json, -1).initCause(x);
        }
    }

    private T[] adapt(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return (Message.Mutable[])object;
        }
        Message.Mutable[] result = this.newRootArray(1);
        result[0] = (Message.Mutable)object;
        return result;
    }

    public String generate(T message) {
        return this._messageParser.toJSON(message);
    }

    public String generate(T[] messages) {
        return this._messagesParser.toJSON(messages);
    }

    public JSONContext.Parser getParser() {
        return new JSONParser();
    }

    public JSONContext.Generator getGenerator() {
        return new JSONGenerator();
    }

    private class JSONGenerator
    implements JSONContext.Generator {
        private JSONGenerator() {
        }

        public String generate(Object object) {
            return JettyJSONContext.this.getJSON().toJSON(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JSONParser
    implements JSONContext.Parser {
        private JSONParser() {
        }

        @Override
        public <T> T parse(Reader reader, Class<T> type) throws ParseException {
            return (T)JettyJSONContext.this.getJSON().parse((JSON.Source)new JSON.ReaderSource(reader));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessagesJSON
    extends FieldJSON {
        private MessagesJSON() {
        }

        protected Map<String, Object> newMap() {
            return JettyJSONContext.this.newRoot();
        }

        protected Object[] newArray(int size) {
            return JettyJSONContext.this.newRootArray(size);
        }

        protected JSON contextFor(String field) {
            return JettyJSONContext.this.getJSON();
        }

        protected JSON contextForArray() {
            return JettyJSONContext.this._messageParser;
        }

        @Override
        protected JSON.Convertor getConvertor(Class forClass) {
            return JettyJSONContext.this._messageParser.getConvertor(forClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageJSON
    extends FieldJSON {
        private MessageJSON() {
        }

        protected Map<String, Object> newMap() {
            return JettyJSONContext.this.newRoot();
        }

        protected JSON contextFor(String field) {
            return JettyJSONContext.this.getJSON();
        }

        @Override
        protected JSON.Convertor getConvertor(Class forClass) {
            return JettyJSONContext.this._jsonParser.getConvertor(forClass);
        }
    }

    private class FieldJSON
    extends JSON {
        private FieldJSON() {
        }

        protected JSON.Convertor getConvertor(Class forClass) {
            return super.getConvertor(forClass);
        }
    }
}

