/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.List;
import org.cometd.bayeux.Message;
import org.cometd.common.JSONContext;

public abstract class JacksonJSONContext<T extends Message.Mutable, I extends T> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JavaType rootArrayType = this.objectMapper.constructType(this.rootArrayClass());

    protected JacksonJSONContext() {
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected abstract Class<I[]> rootArrayClass();

    public T[] parse(InputStream stream) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(stream, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public T[] parse(Reader reader) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(reader, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public T[] parse(String json) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(json, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException(json, -1).initCause(x);
        }
    }

    public String generate(T message) {
        try {
            return this.getObjectMapper().writeValueAsString(message);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public String generate(List<T> messages) {
        try {
            Message.Mutable[] mutables = new Message.Mutable[messages.size()];
            messages.toArray(mutables);
            return this.getObjectMapper().writeValueAsString((Object)mutables);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public JSONContext.Parser getParser() {
        return new ObjectMapperParser();
    }

    public JSONContext.Generator getGenerator() {
        return new ObjectMapperGenerator();
    }

    private class ObjectMapperGenerator
    implements JSONContext.Generator {
        private ObjectMapperGenerator() {
        }

        @Override
        public String generate(Object object) {
            try {
                return JacksonJSONContext.this.getObjectMapper().writeValueAsString(object);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    private class ObjectMapperParser
    implements JSONContext.Parser {
        private ObjectMapperParser() {
        }

        @Override
        public <T> T parse(Reader reader, Class<T> type) throws ParseException {
            try {
                return (T)JacksonJSONContext.this.getObjectMapper().readValue(reader, type);
            }
            catch (IOException x) {
                throw (ParseException)new ParseException("", -1).initCause(x);
            }
        }
    }
}

