/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.cometd.bayeux.Promise;

public class AsyncFoldLeft {
    public static <T, R> void run(T[] array, R zero, Operation<T, R> operation, Promise<R> promise) {
        if (array.length == 0) {
            promise.succeed(zero);
        } else {
            AsyncFoldLeft.run(Arrays.asList(array), zero, operation, promise);
        }
    }

    public static <T, R> void run(List<T> list, R zero, Operation<T, R> operation, Promise<R> promise) {
        if (list.isEmpty()) {
            promise.succeed(zero);
        } else {
            LoopImpl<T, R> loop = new LoopImpl<T, R>(list, zero, operation, promise);
            loop.run();
        }
    }

    private static class LoopImpl<T, R>
    implements Loop<R> {
        private final AtomicReference<State> state = new AtomicReference<State>(State.LOOP);
        private final AtomicReference<Throwable> failure = new AtomicReference();
        private final List<T> list;
        private final AtomicReference<R> result;
        private final Operation<T, R> operation;
        private final Promise<R> promise;
        private int index;

        public LoopImpl(List<T> list, R zero, Operation<T, R> operation, Promise<R> promise) {
            this.list = list;
            this.result = new AtomicReference<R>(zero);
            this.operation = operation;
            this.promise = promise;
        }

        void run() {
            block6: while (this.index < this.list.size()) {
                this.state.set(State.LOOP);
                this.operation.apply(this.result.get(), this.list.get(this.index), this);
                block7: while (true) {
                    State current = this.state.get();
                    switch (current) {
                        case LOOP: {
                            if (!this.state.compareAndSet(current, State.ASYNC)) continue block7;
                            return;
                        }
                        case PROCEED: {
                            ++this.index;
                            continue block6;
                        }
                        case LEAVE: {
                            this.promise.succeed(this.result.get());
                            return;
                        }
                        case FAIL: {
                            this.promise.fail(this.failure.get());
                            return;
                        }
                    }
                    break;
                }
                throw new IllegalStateException();
            }
            this.promise.succeed(this.result.get());
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void proceed(R r) {
            this.result.set(r);
            block4: while (true) lbl-1000:
            // 3 sources

            {
                current = this.state.get();
                switch (1.$SwitchMap$org$cometd$common$AsyncFoldLeft$State[current.ordinal()]) {
                    case 1: {
                        if (!this.state.compareAndSet(current, State.PROCEED)) ** GOTO lbl-1000
                        return;
                    }
                    case 5: {
                        if (!this.state.compareAndSet(current, State.PROCEED)) continue block4;
                        ++this.index;
                        this.run();
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        @Override
        public void leave(R r) {
            this.result.set(r);
            block3: while (true) {
                State current = this.state.get();
                switch (current) {
                    case LOOP: 
                    case ASYNC: {
                        if (!this.state.compareAndSet(current, State.LEAVE)) continue block3;
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        @Override
        public void fail(Throwable x) {
            this.failure.compareAndSet(null, x);
            block4: while (true) {
                State current = this.state.get();
                switch (current) {
                    case LOOP: {
                        if (!this.state.compareAndSet(current, State.FAIL)) continue block4;
                        return;
                    }
                    case ASYNC: {
                        if (!this.state.compareAndSet(current, State.FAIL)) break block4;
                        this.promise.fail(x);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
    }

    private static enum State {
        LOOP,
        ASYNC,
        PROCEED,
        LEAVE,
        FAIL;

    }

    public static interface Loop<R> {
        default public void proceed(R r) {
        }

        default public void leave(R r) {
        }

        default public void fail(Throwable failure) {
        }
    }

    @FunctionalInterface
    public static interface Operation<T, R> {
        public void apply(R var1, T var2, Loop<R> var3);
    }
}

