/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Arrays;
import org.cometd.bayeux.Message;
import org.cometd.common.JSONContext;
import org.eclipse.jetty.util.Utf8StringBuilder;

public class BufferingJSONAsyncParser
implements JSONContext.AsyncParser {
    private final Utf8StringBuilder buffer = new Utf8StringBuilder();
    private final JSONContext<? extends Message.Mutable> jsonContext;

    public BufferingJSONAsyncParser(JSONContext<? extends Message.Mutable> jsonContext) {
        this.jsonContext = jsonContext;
    }

    @Override
    public void parse(byte[] bytes, int offset, int length) {
        this.buffer.append(bytes, offset, length);
    }

    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.buffer.append(byteBuffer);
    }

    @Override
    public <R> R complete() {
        try {
            String json = this.buffer.toString();
            this.buffer.reset();
            Message.Mutable[] result = this.jsonContext.parse(json);
            return (R)Arrays.asList(result);
        }
        catch (ParseException x) {
            throw new IllegalArgumentException(x);
        }
    }
}

