/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import org.cometd.bayeux.Promise;

public class AsyncFoldLeft {
    public static <T, R> void run(T[] array, R zero, Operation<T, R> operation, Promise<R> promise) {
        int size = array.length;
        if (size == 0) {
            promise.succeed(zero);
        } else {
            IndexedLoop<Object, R> loop = new IndexedLoop<Object, R>(i -> array[i], size, zero, operation, promise);
            loop.run();
        }
    }

    public static <T, R> void run(Iterable<T> iterable, R zero, Operation<T, R> operation, Promise<R> promise) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            promise.succeed(zero);
        } else {
            IteratorLoop<T, R> loop = new IteratorLoop<T, R>(iterator, zero, operation, promise);
            loop.run();
        }
    }

    public static <T, R> void reverseRun(List<T> list, R zero, Operation<T, R> operation, Promise<R> promise) {
        AsyncFoldLeft.run(new ReverseIterable<T>(list), zero, operation, promise);
    }

    private AsyncFoldLeft() {
    }

    private static class IndexedLoop<T, R>
    extends AbstractLoop<T, R> {
        private final IntFunction<T> element;
        private final int size;
        private int index;

        private IndexedLoop(IntFunction<T> element, int size, R zero, Operation<T, R> operation, Promise<R> promise) {
            super(zero, operation, promise);
            this.element = element;
            this.size = size;
        }

        @Override
        boolean hasCurrent() {
            return this.index < this.size;
        }

        @Override
        T current() {
            return this.element.apply(this.index);
        }

        @Override
        void next() {
            ++this.index;
        }
    }

    @FunctionalInterface
    public static interface Operation<T, R> {
        public void apply(R var1, T var2, Loop<R> var3);
    }

    private static class IteratorLoop<T, R>
    extends AbstractLoop<T, R> {
        private final Iterator<T> iterator;
        private boolean hasCurrent;
        private T current;

        private IteratorLoop(Iterator<T> iterator, R zero, Operation<T, R> operation, Promise<R> promise) {
            super(zero, operation, promise);
            this.iterator = iterator;
            this.next();
        }

        @Override
        boolean hasCurrent() {
            return this.hasCurrent;
        }

        @Override
        T current() {
            if (!this.hasCurrent) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        void next() {
            this.hasCurrent = this.iterator.hasNext();
            this.current = this.hasCurrent ? this.iterator.next() : null;
        }
    }

    private static class ReverseIterable<T>
    implements Iterable<T>,
    Iterator<T> {
        private final ListIterator<T> iterator;

        private ReverseIterable(List<T> list) {
            this.iterator = list.listIterator(list.size());
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T next() {
            return this.iterator.previous();
        }
    }

    private static abstract class AbstractLoop<T, R>
    implements Loop<R> {
        private final AtomicReference<State> state = new AtomicReference<State>(State.LOOP);
        private final AtomicReference<Throwable> failure = new AtomicReference();
        private final AtomicReference<R> result;
        private final Operation<T, R> operation;
        private final Promise<R> promise;

        private AbstractLoop(R zero, Operation<T, R> operation, Promise<R> promise) {
            this.result = new AtomicReference<R>(zero);
            this.operation = operation;
            this.promise = promise;
        }

        abstract boolean hasCurrent();

        abstract T current();

        abstract void next();

        void run() {
            block6: while (this.hasCurrent()) {
                State current;
                this.state.set(State.LOOP);
                this.operation.apply(this.result.get(), this.current(), this);
                block7: while (true) {
                    current = this.state.get();
                    switch (current.ordinal()) {
                        case 0: {
                            if (!this.state.compareAndSet(current, State.ASYNC)) continue block7;
                            return;
                        }
                        case 2: {
                            this.next();
                            continue block6;
                        }
                        case 3: {
                            this.promise.succeed(this.result.get());
                            return;
                        }
                        case 4: {
                            this.promise.fail(this.failure.get());
                            return;
                        }
                    }
                    break;
                }
                this.promise.fail((Throwable)new IllegalStateException("Could not run loop in state " + String.valueOf((Object)current)));
                return;
            }
            this.promise.succeed(this.result.get());
        }

        @Override
        public void proceed(R r) {
            this.result.set(r);
            block5: while (true) {
                State current = this.state.get();
                switch (current.ordinal()) {
                    case 0: {
                        if (!this.state.compareAndSet(current, State.PROCEED)) continue block5;
                        return;
                    }
                    case 1: {
                        if (!this.state.compareAndSet(current, State.PROCEED)) continue block5;
                        this.next();
                        this.run();
                        return;
                    }
                    case 4: {
                        return;
                    }
                }
                this.failure.compareAndSet(null, new IllegalStateException("Could not proceed loop in state " + String.valueOf((Object)current)));
                if (this.state.compareAndSet(current, State.FAIL)) break;
            }
        }

        @Override
        public void leave(R r) {
            this.result.set(r);
            block5: while (true) {
                State current = this.state.get();
                switch (current.ordinal()) {
                    case 0: {
                        if (!this.state.compareAndSet(current, State.LEAVE)) continue block5;
                        return;
                    }
                    case 1: {
                        if (!this.state.compareAndSet(current, State.LEAVE)) continue block5;
                        this.promise.succeed(this.result.get());
                        return;
                    }
                    case 4: {
                        return;
                    }
                }
                this.failure.compareAndSet(null, new IllegalStateException("Could not leave loop in state " + String.valueOf((Object)current)));
                if (this.state.compareAndSet(current, State.FAIL)) break;
            }
        }

        @Override
        public void fail(Throwable x) {
            this.failure.compareAndSet(null, x);
            while (true) {
                State current = this.state.get();
                switch (current.ordinal()) {
                    case 0: 
                    case 2: 
                    case 3: {
                        if (!this.state.compareAndSet(current, State.FAIL)) break;
                        return;
                    }
                    case 1: {
                        if (!this.state.compareAndSet(current, State.FAIL)) break;
                        this.promise.fail(x);
                        return;
                    }
                    case 4: {
                        return;
                    }
                }
            }
        }
    }

    private static enum State {
        LOOP,
        ASYNC,
        PROCEED,
        LEAVE,
        FAIL;

    }

    public static interface Loop<R> {
        default public void proceed(R r) {
        }

        default public void leave(R r) {
        }

        default public void fail(Throwable failure) {
        }
    }
}

