/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.http.jetty.JettyHttpClientTransport;
import org.cometd.client.transport.ClientTransport;
import org.eclipse.jetty.client.HttpClient;

public class ConsoleChatClient {
    private volatile String nickname = "";
    private volatile BayeuxClient client;
    private final ChatListener chatListener = new ChatListener();
    private final MembersListener membersListener = new MembersListener();

    public static void main(String[] args) throws Exception {
        ConsoleChatClient client = new ConsoleChatClient();
        client.run();
    }

    private void run() throws Exception {
        HashMap<String, String> data;
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String defaultURL = "http://localhost:8080/cometd/cometd";
        System.err.printf("Enter Bayeux Server URL [%s]: ", defaultURL);
        String url = input.readLine();
        if (url == null) {
            return;
        }
        if (url.trim().length() == 0) {
            url = defaultURL;
        }
        while (this.nickname.trim().length() == 0) {
            System.err.print("Enter nickname: ");
            this.nickname = input.readLine();
            if (this.nickname != null) continue;
            return;
        }
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        this.client = new BayeuxClient(url, (ClientTransport)new JettyHttpClientTransport(null, httpClient), new ClientTransport[0]);
        this.client.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new InitializerListener());
        this.client.getChannel("/meta/connect").addListener((ClientSessionChannel.ClientSessionChannelListener)new ConnectionListener());
        this.client.handshake();
        boolean success = this.client.waitFor(1000L, BayeuxClient.State.CONNECTED, new BayeuxClient.State[0]);
        if (!success) {
            System.err.printf("Could not handshake with server at %s%n", url);
            return;
        }
        while (true) {
            String text;
            if ((text = input.readLine()) == null || "\\q".equals(text)) break;
            data = new HashMap();
            data.put("user", this.nickname);
            data.put("chat", text);
            this.client.getChannel("/chat/demo").publish(data);
        }
        data = new HashMap<String, String>();
        data.put("user", this.nickname);
        data.put("membership", "leave");
        data.put("chat", this.nickname + " has left");
        this.client.getChannel("/chat/demo").publish(data);
        this.client.disconnect(1000L);
    }

    private void initialize() {
        this.client.batch(() -> {
            ClientSessionChannel chatChannel = this.client.getChannel("/chat/demo");
            chatChannel.subscribe((ClientSessionChannel.MessageListener)this.chatListener);
            ClientSessionChannel membersChannel = this.client.getChannel("/members/demo");
            membersChannel.subscribe((ClientSessionChannel.MessageListener)this.membersListener);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("user", this.nickname);
            data.put("membership", "join");
            data.put("chat", this.nickname + " has joined");
            chatChannel.publish(data);
        });
    }

    private void connectionEstablished() {
        System.err.printf("system: Connection to Server Opened%n", new Object[0]);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("user", this.nickname);
        data.put("room", "/chat/demo");
        this.client.getChannel("/service/members").publish(data);
    }

    private void connectionClosed() {
        System.err.printf("system: Connection to Server Closed%n", new Object[0]);
    }

    private void connectionBroken() {
        System.err.printf("system: Connection to Server Broken%n", new Object[0]);
    }

    private class MembersListener
    implements ClientSessionChannel.MessageListener {
        private MembersListener() {
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            Object data = message.getData();
            Object[] members = data instanceof List ? ((List)data).toArray() : (Object[])data;
            System.err.printf("Members: %s%n", Arrays.asList(members));
        }
    }

    private class ChatListener
    implements ClientSessionChannel.MessageListener {
        private ChatListener() {
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            Map data = message.getDataAsMap();
            String fromUser = (String)data.get("user");
            String text = (String)data.get("chat");
            System.err.printf("%s: %s%n", fromUser, text);
        }
    }

    private class ConnectionListener
    implements ClientSessionChannel.MessageListener {
        private boolean wasConnected;
        private boolean connected;

        private ConnectionListener() {
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            if (ConsoleChatClient.this.client.isDisconnected()) {
                this.connected = false;
                ConsoleChatClient.this.connectionClosed();
                return;
            }
            this.wasConnected = this.connected;
            this.connected = message.isSuccessful();
            if (!this.wasConnected && this.connected) {
                ConsoleChatClient.this.connectionEstablished();
            } else if (this.wasConnected && !this.connected) {
                ConsoleChatClient.this.connectionBroken();
            }
        }
    }

    private class InitializerListener
    implements ClientSessionChannel.MessageListener {
        private InitializerListener() {
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            if (message.isSuccessful()) {
                ConsoleChatClient.this.initialize();
            }
        }
    }
}

