/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples.spring.boot;

import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.cometd.annotation.server.AnnotationCometDServlet;
import org.cometd.examples.ChatService;
import org.cometd.examples.CometDDemoServlet;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletContextInitializer;

@SpringBootApplication
public class CometDApplication
implements ServletContextInitializer {
    public static void main(String[] args) {
        SpringApplication.run(CometDApplication.class, (String[])args);
    }

    public void onStartup(ServletContext servletContext) {
        ServletRegistration.Dynamic cometdServlet = servletContext.addServlet("cometd", AnnotationCometDServlet.class);
        String mapping = "/cometd/*";
        cometdServlet.addMapping(new String[]{mapping});
        cometdServlet.setAsyncSupported(true);
        cometdServlet.setLoadOnStartup(1);
        cometdServlet.setInitParameter("services", ChatService.class.getName());
        cometdServlet.setInitParameter("ws.cometdURLMapping", mapping);
        ServletRegistration.Dynamic demoServlet = servletContext.addServlet("demo", CometDDemoServlet.class);
        demoServlet.addMapping(new String[]{"/demo"});
        demoServlet.setAsyncSupported(true);
        demoServlet.setLoadOnStartup(2);
    }
}

