/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.SessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxService;

public class ChatService
extends BayeuxService {
    private final ConcurrentMap<String, Map<String, String>> _members = new ConcurrentHashMap();

    public ChatService(BayeuxServer bayeux) {
        super(bayeux, "chat");
        this.subscribe("/service/members", "handleMembership");
        this.subscribe("/service/privatechat", "privateChat");
    }

    public void handleMembership(ServerSession client, Map<String, Object> data) {
        ConcurrentHashMap<String, String> newRoomMembers;
        String room = (String)data.get("room");
        ConcurrentHashMap<String, String> roomMembers = (ConcurrentHashMap<String, String>)this._members.get(room);
        if (roomMembers == null && (roomMembers = (Map)this._members.putIfAbsent(room, newRoomMembers = new ConcurrentHashMap<String, String>())) == null) {
            roomMembers = newRoomMembers;
        }
        ConcurrentHashMap<String, String> members = roomMembers;
        String userName = (String)data.get("user");
        members.put(userName, client.getId());
        client.addListener((ServerSession.ServerSessionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.broadcastMembers(members.keySet());
    }

    private void broadcastMembers(Set<String> members) {
        SessionChannel channel = this.getClient().getChannel("/chat/members");
        channel.publish(members);
    }

    public void privateChat(ServerSession client, ServerMessage message) {
        Map data = message.getDataAsMap();
        String room = (String)data.get("room");
        Map membersMap = (Map)this._members.get(room);
        String[] peerNames = ((String)data.get("peer")).split(",");
        ArrayList<ServerSession> peers = new ArrayList<ServerSession>(peerNames.length);
        for (String peerName : peerNames) {
            ServerSession peer;
            String peerId = (String)membersMap.get(peerName);
            if (peerId == null || (peer = this.getBayeux().getSession(peerId)) == null) continue;
            peers.add(peer);
        }
        if (peers.size() > 0) {
            HashMap chat = new HashMap();
            chat.put("chat", data.get("chat"));
            chat.put("user", data.get("user"));
            chat.put("scope", "private");
            ServerMessage.Mutable forward = this.getBayeux().newMessage();
            forward.setChannel(room);
            forward.setId(message.getId());
            forward.setData(chat);
            for (ServerSession peer : peers) {
                peer.deliver((Session)this.getClient().getServerSession(), (ServerMessage)forward);
            }
            client.deliver((Session)this.getClient().getServerSession(), (ServerMessage)forward);
        }
    }

    static /* synthetic */ void access$000(ChatService x0, Set x1) {
        x0.broadcastMembers(x1);
    }
}

