/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.examples.ChatService;
import org.cometd.server.AbstractService;
import org.cometd.server.filter.DataFilter;
import org.cometd.server.filter.DataFilterMessageListener;
import org.cometd.server.filter.NoMarkupFilter;

public class ChatService
extends AbstractService {
    private final ConcurrentMap<String, Map<String, String>> _members = new ConcurrentHashMap();

    public ChatService(BayeuxServer bayeux) {
        super(bayeux, "chat");
        DataFilterMessageListener noMarkup = new DataFilterMessageListener(new DataFilter[]{new NoMarkupFilter()});
        1 initNoMarkup = new /* Unavailable Anonymous Inner Class!! */;
        if (!bayeux.createIfAbsent("/chat/**", new ConfigurableServerChannel.Initializer[]{initNoMarkup}) || !bayeux.createIfAbsent("/service/privatechat", new ConfigurableServerChannel.Initializer[]{initNoMarkup})) {
            throw new IllegalStateException();
        }
        this.addService("/service/members", "handleMembership");
        this.addService("/service/privatechat", "privateChat");
    }

    public void handleMembership(ServerSession client, Map<String, Object> data) {
        ConcurrentHashMap<String, String> newRoomMembers;
        String room = (String)data.get("room");
        ConcurrentHashMap<String, String> roomMembers = (ConcurrentHashMap<String, String>)this._members.get(room);
        if (roomMembers == null && (roomMembers = (Map)this._members.putIfAbsent(room, newRoomMembers = new ConcurrentHashMap<String, String>())) == null) {
            roomMembers = newRoomMembers;
        }
        ConcurrentHashMap<String, String> members = roomMembers;
        String userName = (String)data.get("user");
        members.put(userName, client.getId());
        client.addListener((ServerSession.ServerSessionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.broadcastMembers(members.keySet());
    }

    private void broadcastMembers(Set<String> members) {
        ClientSessionChannel channel = this.getLocalSession().getChannel("/chat/members");
        channel.publish(members);
    }

    public void privateChat(ServerSession client, ServerMessage message) {
        Map data = message.getDataAsMap();
        String room = (String)data.get("room");
        Map membersMap = (Map)this._members.get(room);
        String[] peerNames = ((String)data.get("peer")).split(",");
        ArrayList<ServerSession> peers = new ArrayList<ServerSession>(peerNames.length);
        for (String peerName : peerNames) {
            ServerSession peer;
            String peerId = (String)membersMap.get(peerName);
            if (peerId == null || (peer = this.getBayeux().getSession(peerId)) == null) continue;
            peers.add(peer);
        }
        if (peers.size() > 0) {
            HashMap<String, String> chat = new HashMap<String, String>();
            String text = (String)data.get("chat");
            chat.put("chat", text);
            chat.put("user", (String)data.get("user"));
            chat.put("scope", "private");
            ServerMessage.Mutable forward = this.getBayeux().newMessage();
            forward.setChannel(room);
            forward.setId(message.getId());
            forward.setData(chat);
            if (text.lastIndexOf("lazy") > 0) {
                forward.setLazy(true);
            }
            for (ServerSession peer : peers) {
                peer.deliver((Session)this.getClient().getServerSession(), (ServerMessage)forward);
            }
            client.deliver((Session)this.getClient().getServerSession(), (ServerMessage)forward);
        }
    }

    static /* synthetic */ void access$000(ChatService x0, Set x1) {
        x0.broadcastMembers(x1);
    }
}

