/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.examples.ChatService;
import org.cometd.java.annotation.Listener;
import org.cometd.java.annotation.Service;
import org.cometd.server.filter.DataFilter;
import org.cometd.server.filter.DataFilterMessageListener;
import org.cometd.server.filter.NoMarkupFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="chat")
public class ChatService {
    private final ConcurrentMap<String, Map<String, String>> _members = new ConcurrentHashMap();
    private BayeuxServer _bayeux;
    @org.cometd.java.annotation.Session
    private ServerSession _session;

    @Inject
    public void setBayeux(BayeuxServer bayeux) {
        this._bayeux = bayeux;
        DataFilterMessageListener noMarkup = new DataFilterMessageListener(bayeux, new DataFilter[]{new NoMarkupFilter(), new BadWordFilter(this)});
        if (!bayeux.createIfAbsent("/chat/**", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */})) {
            throw new IllegalStateException();
        }
        if (!bayeux.createIfAbsent("/service/privatechat", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */})) {
            throw new IllegalStateException();
        }
        if (!bayeux.createIfAbsent("/service/members", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */})) {
            throw new IllegalStateException();
        }
    }

    @Listener(value={"/service/members"})
    public void handleMembership(ServerSession client, ServerMessage message) {
        ConcurrentHashMap<String, String> newRoomMembers;
        Map data = message.getDataAsMap();
        String room = (String)data.get("room");
        ConcurrentHashMap<String, String> roomMembers = (ConcurrentHashMap<String, String>)this._members.get(room);
        if (roomMembers == null && (roomMembers = (Map)this._members.putIfAbsent(room, newRoomMembers = new ConcurrentHashMap<String, String>())) == null) {
            roomMembers = newRoomMembers;
        }
        ConcurrentHashMap<String, String> members = roomMembers;
        String userName = (String)data.get("user");
        members.put(userName, client.getId());
        client.addListener((ServerSession.ServerSessionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.broadcastMembers(members.keySet());
    }

    private void broadcastMembers(Set<String> members) {
        ClientSessionChannel channel = this._session.getLocalSession().getChannel("/chat/members");
        channel.publish(members);
    }

    @Listener(value={"/service/privatechat"})
    public void privateChat(ServerSession client, ServerMessage message) {
        Map data = message.getDataAsMap();
        String room = (String)data.get("room");
        Map membersMap = (Map)this._members.get(room);
        String[] peerNames = ((String)data.get("peer")).split(",");
        ArrayList<ServerSession> peers = new ArrayList<ServerSession>(peerNames.length);
        for (String peerName : peerNames) {
            ServerSession peer;
            String peerId = (String)membersMap.get(peerName);
            if (peerId == null || (peer = this._bayeux.getSession(peerId)) == null) continue;
            peers.add(peer);
        }
        if (peers.size() > 0) {
            HashMap<String, String> chat = new HashMap<String, String>();
            String text = (String)data.get("chat");
            chat.put("chat", text);
            chat.put("user", (String)data.get("user"));
            chat.put("scope", "private");
            ServerMessage.Mutable forward = this._bayeux.newMessage();
            forward.setChannel(room);
            forward.setId(message.getId());
            forward.setData(chat);
            if (text.lastIndexOf("lazy") > 0) {
                forward.setLazy(true);
            }
            for (ServerSession peer : peers) {
                if (peer == client) continue;
                peer.deliver((Session)this._session, forward);
            }
            client.deliver((Session)this._session, forward);
        }
    }

    static /* synthetic */ void access$000(ChatService x0, Set x1) {
        x0.broadcastMembers(x1);
    }
}

