/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.examples.ChatService;
import org.cometd.examples.CometdDemoServlet;
import org.cometd.java.annotation.ServerAnnotationProcessor;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.cometd.server.ext.TimesyncExtension;

public class CometdDemoServlet
extends GenericServlet {
    private ServerAnnotationProcessor processor;

    public void init() throws ServletException {
        super.init();
        BayeuxServerImpl bayeux = (BayeuxServerImpl)this.getServletContext().getAttribute("org.cometd.bayeux");
        bayeux.addExtension((BayeuxServer.Extension)new TimesyncExtension());
        bayeux.addExtension((BayeuxServer.Extension)new AcknowledgedMessagesExtension());
        bayeux.createIfAbsent("/**", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */});
        bayeux.getChannel("/meta/handshake").addAuthorizer((Authorizer)GrantAuthorizer.GRANT_PUBLISH);
        this.processor = ServerAnnotationProcessor.get((BayeuxServer)bayeux);
        this.processor.configure((Object)new EchoRPC());
        this.processor.configure((Object)new Monitor());
        this.processor.configure((Object)new ChatService());
        bayeux.createIfAbsent("/foo/bar/baz", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */});
        if (bayeux.getLogger().isDebugEnabled()) {
            System.err.println(bayeux.dump());
        }
    }

    public void destroy() {
        super.destroy();
        this.processor.close();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ((HttpServletResponse)res).sendError(503);
    }
}

