/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import javax.servlet.Servlet;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.examples.CometdDemoServlet;
import org.cometd.java.annotation.AnnotationCometdServlet;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.DefaultSecurityPolicy;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class CometdDemo {
    public static void main(String[] args) throws Exception {
        int port = args.length == 0 ? 8080 : Integer.parseInt(args[0]);
        String base = "..";
        Server server = new Server();
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setMinThreads(5);
        qtp.setMaxThreads(200);
        server.setThreadPool((ThreadPool)qtp);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        connector.setMaxIdleTime(120000);
        connector.setLowResourcesMaxIdleTime(60000);
        connector.setLowResourcesConnections(20000);
        connector.setAcceptQueueSize(5000);
        server.addConnector((Connector)connector);
        SocketConnector bconnector = new SocketConnector();
        bconnector.setPort(port + 1);
        server.addConnector((Connector)bconnector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        context.setBaseResource((Resource)new ResourceCollection(new Resource[]{Resource.newResource((String)"../../cometd-demo/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/common/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/jquery/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/examples-jquery/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/dojo/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/examples-dojo/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/dojo/target/war/work/org.dojotoolkit/dojo-war/")}));
        ServletHolder dftServlet = context.addServlet(DefaultServlet.class, "/");
        dftServlet.setInitOrder(1);
        AnnotationCometdServlet cometdServlet = new AnnotationCometdServlet();
        ServletHolder comet = new ServletHolder((Servlet)cometdServlet);
        context.addServlet(comet, "/cometd/*");
        comet.setInitParameter("timeout", "20000");
        comet.setInitParameter("interval", "100");
        comet.setInitParameter("maxInterval", "10000");
        comet.setInitParameter("multiFrameInterval", "5000");
        comet.setInitParameter("logLevel", "1");
        comet.setInitParameter("services", "org.cometd.examples.ChatService");
        comet.setInitParameter("transports", "org.cometd.websocket.server.WebSocketTransport");
        comet.setInitOrder(2);
        ServletHolder demo = context.addServlet(CometdDemoServlet.class, "/demo");
        demo.setInitOrder(3);
        server.start();
        BayeuxServerImpl bayeux = cometdServlet.getBayeux();
        bayeux.setSecurityPolicy((SecurityPolicy)new DefaultSecurityPolicy());
        if (Boolean.getBoolean("LAZY")) {
            bayeux.addExtension((BayeuxServer.Extension)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Boolean.getBoolean("LAZYCHAT")) {
            String channelName = "/chat/demo";
            bayeux.createIfAbsent(channelName, new ConfigurableServerChannel.Initializer[0]);
            ServerChannel chat_demo = bayeux.getChannel(channelName);
            chat_demo.setLazy(true);
            chat_demo.setPersistent(true);
        }
    }
}

