/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.benchmark.Atomics;
import org.cometd.benchmark.MonitoringQueuedThreadPool;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class MonitoringQueuedThreadPool
extends QueuedThreadPool {
    private final AtomicInteger threads = new AtomicInteger();
    private final AtomicInteger maxThreads = new AtomicInteger();
    private final MonitoringBlockingArrayQueue queue;

    public MonitoringQueuedThreadPool(int maxThreads) {
        super((BlockingQueue)new MonitoringBlockingArrayQueue(maxThreads, maxThreads));
        this.setMaxThreads(maxThreads);
        this.queue = (MonitoringBlockingArrayQueue)this.getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runJob(Runnable job) {
        Atomics.updateMax((AtomicInteger)this.maxThreads, (int)this.threads.incrementAndGet());
        try {
            super.runJob(job);
        }
        finally {
            this.threads.decrementAndGet();
        }
    }

    public void reset() {
        this.threads.set(0);
        this.maxThreads.set(0);
        this.queue.reset();
    }

    public int getMaxActiveThreads() {
        return this.maxThreads.get();
    }

    public int getMaxQueueSize() {
        return this.queue.getMaxSize();
    }

    public long getAverageQueueLatency() {
        return this.queue.getAverageLatency();
    }

    public long getMaxQueueLatency() {
        return this.queue.getMaxLatency();
    }
}

