/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.benchmark.Atomics;
import org.cometd.benchmark.MonitoringThreadPoolExecutor;

/*
 * Exception performing whole class analysis ignored.
 */
public class MonitoringThreadPoolExecutor
extends ThreadPoolExecutor {
    private final ConcurrentMap<Runnable, Long> tasks = new ConcurrentHashMap();
    private final AtomicLong taskCount = new AtomicLong();
    private final AtomicLong maxLatency = new AtomicLong();
    private final AtomicLong totalLatency = new AtomicLong();
    private final AtomicInteger threads = new AtomicInteger();
    private final AtomicInteger maxThreads = new AtomicInteger();

    public MonitoringThreadPoolExecutor(int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(maximumPoolSize, keepAliveTime, unit, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
    }

    public MonitoringThreadPoolExecutor(int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler) {
        super(maximumPoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new MonitoringLinkedBlockingQueue(null), handler);
    }

    public void reset() {
        ((MonitoringLinkedBlockingQueue)this.getQueue()).reset();
        this.tasks.clear();
        this.taskCount.set(0L);
        this.maxLatency.set(0L);
        this.totalLatency.set(0L);
        this.threads.set(0);
        this.maxThreads.set(0);
    }

    public long getMaxQueueLatency() {
        return this.maxLatency.get();
    }

    public long getAverageQueueLatency() {
        long count = this.taskCount.get();
        return count == 0L ? -1L : this.totalLatency.get() / count;
    }

    public int getMaxQueueSize() {
        return MonitoringLinkedBlockingQueue.access$100((MonitoringLinkedBlockingQueue)((MonitoringLinkedBlockingQueue)this.getQueue())).get();
    }

    public int getMaxActiveThreads() {
        return this.maxThreads.get();
    }

    public void execute(Runnable task) {
        Runnable runnable = task;
        long nanos = System.nanoTime();
        Long existing = this.tasks.putIfAbsent(runnable, nanos);
        if (existing != null) {
            runnable = new /* Unavailable Anonymous Inner Class!! */;
            this.tasks.put(runnable, nanos);
        }
        super.execute(runnable);
    }

    protected void beforeExecute(Thread thread, Runnable task) {
        long time = System.nanoTime() - (Long)this.tasks.remove(task);
        this.taskCount.incrementAndGet();
        Atomics.updateMax((AtomicLong)this.maxLatency, (long)time);
        this.totalLatency.addAndGet(time);
        Atomics.updateMax((AtomicInteger)this.maxThreads, (int)this.threads.incrementAndGet());
        super.beforeExecute(thread, task);
    }

    protected void afterExecute(Runnable r, Throwable t) {
        this.threads.decrementAndGet();
        super.afterExecute(r, t);
    }
}

