/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.benchmark.Atomics;
import org.cometd.benchmark.BayeuxLoadClient;
import org.cometd.benchmark.BenchmarkHelper;
import org.cometd.benchmark.MonitoringQueuedThreadPool;
import org.cometd.benchmark.SystemTimer;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.common.JacksonJSONContextClient;
import org.cometd.websocket.client.WebSocketTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.WebSocketClientFactory;
import org.eclipse.jetty.websocket.ZeroMaskGen;

/*
 * Exception performing whole class analysis ignored.
 */
public class BayeuxLoadClient {
    private final Random random = new Random();
    private final BenchmarkHelper helper = new BenchmarkHelper();
    private final List<LoadBayeuxClient> bayeuxClients = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<Integer, AtomicInteger> rooms = new ConcurrentHashMap();
    private final AtomicLong start = new AtomicLong();
    private final AtomicLong end = new AtomicLong();
    private final AtomicLong responses = new AtomicLong();
    private final AtomicLong messages = new AtomicLong();
    private final AtomicLong minWallLatency = new AtomicLong();
    private final AtomicLong maxWallLatency = new AtomicLong();
    private final AtomicLong totWallLatency = new AtomicLong();
    private final AtomicLong minLatency = new AtomicLong();
    private final AtomicLong maxLatency = new AtomicLong();
    private final AtomicLong totLatency = new AtomicLong();
    private final ConcurrentMap<Long, AtomicLong> wallLatencies = new ConcurrentHashMap();
    private final Map<String, AtomicStampedReference<Long>> sendTimes = new ConcurrentHashMap();
    private final Map<String, AtomicStampedReference<List<Long>>> arrivalTimes = new ConcurrentHashMap();
    private ScheduledExecutorService scheduler;
    private MonitoringQueuedThreadPool threadPool;
    private HttpClient httpClient;
    private WebSocketClientFactory webSocketClientFactory;

    public static void main(String[] args) throws Exception {
        BayeuxLoadClient client = new BayeuxLoadClient();
        client.run();
    }

    public long getResponses() {
        return this.responses.get();
    }

    public long getMessages() {
        return this.messages.get();
    }

    public void run() throws Exception {
        System.err.println("detecting timer resolution...");
        SystemTimer systemTimer = SystemTimer.detect();
        System.err.printf("native timer resolution: %d \u00b5s%n", systemTimer.getNativeResolution());
        System.err.printf("emulated timer resolution: %d \u00b5s%n", systemTimer.getEmulatedResolution());
        System.err.println();
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        String host = "localhost";
        System.err.printf("server [%s]: ", host);
        String value = console.readLine().trim();
        if (value.length() == 0) {
            value = host;
        }
        host = value;
        int port = 8080;
        System.err.printf("port [%d]: ", port);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(port);
        }
        port = Integer.parseInt(value);
        ClientTransportType clientTransportType = ClientTransportType.LONG_POLLING;
        System.err.printf("transports:%n", new Object[0]);
        for (ClientTransportType type : ClientTransportType.values()) {
            System.err.printf("  %d - %s%n", type.ordinal(), type.getName());
        }
        System.err.printf("transport [%d]: ", clientTransportType.ordinal());
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(clientTransportType.ordinal());
        }
        clientTransportType = ClientTransportType.values()[Integer.parseInt(value)];
        boolean ssl = false;
        System.err.printf("use ssl [%b]: ", ssl);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(ssl);
        }
        ssl = Boolean.parseBoolean(value);
        int maxThreads = 256;
        System.err.printf("max threads [%d]: ", maxThreads);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(maxThreads);
        }
        maxThreads = Integer.parseInt(value);
        String contextPath = "/cometd";
        System.err.printf("context [%s]: ", contextPath);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = contextPath;
        }
        String uri = value + "/cometd";
        String url = (ssl ? "https" : "http") + "://" + host + ":" + port + uri;
        String channel = "/chat/demo";
        System.err.printf("channel [%s]: ", channel);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = channel;
        }
        channel = value;
        int rooms = 100;
        System.err.printf("rooms [%d]: ", rooms);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(rooms);
        }
        rooms = Integer.parseInt(value);
        int roomsPerClient = 10;
        System.err.printf("rooms per client [%d]: ", roomsPerClient);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(roomsPerClient);
        }
        roomsPerClient = Integer.parseInt(value);
        boolean recordLatencyDetails = true;
        System.err.printf("record latency details [%b]: ", recordLatencyDetails);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(recordLatencyDetails);
        }
        recordLatencyDetails = Boolean.parseBoolean(value);
        this.scheduler = Executors.newScheduledThreadPool(8);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        mbContainer.start();
        mbContainer.addBean((Object)this);
        this.threadPool = new MonitoringQueuedThreadPool(maxThreads);
        this.threadPool.setDaemon(true);
        this.threadPool.start();
        mbContainer.addBean((Object)this.threadPool);
        this.httpClient = new HttpClient();
        this.httpClient.setMaxConnectionsPerAddress(50000);
        this.httpClient.setThreadPool((ThreadPool)this.threadPool);
        this.httpClient.setIdleTimeout(5000L);
        this.httpClient.start();
        mbContainer.addBean((Object)this.httpClient);
        this.webSocketClientFactory = new WebSocketClientFactory((ThreadPool)this.threadPool, (MaskGen)new ZeroMaskGen(), 8192);
        this.webSocketClientFactory.start();
        mbContainer.addBean((Object)this.webSocketClientFactory);
        HandshakeListener handshakeListener = new HandshakeListener(this, channel, rooms, roomsPerClient, null);
        DisconnectListener disconnectListener = new DisconnectListener(this, null);
        LatencyListener latencyListener = new LatencyListener(this, recordLatencyDetails);
        LoadBayeuxClient statsClient = new LoadBayeuxClient(this, url, this.scheduler, this.newClientTransport(clientTransportType), null, null);
        statsClient.handshake();
        AtomicLong ids = new AtomicLong();
        int clients = 100;
        int batchCount = 1000;
        int batchSize = 10;
        long batchPause = 10000L;
        int messageSize = 50;
        boolean randomize = false;
        while (true) {
            int maxRetries;
            int i;
            System.err.println("-----");
            System.err.printf("clients [%d]: ", clients);
            value = console.readLine();
            if (value == null) break;
            if ((value = value.trim()).length() == 0) {
                value = String.valueOf(clients);
            }
            clients = Integer.parseInt(value);
            System.err.println("Waiting for clients to be ready...");
            int currentClients = this.bayeuxClients.size();
            if (currentClients < clients) {
                for (i = 0; i < clients - currentClients; ++i) {
                    LoadBayeuxClient client = new LoadBayeuxClient(this, url, this.scheduler, this.newClientTransport(clientTransportType), (ClientSessionChannel.MessageListener)latencyListener, null);
                    client.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)handshakeListener);
                    client.getChannel("/meta/disconnect").addListener((ClientSessionChannel.ClientSessionChannelListener)disconnectListener);
                    client.handshake();
                    if (i % 10 != 0) continue;
                    Thread.sleep(50L);
                }
            } else if (currentClients > clients) {
                for (i = 0; i < currentClients - clients; ++i) {
                    LoadBayeuxClient client = (LoadBayeuxClient)this.bayeuxClients.get(currentClients - i - 1);
                    client.disconnect(1000L);
                }
            }
            int retries = maxRetries = 50;
            int lastSize = 0;
            int currentSize = this.bayeuxClients.size();
            while (currentSize != clients) {
                Thread.sleep(250L);
                System.err.printf("Waiting for clients %d/%d%n", currentSize, clients);
                if (lastSize == currentSize) {
                    if (--retries == 0) {
                        break;
                    }
                } else {
                    lastSize = currentSize;
                    retries = maxRetries;
                }
                currentSize = this.bayeuxClients.size();
            }
            if (currentSize != clients) {
                System.err.printf("Clients not ready, only %d/%d%n", currentSize, clients);
                break;
            }
            if (currentSize == 0) {
                System.err.println("All clients disconnected, exiting");
                break;
            }
            System.err.println("Clients ready");
            this.reset();
            System.err.printf("batch count [%d]: ", batchCount);
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(batchCount);
            }
            batchCount = Integer.parseInt(value);
            System.err.printf("batch size [%d]: ", batchSize);
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(batchSize);
            }
            batchSize = Integer.parseInt(value);
            System.err.printf("batch pause (\u00b5s) [%d]: ", batchPause);
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(batchPause);
            }
            batchPause = Long.parseLong(value);
            System.err.printf("message size [%d]: ", messageSize);
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(messageSize);
            }
            messageSize = Integer.parseInt(value);
            String chat = "";
            for (int i2 = 0; i2 < messageSize; ++i2) {
                chat = chat + "x";
            }
            System.err.printf("randomize sends [%b]: ", randomize);
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = String.valueOf(randomize);
            }
            randomize = Boolean.parseBoolean(value);
            statsClient.begin();
            this.helper.startStatistics();
            System.err.printf("Testing %d clients in %d rooms, %d rooms/client%n", this.bayeuxClients.size(), rooms, roomsPerClient);
            System.err.printf("Sending %d batches of %dx%d bytes messages every %d \u00b5s%n", batchCount, batchSize, messageSize, batchPause);
            long start = System.nanoTime();
            int clientIndex = -1;
            long expected = 0L;
            for (int i3 = 0; i3 < batchCount; ++i3) {
                if (randomize) {
                    clientIndex = this.nextRandom(this.bayeuxClients.size());
                } else if (++clientIndex >= this.bayeuxClients.size()) {
                    clientIndex = 0;
                }
                LoadBayeuxClient client = (LoadBayeuxClient)this.bayeuxClients.get(clientIndex);
                client.startBatch();
                for (int b = 0; b < batchSize; ++b) {
                    int room = -1;
                    AtomicInteger clientsPerRoom = null;
                    while (clientsPerRoom == null || clientsPerRoom.get() == 0) {
                        room = this.nextRandom(rooms);
                        clientsPerRoom = (AtomicInteger)this.rooms.get(room);
                    }
                    HashMap<String, Object> message = new HashMap<String, Object>(5);
                    message.put("room", room);
                    message.put("user", clientIndex);
                    message.put("chat", chat);
                    message.put("start", System.nanoTime());
                    message.put("ID", String.valueOf(ids.incrementAndGet()));
                    ClientSessionChannel clientChannel = client.getChannel(channel + "/" + room);
                    clientChannel.publish(message);
                    clientChannel.release();
                    expected += (long)clientsPerRoom.get();
                }
                client.endBatch();
                if (batchPause <= 0L) continue;
                systemTimer.sleep(batchPause);
            }
            long end = System.nanoTime();
            this.helper.stopStatistics();
            long elapsedNanos = end - start;
            if (elapsedNanos > 0L) {
                System.err.printf("Outgoing: Elapsed = %d ms | Rate = %d messages/s - %d requests/s - ~%.3f Mib/s%n", TimeUnit.NANOSECONDS.toMillis(elapsedNanos), (long)(batchCount * batchSize) * 1000L * 1000L * 1000L / elapsedNanos, (long)batchCount * 1000L * 1000L * 1000L / elapsedNanos, Float.valueOf((float)(batchCount * batchSize * messageSize) * 8.0f * 1000.0f * 1000.0f * 1000.0f / (float)elapsedNanos / 1024.0f / 1024.0f));
            }
            this.waitForMessages(expected);
            statsClient.end();
            this.printReport(expected, messageSize);
            this.reset();
        }
        statsClient.disconnect(1000L);
        this.webSocketClientFactory.stop();
        this.httpClient.stop();
        this.threadPool.stop();
        mbContainer.stop();
        this.scheduler.shutdown();
        this.scheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    private ClientTransport newClientTransport(ClientTransportType clientTransportType) {
        switch (1.$SwitchMap$org$cometd$benchmark$BayeuxLoadClient$ClientTransportType[clientTransportType.ordinal()]) {
            case 1: {
                HashMap<String, JacksonJSONContextClient> options = new HashMap<String, JacksonJSONContextClient>();
                options.put("jsonContext", new JacksonJSONContextClient());
                return new LongPollingTransport(options, this.httpClient);
            }
            case 2: {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("jsonContext", new JacksonJSONContextClient());
                options.put("idleTimeout", 35000);
                return new WebSocketTransport(options, this.webSocketClientFactory, this.scheduler);
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextRandom(int limit) {
        BayeuxLoadClient bayeuxLoadClient = this;
        synchronized (bayeuxLoadClient) {
            return this.random.nextInt(limit);
        }
    }

    private void updateLatencies(long startTime, long sendTime, long arrivalTime, long endTime, boolean recordDetails) {
        long wallLatency = TimeUnit.MICROSECONDS.toNanos(TimeUnit.NANOSECONDS.toMicros(endTime - startTime));
        long latency = TimeUnit.MICROSECONDS.toNanos(TimeUnit.NANOSECONDS.toMicros(arrivalTime - sendTime));
        Atomics.updateMin((AtomicLong)this.minWallLatency, (long)wallLatency);
        Atomics.updateMax((AtomicLong)this.maxWallLatency, (long)wallLatency);
        this.totWallLatency.addAndGet(wallLatency);
        Atomics.updateMin((AtomicLong)this.minLatency, (long)latency);
        Atomics.updateMax((AtomicLong)this.maxLatency, (long)latency);
        this.totLatency.addAndGet(latency);
        if (recordDetails) {
            AtomicLong count = (AtomicLong)this.wallLatencies.get(wallLatency);
            if (count == null) {
                count = new AtomicLong();
                AtomicLong existing = this.wallLatencies.putIfAbsent(wallLatency, count);
                if (existing != null) {
                    count = existing;
                }
            }
            count.incrementAndGet();
        }
    }

    private boolean waitForMessages(long expected) throws InterruptedException {
        int maxRetries;
        long arrived = this.messages.get();
        long lastArrived = 0L;
        int retries = maxRetries = 20;
        while (arrived < expected) {
            System.err.printf("Waiting for messages to arrive %d/%d%n", arrived, expected);
            Thread.sleep(500L);
            if (lastArrived == arrived) {
                if (--retries == 0) {
                    break;
                }
            } else {
                lastArrived = arrived;
                retries = maxRetries;
            }
            arrived = this.messages.get();
        }
        if (arrived < expected) {
            System.err.printf("Interrupting wait for messages %d/%d%n", arrived, expected);
            return false;
        }
        System.err.printf("All messages arrived %d/%d%n", arrived, expected);
        return true;
    }

    public void printReport(long expectedCount, int messageSize) {
        long messageCount = this.messages.get();
        System.err.printf("Messages - Success/Expected = %d/%d%n", messageCount, expectedCount);
        long elapsedNanos = this.end.get() - this.start.get();
        if (elapsedNanos > 0L) {
            System.err.printf("Incoming - Elapsed = %d ms | Rate = %d messages/s - %d responses/s(%.2f%%) - ~%.3f Mib/s%n", TimeUnit.NANOSECONDS.toMillis(elapsedNanos), messageCount * 1000L * 1000L * 1000L / elapsedNanos, this.responses.get() * 1000L * 1000L * 1000L / elapsedNanos, Float.valueOf(100.0f * (float)this.responses.get() / (float)messageCount), Float.valueOf((float)(messageCount * (long)messageSize) * 8.0f * 1000.0f * 1000.0f * 1000.0f / (float)elapsedNanos / 1024.0f / 1024.0f));
        }
        if (this.wallLatencies.size() > 1) {
            TreeMap sortedWallLatencies = new TreeMap(this.wallLatencies);
            this.wallLatencies.clear();
            long messages = 0L;
            long maxLatencyBucketFrequency = 0L;
            long previousLatency = 0L;
            long latencyAt50thPercentile = 0L;
            long latencyAt99thPercentile = 0L;
            long[] latencyBucketFrequencies = new long[20];
            long minWallLatency = this.minWallLatency.get();
            long latencyRange = this.maxWallLatency.get() - minWallLatency;
            Iterator entries = sortedWallLatencies.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                long latency = (Long)entry.getKey();
                Long bucketIndex = latencyRange == 0L ? 0L : (latency - minWallLatency) * (long)latencyBucketFrequencies.length / latencyRange;
                int index = bucketIndex.intValue() == latencyBucketFrequencies.length ? latencyBucketFrequencies.length - 1 : bucketIndex.intValue();
                long value = ((AtomicLong)entry.getValue()).get();
                messages += value;
                int n = index;
                latencyBucketFrequencies[n] = latencyBucketFrequencies[n] + value;
                if (latencyBucketFrequencies[index] > maxLatencyBucketFrequency) {
                    maxLatencyBucketFrequency = latencyBucketFrequencies[index];
                }
                if (latencyAt50thPercentile == 0L && messages > messageCount / 2L) {
                    latencyAt50thPercentile = (previousLatency + latency) / 2L;
                }
                if (latencyAt99thPercentile == 0L && messages > messageCount - messageCount / 100L) {
                    latencyAt99thPercentile = (previousLatency + latency) / 2L;
                }
                previousLatency = latency;
                entries.remove();
            }
            if (messages != messageCount) {
                System.err.printf("Counted messages (%d) != Latency messages sum (%d)%n", messageCount, messages);
            }
            System.err.println("Messages - Wall Latency Distribution Curve (X axis: Frequency, Y axis: Latency):");
            double percentile = 0.0;
            for (int i = 0; i < latencyBucketFrequencies.length; ++i) {
                int j;
                int value;
                long latencyBucketFrequency = latencyBucketFrequencies[i];
                int n = value = maxLatencyBucketFrequency == 0L ? 0 : Math.round((float)latencyBucketFrequency * (float)latencyBucketFrequencies.length / (float)maxLatencyBucketFrequency);
                if (value == latencyBucketFrequencies.length) {
                    --value;
                }
                for (j = 0; j < value; ++j) {
                    System.err.print(" ");
                }
                System.err.print("@");
                for (j = value + 1; j < latencyBucketFrequencies.length; ++j) {
                    System.err.print(" ");
                }
                System.err.print("  _  ");
                double percentage = 100.0 * (double)latencyBucketFrequency / (double)messages;
                System.err.print(TimeUnit.NANOSECONDS.toMillis(latencyRange * (long)(i + 1) / (long)latencyBucketFrequencies.length + minWallLatency));
                System.err.printf(" ms (%d, %.2f%%)", latencyBucketFrequency, percentage);
                double last = percentile;
                percentile += percentage;
                if (last < 50.0 && percentile >= 50.0) {
                    System.err.print(" ^50%");
                }
                if (last < 85.0 && percentile >= 85.0) {
                    System.err.print(" ^85%");
                }
                if (last < 95.0 && percentile >= 95.0) {
                    System.err.print(" ^95%");
                }
                if (last < 99.0 && percentile >= 99.0) {
                    System.err.print(" ^99%");
                }
                if (last < 99.9 && percentile >= 99.9) {
                    System.err.print(" ^99.9%");
                }
                System.err.println();
            }
            System.err.printf("Messages - Wall Latency 50th%%/99th%% = %d/%d ms%n", TimeUnit.NANOSECONDS.toMillis(latencyAt50thPercentile), TimeUnit.NANOSECONDS.toMillis(latencyAt99thPercentile));
        }
        System.err.printf("Messages - Wall Latency Min/Ave/Max = %d/%d/%d ms%n", TimeUnit.NANOSECONDS.toMillis(this.minWallLatency.get()), messageCount == 0L ? -1L : TimeUnit.NANOSECONDS.toMillis(this.totWallLatency.get() / messageCount), TimeUnit.NANOSECONDS.toMillis(this.maxWallLatency.get()));
        System.err.printf("Messages - Network Latency Min/Ave/Max = %d/%d/%d ms%n", TimeUnit.NANOSECONDS.toMillis(this.minLatency.get()), messageCount == 0L ? -1L : TimeUnit.NANOSECONDS.toMillis(this.totLatency.get() / messageCount), TimeUnit.NANOSECONDS.toMillis(this.maxLatency.get()));
        System.err.printf("Thread Pool - Tasks = %d | Concurrent Threads max = %d | Queue Size max = %d | Queue Latency avg/max = %d/%d ms%n", this.threadPool.getTasks(), this.threadPool.getMaxActiveThreads(), this.threadPool.getMaxQueueSize(), TimeUnit.NANOSECONDS.toMillis(this.threadPool.getAverageQueueLatency()), TimeUnit.NANOSECONDS.toMillis(this.threadPool.getMaxQueueLatency()));
    }

    private void reset() {
        this.threadPool.reset();
        this.start.set(0L);
        this.end.set(0L);
        this.responses.set(0L);
        this.messages.set(0L);
        this.minWallLatency.set(Long.MAX_VALUE);
        this.maxWallLatency.set(0L);
        this.totWallLatency.set(0L);
        this.minLatency.set(Long.MAX_VALUE);
        this.maxLatency.set(0L);
        this.totLatency.set(0L);
        this.wallLatencies.clear();
        this.sendTimes.clear();
        this.arrivalTimes.clear();
    }

    static /* synthetic */ List access$300(BayeuxLoadClient x0) {
        return x0.bayeuxClients;
    }

    static /* synthetic */ int access$600(BayeuxLoadClient x0, int x1) {
        return x0.nextRandom(x1);
    }

    static /* synthetic */ AtomicLong access$800(BayeuxLoadClient x0) {
        return x0.start;
    }

    static /* synthetic */ AtomicLong access$900(BayeuxLoadClient x0) {
        return x0.end;
    }

    static /* synthetic */ AtomicLong access$1000(BayeuxLoadClient x0) {
        return x0.messages;
    }

    static /* synthetic */ Map access$1100(BayeuxLoadClient x0) {
        return x0.sendTimes;
    }

    static /* synthetic */ Map access$1200(BayeuxLoadClient x0) {
        return x0.arrivalTimes;
    }

    static /* synthetic */ void access$1300(BayeuxLoadClient x0, long x1, long x2, long x3, long x4, boolean x5) {
        x0.updateLatencies(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ ConcurrentMap access$1400(BayeuxLoadClient x0) {
        return x0.rooms;
    }

    static /* synthetic */ AtomicLong access$1500(BayeuxLoadClient x0) {
        return x0.responses;
    }
}

