/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.benchmark.BayeuxLoadServer;
import org.cometd.benchmark.MonitoringQueuedThreadPool;
import org.cometd.benchmark.MonitoringThreadPoolExecutor;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometdServlet;
import org.cometd.server.JacksonJSONContextServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;

public class BayeuxLoadServer {
    public static void main(String[] args) throws Exception {
        BayeuxLoadServer server = new BayeuxLoadServer();
        server.run();
    }

    public void run() throws Exception {
        SelectChannelConnector connector;
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        int port = 8080;
        System.err.printf("listen port [%d]: ", port);
        String value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(port);
        }
        port = Integer.parseInt(value);
        boolean ssl = false;
        System.err.printf("use ssl [%b]: ", ssl);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(ssl);
        }
        ssl = Boolean.parseBoolean(value);
        int acceptors = Runtime.getRuntime().availableProcessors();
        System.err.printf("acceptors [%d]: ", acceptors);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(acceptors);
        }
        acceptors = Integer.parseInt(value);
        int maxThreads = 256;
        System.err.printf("max threads [%d]: ", maxThreads);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(maxThreads);
        }
        maxThreads = Integer.parseInt(value);
        boolean stats = true;
        System.err.printf("record statistics [%b]: ", stats);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(stats);
        }
        stats = Boolean.parseBoolean(value);
        boolean reqs = true;
        System.err.printf("record latencies [%b]: ", reqs);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(reqs);
        }
        reqs = Boolean.parseBoolean(value);
        boolean qos = false;
        System.err.printf("detect long requests [%b]: ", qos);
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = String.valueOf(qos);
        }
        qos = Boolean.parseBoolean(value);
        Server server = new Server();
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.getContainer().addEventListener((Container.Listener)mbContainer);
        server.addBean((Object)mbContainer);
        if (ssl) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            File keyStoreFile = new File("src/main/resources/keystore.jks");
            if (!keyStoreFile.exists()) {
                throw new FileNotFoundException(keyStoreFile.getAbsolutePath());
            }
            SslContextFactory sslContextFactory = sslConnector.getSslContextFactory();
            sslContextFactory.setKeyStorePath(keyStoreFile.getAbsolutePath());
            sslContextFactory.setKeyStorePassword("storepwd");
            sslContextFactory.setKeyManagerPassword("keypwd");
            connector = sslConnector;
        } else {
            connector = new SelectChannelConnector();
        }
        connector.setAcceptQueueSize(2048);
        connector.setMaxIdleTime(240000);
        connector.setAcceptors(acceptors);
        connector.setPort(port);
        server.addConnector((Connector)connector);
        MonitoringQueuedThreadPool jettyThreadPool = new MonitoringQueuedThreadPool(maxThreads);
        server.setThreadPool((ThreadPool)jettyThreadPool);
        Server handler = server;
        RequestLatencyHandler requestLatencyHandler = null;
        if (reqs) {
            requestLatencyHandler = new RequestLatencyHandler(null);
            handler.setHandler((Handler)requestLatencyHandler);
            handler = requestLatencyHandler;
        }
        if (qos) {
            RequestQoSHandler requestQoSHandler = new RequestQoSHandler(null);
            handler.setHandler((Handler)requestQoSHandler);
            handler = requestQoSHandler;
        }
        StatisticsHandler statisticsHandler = null;
        if (stats) {
            statisticsHandler = new StatisticsHandler();
            handler.setHandler((Handler)statisticsHandler);
            handler = statisticsHandler;
        }
        String contextPath = "";
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)handler, contextPath, 1);
        context.addServlet(DefaultServlet.class, "/");
        String cometServletPath = "/cometd";
        CometdServlet cometServlet = new CometdServlet();
        ServletHolder cometdServletHolder = new ServletHolder((Servlet)cometServlet);
        cometdServletHolder.setInitParameter("maxInterval", String.valueOf(60000));
        cometdServletHolder.setInitParameter("timeout", String.valueOf(30000));
        cometdServletHolder.setInitParameter("jsonContext", JacksonJSONContextServer.class.getName());
        context.addServlet(cometdServletHolder, cometServletPath + "/*");
        server.start();
        BayeuxServerImpl bayeux = cometServlet.getBayeux();
        MonitoringThreadPoolExecutor websocketThreadPool = new MonitoringThreadPoolExecutor(maxThreads, (long)jettyThreadPool.getMaxIdleTimeMs(), TimeUnit.MILLISECONDS, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        LoadWebSocketTransport webSocketTransport = new LoadWebSocketTransport(bayeux, (Executor)websocketThreadPool);
        webSocketTransport.init();
        bayeux.addTransport((ServerTransport)webSocketTransport);
        bayeux.setAllowedTransports(new String[]{"websocket", "long-polling"});
        new StatisticsService((BayeuxServer)bayeux, jettyThreadPool, websocketThreadPool, statisticsHandler, requestLatencyHandler, null);
    }
}

