/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import javax.servlet.Servlet;
import org.cometd.annotation.AnnotationCometDServlet;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.examples.CometDDemoServlet;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.DefaultSecurityPolicy;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class CometDDemo {
    public static void main(String[] args) throws Exception {
        int port = args.length == 0 ? 8080 : Integer.parseInt(args[0]);
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setMinThreads(5);
        qtp.setMaxThreads(200);
        Server server = new Server((ThreadPool)qtp);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(port);
        connector.setIdleTimeout(120000L);
        connector.setAcceptQueueSize(5000);
        server.addConnector((Connector)connector);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath("src/main/resources/keystore.jks");
        sslContextFactory.setKeyStorePassword("OBF:1vny1zlo1x8e1vnw1vn61x8g1zlu1vn4");
        sslContextFactory.setKeyManagerPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
        sslContextFactory.setTrustStorePath("src/main/resources/keystore.jks");
        sslContextFactory.setTrustStorePassword("OBF:1vny1zlo1x8e1vnw1vn61x8g1zlu1vn4");
        ServerConnector sslConnector = new ServerConnector(server, sslContextFactory);
        sslConnector.setPort(port - 80 + 443);
        server.addConnector((Connector)connector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        context.setBaseResource((Resource)new ResourceCollection(new Resource[]{Resource.newResource((String)"../../cometd-demo/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/common/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/jquery/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/examples-jquery/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/dojo/src/main/webapp/"), Resource.newResource((String)"../../cometd-javascript/examples-dojo/src/main/webapp/"), Resource.newResource((String)"../../cometd-demo/target/war/work/org.cometd.javascript/cometd-javascript-dojo/"), Resource.newResource((String)"../../cometd-demo/target/war/work/org.cometd.javascript/cometd-javascript-jquery/")}));
        ServletHolder dftServlet = context.addServlet(DefaultServlet.class, "/");
        dftServlet.setInitOrder(1);
        AnnotationCometDServlet cometdServlet = new AnnotationCometDServlet();
        ServletHolder comet = new ServletHolder((Servlet)cometdServlet);
        context.addServlet(comet, "/cometd/*");
        comet.setInitParameter("timeout", "20000");
        comet.setInitParameter("interval", "100");
        comet.setInitParameter("maxInterval", "10000");
        comet.setInitParameter("multiSessionInterval", "5000");
        comet.setInitParameter("services", "org.cometd.examples.ChatService");
        comet.setInitOrder(2);
        ServletHolder demo = context.addServlet(CometDDemoServlet.class, "/demo");
        demo.setInitOrder(3);
        server.start();
        BayeuxServerImpl bayeux = cometdServlet.getBayeux();
        bayeux.setSecurityPolicy((SecurityPolicy)new DefaultSecurityPolicy());
        if (Boolean.getBoolean("LAZY")) {
            bayeux.addExtension((BayeuxServer.Extension)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Boolean.getBoolean("LAZYCHAT")) {
            String channelName = "/chat/demo";
            ServerChannel chat_demo = (ServerChannel)bayeux.createChannelIfAbsent(channelName, new ConfigurableServerChannel.Initializer[0]).getReference();
            chat_demo.setLazy(true);
            chat_demo.setPersistent(true);
        }
    }
}

