/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.examples.ConsoleChatClient;
import org.eclipse.jetty.client.HttpClient;

public class ConsoleChatClient {
    private volatile String nickname = "";
    private volatile BayeuxClient client;
    private final ChatListener chatListener = new ChatListener(this, null);
    private final MembersListener membersListener = new MembersListener(this, null);

    public static void main(String[] args) throws Exception {
        ConsoleChatClient client = new ConsoleChatClient();
        client.run();
    }

    private void run() throws Exception {
        HashMap<String, String> data;
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String defaultURL = "http://localhost:8080/cometd/cometd";
        System.err.printf("Enter Bayeux Server URL [%s]: ", defaultURL);
        String url = input.readLine();
        if (url == null) {
            return;
        }
        if (url.trim().length() == 0) {
            url = defaultURL;
        }
        while (this.nickname.trim().length() == 0) {
            System.err.printf("Enter nickname: ", new Object[0]);
            this.nickname = input.readLine();
            if (this.nickname != null) continue;
            return;
        }
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        this.client = new BayeuxClient(url, (ClientTransport)new LongPollingTransport(null, httpClient), new ClientTransport[0]);
        this.client.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new InitializerListener(this, null));
        this.client.getChannel("/meta/connect").addListener((ClientSessionChannel.ClientSessionChannelListener)new ConnectionListener(this, null));
        this.client.handshake();
        boolean success = this.client.waitFor(1000L, BayeuxClient.State.CONNECTED, new BayeuxClient.State[0]);
        if (!success) {
            System.err.printf("Could not handshake with server at %s%n", url);
            return;
        }
        while (true) {
            String text;
            if ((text = input.readLine()) == null || "\\q".equals(text)) break;
            data = new HashMap();
            data.put("user", this.nickname);
            data.put("chat", text);
            this.client.getChannel("/chat/demo").publish(data);
        }
        data = new HashMap<String, String>();
        data.put("user", this.nickname);
        data.put("membership", "leave");
        data.put("chat", this.nickname + " has left");
        this.client.getChannel("/chat/demo").publish(data);
        this.client.disconnect(1000L);
    }

    private void initialize() {
        this.client.batch((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void connectionEstablished() {
        System.err.printf("system: Connection to Server Opened%n", new Object[0]);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("user", this.nickname);
        data.put("room", "/chat/demo");
        this.client.getChannel("/service/members").publish(data);
    }

    private void connectionClosed() {
        System.err.printf("system: Connection to Server Closed%n", new Object[0]);
    }

    private void connectionBroken() {
        System.err.printf("system: Connection to Server Broken%n", new Object[0]);
    }

    static /* synthetic */ BayeuxClient access$400(ConsoleChatClient x0) {
        return x0.client;
    }

    static /* synthetic */ ChatListener access$500(ConsoleChatClient x0) {
        return x0.chatListener;
    }

    static /* synthetic */ MembersListener access$600(ConsoleChatClient x0) {
        return x0.membersListener;
    }

    static /* synthetic */ String access$700(ConsoleChatClient x0) {
        return x0.nickname;
    }

    static /* synthetic */ void access$800(ConsoleChatClient x0) {
        x0.initialize();
    }

    static /* synthetic */ void access$900(ConsoleChatClient x0) {
        x0.connectionClosed();
    }

    static /* synthetic */ void access$1000(ConsoleChatClient x0) {
        x0.connectionEstablished();
    }

    static /* synthetic */ void access$1100(ConsoleChatClient x0) {
        x0.connectionBroken();
    }
}

