/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.AbstractTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.JSONContextServer;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerTransport
extends AbstractTransport
implements ServerTransport,
Dumpable {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_INTERVAL_OPTION = "maxInterval";
    public static final String MAX_PROCESSING_OPTION = "maxProcessing";
    public static final String MAX_LAZY_TIMEOUT_OPTION = "maxLazyTimeout";
    public static final String META_CONNECT_DELIVERY_OPTION = "metaConnectDeliverOnly";
    public static final String MAX_QUEUE_OPTION = "maxQueue";
    public static final String JSON_CONTEXT_OPTION = "jsonContext";
    public static final String HANDSHAKE_RECONNECT_OPTION = "handshakeReconnect";
    public static final String ALLOW_MESSAGE_DELIVERY_DURING_HANDSHAKE = "allowMessageDeliveryDuringHandshake";
    public static final String MAX_MESSAGE_SIZE_OPTION = "maxMessageSize";
    protected final Logger _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final BayeuxServerImpl _bayeux;
    private long _interval = 0L;
    private long _maxInterval = 10000L;
    private long _timeout = 30000L;
    private long _maxLazyTimeout = 5000L;
    private boolean _metaConnectDeliveryOnly = false;
    private JSONContextServer _jsonContext;
    private boolean _handshakeReconnect;
    private boolean _allowHandshakeDelivery;
    private int _maxMessageSize;

    protected AbstractServerTransport(BayeuxServerImpl bayeux, String name) {
        super(name, bayeux.getOptions());
        this._bayeux = bayeux;
    }

    public long getInterval() {
        return this._interval;
    }

    public long getMaxInterval() {
        return this._maxInterval;
    }

    public long getMaxLazyTimeout() {
        return this._maxLazyTimeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDeliveryOnly;
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDeliveryOnly = meta;
    }

    public boolean isHandshakeReconnect() {
        return this._handshakeReconnect;
    }

    public void setHandshakeReconnect(boolean handshakeReconnect) {
        this._handshakeReconnect = handshakeReconnect;
    }

    public boolean isAllowMessageDeliveryDuringHandshake() {
        return this._allowHandshakeDelivery;
    }

    public void setAllowMessageDeliveryDuringHandshake(boolean allow) {
        this._allowHandshakeDelivery = allow;
    }

    public int getMaxMessageSize() {
        return this._maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this._maxMessageSize = maxMessageSize;
    }

    public void init() {
        this._interval = this.getOption(INTERVAL_OPTION, this._interval);
        this._maxInterval = this.getOption(MAX_INTERVAL_OPTION, this._maxInterval);
        this._timeout = this.getOption(TIMEOUT_OPTION, this._timeout);
        this._maxLazyTimeout = this.getOption(MAX_LAZY_TIMEOUT_OPTION, this._maxLazyTimeout);
        this._metaConnectDeliveryOnly = this.getOption(META_CONNECT_DELIVERY_OPTION, this._metaConnectDeliveryOnly);
        this._jsonContext = (JSONContextServer)this.getOption(JSON_CONTEXT_OPTION);
        this._handshakeReconnect = this.getOption(HANDSHAKE_RECONNECT_OPTION, false);
        this._allowHandshakeDelivery = this.getOption(ALLOW_MESSAGE_DELIVERY_DURING_HANDSHAKE, false);
        this._maxMessageSize = this.getOption(MAX_MESSAGE_SIZE_OPTION, -1);
    }

    public void destroy() {
    }

    protected ServerMessage.Mutable[] parseMessages(BufferedReader reader, boolean jsonDebug) throws ParseException, IOException {
        if (jsonDebug || this.getMaxMessageSize() > 0) {
            return this.parseMessages(this.read(reader));
        }
        return (ServerMessage.Mutable[])this._jsonContext.parse(reader);
    }

    public ServerMessage.Mutable[] parseMessages(String json) throws ParseException {
        return (ServerMessage.Mutable[])this._jsonContext.parse(json);
    }

    private String read(BufferedReader reader) throws IOException {
        int read;
        int maxMessageSize = this.getMaxMessageSize();
        StringBuilder builder = new StringBuilder();
        int total = 0;
        char[] buffer = new char[1024];
        while ((read = reader.read(buffer)) >= 0) {
            if (maxMessageSize > 0 && (total += read) > maxMessageSize) {
                throw new IOException("Max message size " + maxMessageSize + " exceeded");
            }
            builder.append(buffer, 0, read);
        }
        return builder.toString();
    }

    public BayeuxServerImpl getBayeux() {
        return this._bayeux;
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    public void setMaxInterval(long maxInterval) {
        this._maxInterval = maxInterval;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public void setMaxLazyTimeout(long maxLazyTimeout) {
        this._maxLazyTimeout = maxLazyTimeout;
    }

    protected void sweep() {
    }

    public void processReply(ServerSessionImpl session, ServerMessage.Mutable reply, Promise<ServerMessage.Mutable> promise) {
        this.getBayeux().extendReply(session, session, reply, promise);
    }

    protected String toJSON(ServerMessage msg) {
        return this.toJSON((ServerMessageImpl)((Object)(msg instanceof ServerMessageImpl ? msg : this._bayeux.newMessage(msg))));
    }

    private String toJSON(ServerMessageImpl message) {
        String json = message.getJSON();
        if (json == null) {
            json = this._jsonContext.generate((Message.Mutable)message);
        }
        return json;
    }

    public boolean allowMessageDeliveryDuringHandshake(ServerSessionImpl session) {
        return session != null && session.isAllowMessageDeliveryDuringHandshake();
    }

    public void scheduleExpiration(ServerSessionImpl session) {
        if (session != null) {
            session.scheduleExpiration(this.getInterval(), this.getMaxInterval());
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObject((Appendable)out, (Object)((Object)this));
    }

    public String toString() {
        return this.getName();
    }

    public static interface Scheduler {
        public void schedule();

        public void cancel();

        public void destroy();
    }
}

