/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.AsyncFoldLeft;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.DefaultSecurityPolicy;
import org.cometd.server.JSONContextServer;
import org.cometd.server.JettyJSONContextServer;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.http.AbstractHttpTransport;
import org.cometd.server.http.AsyncJSONTransport;
import org.cometd.server.http.JSONPTransport;
import org.cometd.server.http.JSONTransport;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="The CometD server")
public class BayeuxServerImpl
extends AbstractLifeCycle
implements BayeuxServer,
Dumpable {
    private static final boolean[] VALID;
    public static final String ALLOWED_TRANSPORTS_OPTION = "allowedTransports";
    public static final String SWEEP_PERIOD_OPTION = "sweepPeriod";
    public static final String TRANSPORTS_OPTION = "transports";
    public static final String VALIDATE_MESSAGE_FIELDS_OPTION = "validateMessageFields";
    public static final String BROADCAST_TO_PUBLISHER_OPTION = "broadcastToPublisher";
    private final Logger _logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Integer.toHexString(System.identityHashCode((Object)this))));
    private final SecureRandom _random = new SecureRandom();
    private final List<BayeuxServer.BayeuxServerListener> _listeners = new CopyOnWriteArrayList<BayeuxServer.BayeuxServerListener>();
    private final List<BayeuxServer.Extension> _extensions = new CopyOnWriteArrayList<BayeuxServer.Extension>();
    private final ConcurrentMap<String, ServerSessionImpl> _sessions = new ConcurrentHashMap<String, ServerSessionImpl>();
    private final ConcurrentMap<String, ServerChannelImpl> _channels = new ConcurrentHashMap<String, ServerChannelImpl>();
    private final Map<String, ServerTransport> _transports = new LinkedHashMap<String, ServerTransport>();
    private final List<String> _allowedTransports = new ArrayList<String>();
    private final Map<String, Object> _options = new TreeMap<String, Object>();
    private final Scheduler _scheduler = new ScheduledExecutorScheduler("BayeuxServer@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "-Scheduler", false);
    private SecurityPolicy _policy = new DefaultSecurityPolicy();
    private JSONContextServer _jsonContext;
    private boolean _validation;
    private boolean _broadcastToPublisher;
    private boolean _detailedDump;

    protected void doStart() throws Exception {
        super.doStart();
        this.initializeMetaChannels();
        this.initializeJSONContext();
        this.initializeServerTransports();
        this._scheduler.start();
        long defaultSweepPeriod = 997L;
        long sweepPeriodOption = this.getOption(SWEEP_PERIOD_OPTION, defaultSweepPeriod);
        if (sweepPeriodOption < 0L) {
            sweepPeriodOption = defaultSweepPeriod;
        }
        final long sweepPeriod = sweepPeriodOption;
        this.schedule(new Runnable(){

            @Override
            public void run() {
                BayeuxServerImpl.this.sweep();
                BayeuxServerImpl.this.schedule(this, sweepPeriod);
            }
        }, sweepPeriod);
        this._validation = this.getOption(VALIDATE_MESSAGE_FIELDS_OPTION, true);
        this._broadcastToPublisher = this.getOption(BROADCAST_TO_PUBLISHER_OPTION, true);
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (String allowedTransportName : this.getAllowedTransports()) {
            ServerTransport transport = this.getTransport(allowedTransportName);
            if (!(transport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)transport).destroy();
        }
        this._listeners.clear();
        this._extensions.clear();
        this._sessions.clear();
        this._channels.clear();
        this._transports.clear();
        this._allowedTransports.clear();
        this._options.clear();
        this._scheduler.stop();
    }

    protected void initializeMetaChannels() {
        this.createChannelIfAbsent("/meta/handshake", new ConfigurableServerChannel.Initializer[0]);
        this.createChannelIfAbsent("/meta/connect", new ConfigurableServerChannel.Initializer[0]);
        this.createChannelIfAbsent("/meta/subscribe", new ConfigurableServerChannel.Initializer[0]);
        this.createChannelIfAbsent("/meta/unsubscribe", new ConfigurableServerChannel.Initializer[0]);
        this.createChannelIfAbsent("/meta/disconnect", new ConfigurableServerChannel.Initializer[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeJSONContext() throws Exception {
        Object option = this.getOption("jsonContext");
        if (option == null) {
            this._jsonContext = new JettyJSONContextServer();
        } else if (option instanceof String) {
            Class<?> jsonContextClass = Thread.currentThread().getContextClassLoader().loadClass((String)option);
            if (!JSONContextServer.class.isAssignableFrom(jsonContextClass)) throw new IllegalArgumentException("Invalid " + JSONContextServer.class.getName() + " implementation class");
            this._jsonContext = (JSONContextServer)jsonContextClass.newInstance();
        } else {
            if (!(option instanceof JSONContextServer)) throw new IllegalArgumentException("Invalid " + JSONContextServer.class.getName() + " implementation class");
            this._jsonContext = (JSONContextServer)option;
        }
        this._options.put("jsonContext", this._jsonContext);
    }

    protected void initializeServerTransports() {
        String option;
        if (this._transports.isEmpty()) {
            option = (String)this.getOption(TRANSPORTS_OPTION);
            if (option == null) {
                ServerTransport transport = this.newWebSocketTransport();
                if (transport != null) {
                    this.addTransport(transport);
                }
                this.addTransport(this.newJSONTransport());
                this.addTransport(new JSONPTransport(this));
            } else {
                for (String className : option.split(",")) {
                    ServerTransport transport = this.newServerTransport(className.trim());
                    if (transport == null) continue;
                    this.addTransport(transport);
                }
                if (this._transports.isEmpty()) {
                    throw new IllegalArgumentException("Option 'transports' does not contain a valid list of server transport class names");
                }
            }
        }
        if (this._allowedTransports.isEmpty()) {
            option = (String)this.getOption(ALLOWED_TRANSPORTS_OPTION);
            if (option == null) {
                this._allowedTransports.addAll(this._transports.keySet());
            } else {
                for (String transportName : option.split(",")) {
                    if (!this._transports.containsKey(transportName)) continue;
                    this._allowedTransports.add(transportName);
                }
                if (this._allowedTransports.isEmpty()) {
                    throw new IllegalArgumentException("Option 'allowedTransports' does not contain at least one configured server transport name");
                }
            }
        }
        ArrayList<String> activeTransports = new ArrayList<String>();
        for (String transportName : this._allowedTransports) {
            ServerTransport serverTransport = this.getTransport(transportName);
            if (!(serverTransport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)serverTransport).init();
            activeTransports.add(serverTransport.getName());
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Active transports: {}", activeTransports);
        }
    }

    private ServerTransport newWebSocketTransport() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            loader.loadClass("javax.websocket.server.ServerContainer");
            String transportClass = "org.cometd.server.websocket.javax.WebSocketTransport";
            ServerTransport transport = this.newServerTransport(transportClass);
            if (transport == null) {
                this._logger.info("JSR 356 WebSocket classes available, but " + transportClass + " unavailable: JSR 356 WebSocket transport disabled");
            }
            return transport;
        }
        catch (Exception x) {
            return null;
        }
    }

    private ServerTransport newJSONTransport() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            loader.loadClass("javax.servlet.ReadListener");
            return new AsyncJSONTransport(this);
        }
        catch (Exception x) {
            return new JSONTransport(this);
        }
    }

    private ServerTransport newServerTransport(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> klass = loader.loadClass(className);
            Constructor<?> constructor = klass.getConstructor(BayeuxServerImpl.class);
            return (ServerTransport)constructor.newInstance(new Object[]{this});
        }
        catch (Exception x) {
            return null;
        }
    }

    public Scheduler.Task schedule(Runnable task, long delay) {
        return this._scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public ChannelId newChannelId(String id) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(id);
        if (channel != null) {
            return channel.getChannelId();
        }
        return new ChannelId(id);
    }

    public Map<String, Object> getOptions() {
        return this._options;
    }

    @ManagedOperation(value="The value of the given configuration option", impact="INFO")
    public Object getOption(@Name(value="optionName") String qualifiedName) {
        return this._options.get(qualifiedName);
    }

    protected long getOption(String name, long dft) {
        Object val = this.getOption(name);
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return Long.parseLong(val.toString());
    }

    protected boolean getOption(String name, boolean dft) {
        Object value = this.getOption(name);
        if (value == null) {
            return dft;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public Set<String> getOptionNames() {
        return this._options.keySet();
    }

    public void setOption(String qualifiedName, Object value) {
        this._options.put(qualifiedName, value);
    }

    public void setOptions(Map<String, Object> options) {
        this._options.putAll(options);
    }

    public long randomLong() {
        long value = this._random.nextLong();
        return value < 0L ? -value : value;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._policy;
    }

    public JSONContextServer getJSONContext() {
        return this._jsonContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkedReference<ServerChannel> createChannelIfAbsent(String channelName, ConfigurableServerChannel.Initializer ... initializers) {
        ChannelId channelId;
        boolean initialized = false;
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(channelName);
        if (channel == null) {
            channelId = new ChannelId(channelName);
            String id = channelId.getId();
            if (!id.equals(channelName)) {
                channelName = id;
                channel = (ServerChannelImpl)this._channels.get(channelName);
            }
        } else {
            channelId = channel.getChannelId();
        }
        if (channel == null) {
            ServerChannelImpl candidate = new ServerChannelImpl(this, channelId);
            channel = this._channels.putIfAbsent(channelName, candidate);
            if (channel == null) {
                channel = candidate;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Added channel {}", (Object)channel);
                }
                try {
                    for (ConfigurableServerChannel.Initializer initializer : initializers) {
                        this.notifyConfigureChannel(initializer, channel);
                    }
                    for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                        if (!(listener instanceof ConfigurableServerChannel.Initializer)) continue;
                        this.notifyConfigureChannel((ConfigurableServerChannel.Initializer)listener, channel);
                    }
                }
                finally {
                    channel.initialized();
                }
                for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                    if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                    this.notifyChannelAdded((BayeuxServer.ChannelListener)listener, channel);
                }
                initialized = true;
            }
        } else {
            channel.resetSweeperPasses();
            this._channels.putIfAbsent(channelName, channel);
        }
        channel.waitForInitialized();
        return new MarkedReference((Object)channel, initialized);
    }

    private void notifyConfigureChannel(ConfigurableServerChannel.Initializer listener, ServerChannel channel) {
        try {
            listener.configureChannel((ConfigurableServerChannel)channel);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    private void notifyChannelAdded(BayeuxServer.ChannelListener listener, ServerChannel channel) {
        try {
            listener.channelAdded(channel);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public List<ServerSession> getSessions() {
        return Collections.unmodifiableList(new ArrayList(this._sessions.values()));
    }

    public boolean removeSession(ServerSession session) {
        return this.removeSession(session, false).getReference() != null;
    }

    public ServerSession getSession(String clientId) {
        return clientId == null ? null : (ServerSession)this._sessions.get(clientId);
    }

    protected void addServerSession(ServerSessionImpl session, ServerMessage message) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Adding session {}", (Object)session);
        }
        this._sessions.put(session.getId(), session);
        for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
            if (!(listener instanceof BayeuxServer.SessionListener)) continue;
            this.notifySessionAdded((BayeuxServer.SessionListener)listener, session, message);
        }
        session.added();
    }

    private void notifySessionAdded(BayeuxServer.SessionListener listener, ServerSession session, ServerMessage message) {
        try {
            listener.sessionAdded(session, message);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public boolean removeServerSession(ServerSession session, boolean timedOut) {
        return this.removeSession(session, timedOut).isMarked();
    }

    private MarkedReference<ServerSessionImpl> removeSession(ServerSession session, boolean timedOut) {
        ServerSessionImpl removed;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Removing session {}, timed out: {}", (Object)session, (Object)timedOut);
        }
        if ((removed = (ServerSessionImpl)this._sessions.remove(session.getId())) != session) {
            return MarkedReference.empty();
        }
        for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
            if (!(listener instanceof BayeuxServer.SessionListener)) continue;
            this.notifySessionRemoved((BayeuxServer.SessionListener)listener, removed, timedOut);
        }
        boolean connected = removed.removed(timedOut);
        return new MarkedReference((Object)removed, connected);
    }

    private void notifySessionRemoved(BayeuxServer.SessionListener listener, ServerSession session, boolean timedout) {
        try {
            listener.sessionRemoved(session, timedout);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public ServerSessionImpl newServerSession() {
        return new ServerSessionImpl(this);
    }

    public LocalSession newLocalSession(String idHint) {
        return new LocalSessionImpl(this, idHint);
    }

    public ServerMessage.Mutable newMessage() {
        return new ServerMessageImpl();
    }

    public ServerMessage.Mutable newMessage(ServerMessage original) {
        ServerMessage.Mutable mutable = this.newMessage();
        mutable.putAll((Map)original);
        return mutable;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._policy = securityPolicy;
    }

    public void addExtension(BayeuxServer.Extension extension) {
        this._extensions.add(extension);
    }

    public void removeExtension(BayeuxServer.Extension extension) {
        this._extensions.remove(extension);
    }

    public List<BayeuxServer.Extension> getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    public void addListener(BayeuxServer.BayeuxServerListener listener) {
        Objects.requireNonNull(listener);
        this._listeners.add(listener);
    }

    public ServerChannel getChannel(String channelId) {
        return this.getServerChannel(channelId);
    }

    private ServerChannelImpl getServerChannel(String channelId) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(channelId);
        if (channel != null) {
            channel.waitForInitialized();
        }
        return channel;
    }

    public List<ServerChannel> getChannels() {
        ArrayList<ServerChannel> result = new ArrayList<ServerChannel>();
        for (ServerChannelImpl channel : this._channels.values()) {
            channel.waitForInitialized();
            result.add(channel);
        }
        return result;
    }

    public void removeListener(BayeuxServer.BayeuxServerListener listener) {
        this._listeners.remove(listener);
    }

    public void handle(ServerSessionImpl session, ServerMessage.Mutable message, Promise<ServerMessage.Mutable> promise) {
        String error;
        ServerMessageImpl reply = (ServerMessageImpl)this.createReply(message);
        if (this._validation && (error = this.validateMessage(message)) != null) {
            this.error(reply, error);
            promise.succeed((Object)reply);
            return;
        }
        this.extendIncoming(session, message, (Promise<Boolean>)Promise.from(extPass -> {
            if (extPass.booleanValue()) {
                if (session != null) {
                    session.extendIncoming(message, (Promise<Boolean>)Promise.from(sessExtPass -> {
                        if (sessExtPass.booleanValue()) {
                            this.handle1(session, message, promise);
                        } else {
                            if (!reply.isHandled()) {
                                this.error(reply, "404::message_deleted");
                            }
                            promise.succeed((Object)reply);
                        }
                    }, arg_0 -> ((Promise)promise).fail(arg_0)));
                } else {
                    this.handle1(null, message, promise);
                }
            } else {
                if (!reply.isHandled()) {
                    this.error(reply, "404::message_deleted");
                }
                promise.succeed((Object)reply);
            }
        }, arg_0 -> promise.fail(arg_0)));
    }

    private void handle1(ServerSessionImpl session, ServerMessage.Mutable message, Promise<ServerMessage.Mutable> promise) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(">  {} {}", (Object)message, (Object)session);
        }
        ServerMessage.Mutable reply = message.getAssociated();
        if (session == null || session.isDisconnected() || !session.getId().equals(message.getClientId()) && !"/meta/handshake".equals(message.getChannel())) {
            this.unknownSession(reply);
            promise.succeed((Object)reply);
        } else {
            String channelName = message.getChannel();
            session.cancelExpiration("/meta/connect".equals(channelName));
            if (channelName == null) {
                this.error(reply, "400::channel_missing");
                promise.succeed((Object)reply);
            } else {
                ServerChannelImpl channel = this.getServerChannel(channelName);
                if (channel == null) {
                    this.isCreationAuthorized(session, (ServerMessage)message, channelName, (Promise<Authorizer.Result>)Promise.from(result -> {
                        if (result instanceof Authorizer.Result.Denied) {
                            String denyReason = ((Authorizer.Result.Denied)result).getReason();
                            this.error(reply, "403:" + denyReason + ":channel_create_denied");
                            promise.succeed((Object)reply);
                        } else {
                            this.handle2(session, message, (ServerChannelImpl)this.createChannelIfAbsent(channelName, new ConfigurableServerChannel.Initializer[0]).getReference(), promise);
                        }
                    }, arg_0 -> promise.fail(arg_0)));
                } else {
                    this.handle2(session, message, channel, promise);
                }
            }
        }
    }

    private void handle2(ServerSessionImpl session, ServerMessage.Mutable message, ServerChannelImpl channel, Promise<ServerMessage.Mutable> promise) {
        ServerMessage.Mutable reply = message.getAssociated();
        if (channel.isMeta()) {
            this.publish(session, channel, message, true, (Promise<Boolean>)Promise.from(published -> promise.succeed((Object)reply), arg_0 -> promise.fail(arg_0)));
        } else {
            this.isPublishAuthorized(channel, session, (ServerMessage)message, (Promise<Authorizer.Result>)Promise.from(result -> {
                if (result instanceof Authorizer.Result.Denied) {
                    String denyReason = ((Authorizer.Result.Denied)result).getReason();
                    this.error(reply, "403:" + denyReason + ":publish_denied");
                    promise.succeed((Object)reply);
                } else {
                    reply.setSuccessful(true);
                    this.publish(session, channel, message, true, (Promise<Boolean>)Promise.from(published -> promise.succeed((Object)reply), arg_0 -> ((Promise)promise).fail(arg_0)));
                }
            }, arg_0 -> promise.fail(arg_0)));
        }
    }

    protected String validateMessage(ServerMessage.Mutable message) {
        String channel = message.getChannel();
        if (channel == null) {
            return "400::channel_missing";
        }
        if (!this.validate(channel)) {
            return "405::channel_invalid";
        }
        String id = message.getId();
        if (id != null && !this.validate(id)) {
            return "405::message_id_invalid";
        }
        return null;
    }

    private boolean validate(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c <= '\u007f' && VALID[c]) continue;
            return false;
        }
        return true;
    }

    private void isPublishAuthorized(ServerChannel channel, ServerSession session, ServerMessage message, Promise<Authorizer.Result> promise) {
        if (this._policy != null) {
            this._policy.canPublish((BayeuxServer)this, session, channel, message, Promise.from(can -> {
                if (can == null || can.booleanValue()) {
                    this.isOperationAuthorized(Authorizer.Operation.PUBLISH, session, message, channel.getChannelId(), promise);
                } else {
                    this._logger.info("{} denied publish on channel {} by {}", new Object[]{session, channel.getId(), this._policy});
                    promise.succeed((Object)Authorizer.Result.deny((String)"denied_by_security_policy"));
                }
            }, arg_0 -> promise.fail(arg_0)));
        } else {
            this.isOperationAuthorized(Authorizer.Operation.PUBLISH, session, message, channel.getChannelId(), promise);
        }
    }

    private void isSubscribeAuthorized(ServerChannel channel, ServerSession session, ServerMessage message, Promise<Authorizer.Result> promise) {
        if (this._policy != null) {
            this._policy.canSubscribe((BayeuxServer)this, session, channel, message, Promise.from(can -> {
                if (can == null || can.booleanValue()) {
                    this.isOperationAuthorized(Authorizer.Operation.SUBSCRIBE, session, message, channel.getChannelId(), promise);
                } else {
                    this._logger.info("{} denied Subscribe@{} by {}", new Object[]{session, channel, this._policy});
                    promise.succeed((Object)Authorizer.Result.deny((String)"denied_by_security_policy"));
                }
            }, arg_0 -> promise.fail(arg_0)));
        } else {
            this.isOperationAuthorized(Authorizer.Operation.SUBSCRIBE, session, message, channel.getChannelId(), promise);
        }
    }

    private void isCreationAuthorized(ServerSession session, ServerMessage message, String channel, Promise<Authorizer.Result> promise) {
        if (this._policy != null) {
            this._policy.canCreate((BayeuxServer)this, session, channel, message, Promise.from(can -> {
                if (can == null || can.booleanValue()) {
                    this.isOperationAuthorized(Authorizer.Operation.CREATE, session, message, new ChannelId(channel), promise);
                } else {
                    this._logger.info("{} denied creation of channel {} by {}", new Object[]{session, channel, this._policy});
                    promise.succeed((Object)Authorizer.Result.deny((String)"denied_by_security_policy"));
                }
            }, arg_0 -> promise.fail(arg_0)));
        } else {
            this.isOperationAuthorized(Authorizer.Operation.CREATE, session, message, new ChannelId(channel), promise);
        }
    }

    private void isOperationAuthorized(Authorizer.Operation operation, ServerSession session, ServerMessage message, ChannelId channelId, Promise<Authorizer.Result> promise) {
        this.isChannelOperationAuthorized(operation, session, message, channelId, (Promise<Authorizer.Result>)Promise.from(result -> {
            if (result == null) {
                result = Authorizer.Result.grant();
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("No authorizers, {} for channel {} {}", new Object[]{operation, channelId, result});
                }
            } else if (result.isGranted()) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("No authorizer denied {} for channel {}, authorization {}", new Object[]{operation, channelId, result});
                }
            } else if (!result.isDenied()) {
                result = Authorizer.Result.deny((String)"denied_by_not_granting");
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("No authorizer granted {} for channel {}, authorization {}", new Object[]{operation, channelId, result});
                }
            }
            promise.succeed(result);
        }, arg_0 -> promise.fail(arg_0)));
    }

    private void isChannelOperationAuthorized(Authorizer.Operation operation, ServerSession session, ServerMessage message, ChannelId channelId, Promise<Authorizer.Result> promise) {
        ArrayList<String> channels = new ArrayList<String>(channelId.getWilds());
        channels.add(channelId.getId());
        AsyncFoldLeft.run(channels, null, (result, channelName, loop) -> {
            ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(channelName);
            if (channel != null) {
                this.isChannelOperationAuthorized(channel, operation, session, message, channelId, (Promise<Authorizer.Result>)Promise.from(authz -> {
                    if (authz != null) {
                        if (authz.isDenied()) {
                            loop.leave(authz);
                        } else if (result == null || authz.isGranted()) {
                            loop.proceed(authz);
                        } else {
                            loop.proceed(result);
                        }
                    } else {
                        loop.proceed(result);
                    }
                }, arg_0 -> ((Promise)promise).fail(arg_0)));
            } else {
                loop.proceed(result);
            }
        }, promise);
    }

    private void isChannelOperationAuthorized(ServerChannelImpl channel, Authorizer.Operation operation, ServerSession session, ServerMessage message, ChannelId channelId, Promise<Authorizer.Result> promise) {
        List<Authorizer> authorizers = channel.authorizers();
        if (authorizers.isEmpty()) {
            promise.succeed(null);
        } else {
            AsyncFoldLeft.run(authorizers, (Object)Authorizer.Result.ignore(), (result, authorizer, loop) -> authorizer.authorize(operation, channelId, session, message, Promise.from(authorization -> {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Authorizer {} on channel {} {} {} for channel {}", new Object[]{authorizer, channel, authorization, operation, channelId});
                }
                if (authorization.isDenied()) {
                    loop.leave(authorization);
                } else if (authorization.isGranted()) {
                    loop.proceed(authorization);
                } else {
                    loop.proceed(result);
                }
            }, arg_0 -> ((Promise)promise).fail(arg_0))), promise);
        }
    }

    protected void publish(ServerSessionImpl session, ServerChannelImpl channel, ServerMessage.Mutable message, boolean receiving, Promise<Boolean> promise) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("<  {} {}", (Object)message, (Object)session);
        }
        if (channel.isBroadcast()) {
            message.setClientId(null);
            message.setId(null);
        }
        this.notifyListeners(session, channel, message, (Promise<Boolean>)Promise.from(proceed -> {
            if (proceed.booleanValue()) {
                this.publish1(session, channel, message, receiving, promise);
            } else {
                ServerMessageImpl reply = (ServerMessageImpl)message.getAssociated();
                if (reply != null && !reply.isHandled()) {
                    this.error(reply, "404::message_deleted");
                }
                promise.succeed((Object)false);
            }
        }, arg_0 -> promise.fail(arg_0)));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void publish1(ServerSessionImpl session, ServerChannelImpl channel, ServerMessage.Mutable message, boolean receiving, Promise<Boolean> promise) {
        if (!channel.isBroadcast() && receiving) {
            this.publish2(session, channel, message, promise);
            return;
        }
        this.extendOutgoing(session, null, message, (Promise<Boolean>)Promise.from(result -> {
            if (result.booleanValue()) {
                this.freeze(message);
                this.publish2(session, channel, message, promise);
            } else {
                ServerMessage.Mutable reply = message.getAssociated();
                this.error(reply, "404::message_deleted");
                promise.succeed((Object)false);
            }
        }, arg_0 -> promise.fail(arg_0)));
    }

    private void publish2(ServerSessionImpl session, ServerChannelImpl channel, ServerMessage.Mutable message, Promise<Boolean> promise) {
        if (channel.isMeta()) {
            this.notifyMetaHandlers(session, channel, message, promise);
        } else if (channel.isBroadcast()) {
            this.notifySubscribers(session, channel, message, promise);
        } else {
            promise.succeed((Object)true);
        }
    }

    private void notifySubscribers(ServerSessionImpl session, ServerChannelImpl channel, ServerMessage.Mutable message, Promise<Boolean> promise) {
        HashSet wildSubscribers = new HashSet();
        AsyncFoldLeft.run((Collection)channel.getChannelId().getWilds(), (Object)true, (result, wildName, wildLoop) -> {
            ServerChannelImpl wildChannel = (ServerChannelImpl)this._channels.get(wildName);
            if (wildChannel == null) {
                wildLoop.proceed(result);
            } else {
                Set<ServerSession> subscribers = wildChannel.subscribers();
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Notifying {} subscribers on {}", (Object)subscribers.size(), (Object)wildChannel);
                }
                AsyncFoldLeft.run(subscribers, (Object)true, (r, subscriber, loop) -> {
                    if (wildSubscribers.add(subscriber.getId())) {
                        if (subscriber == session && !channel.isBroadcastToPublisher()) {
                            loop.proceed((Object)true);
                        } else {
                            ((ServerSessionImpl)subscriber).deliver1(session, message, (Promise<Boolean>)Promise.from(b -> loop.proceed((Object)true), arg_0 -> ((AsyncFoldLeft.Loop)loop).fail(arg_0)));
                        }
                    } else {
                        loop.proceed(r);
                    }
                }, (Promise)Promise.from(y -> wildLoop.proceed((Object)true), arg_0 -> ((AsyncFoldLeft.Loop)wildLoop).fail(arg_0)));
            }
        }, (Promise)Promise.from(b -> {
            Set<ServerSession> subscribers = channel.subscribers();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Notifying {} subscribers on {}", (Object)subscribers.size(), (Object)channel);
            }
            AsyncFoldLeft.run(subscribers, (Object)true, (result, subscriber, loop) -> {
                if (!wildSubscribers.contains(subscriber.getId())) {
                    if (subscriber == session && !channel.isBroadcastToPublisher()) {
                        loop.proceed((Object)true);
                    } else {
                        ((ServerSessionImpl)subscriber).deliver1(session, message, (Promise<Boolean>)Promise.from(y -> loop.proceed((Object)true), arg_0 -> ((AsyncFoldLeft.Loop)loop).fail(arg_0)));
                    }
                } else {
                    loop.proceed((Object)true);
                }
            }, (Promise)promise);
        }, arg_0 -> promise.fail(arg_0)));
    }

    private void notifyListeners(ServerSessionImpl session, ServerChannelImpl channel, ServerMessage.Mutable message, Promise<Boolean> promise) {
        ArrayList<String> channels = new ArrayList<String>(channel.getChannelId().getWilds());
        channels.add(channel.getId());
        AsyncFoldLeft.run(channels, (Object)true, (channelResult, channelName, channelLoop) -> {
            ServerChannelImpl target = (ServerChannelImpl)this._channels.get(channelName);
            if (target == null) {
                channelLoop.proceed(channelResult);
            } else {
                if (target.isLazy()) {
                    message.setLazy(true);
                }
                List<ConfigurableServerChannel.ServerChannelListener> listeners = target.listeners();
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Notifying {} listeners on {}", (Object)listeners.size(), (Object)target);
                }
                AsyncFoldLeft.run(listeners, (Object)true, (result, listener, loop) -> {
                    if (listener instanceof ServerChannel.MessageListener) {
                        this.notifyOnMessage((ServerChannel.MessageListener)listener, session, channel, message, this.resolveLoop((AsyncFoldLeft.Loop<Boolean>)loop));
                    } else {
                        loop.proceed((Object)true);
                    }
                }, this.resolveLoop((AsyncFoldLeft.Loop<Boolean>)channelLoop));
            }
        }, promise);
    }

    protected Promise<Boolean> resolveLoop(AsyncFoldLeft.Loop<Boolean> loop) {
        return Promise.from(result -> {
            if (result.booleanValue()) {
                loop.proceed((Object)true);
            } else {
                loop.leave((Object)false);
            }
        }, arg_0 -> loop.fail(arg_0));
    }

    private void notifyMetaHandlers(ServerSessionImpl session, ServerChannelImpl channel, ServerMessage.Mutable message, Promise<Boolean> promise) {
        switch (channel.getId()) {
            case "/meta/handshake": {
                this.handleMetaHandshake(session, message, promise);
                break;
            }
            case "/meta/connect": {
                this.handleMetaConnect(session, message, promise);
                break;
            }
            case "/meta/subscribe": {
                this.handleMetaSubscribe(session, message, promise);
                break;
            }
            case "/meta/unsubscribe": {
                this.handleMetaUnsubscribe(session, message, promise);
                break;
            }
            case "/meta/disconnect": {
                this.handleMetaDisconnect(session, message, promise);
                break;
            }
            default: {
                promise.fail((Throwable)new IllegalStateException("Invalid channel " + channel));
            }
        }
    }

    public void freeze(ServerMessage.Mutable mutable) {
        if (mutable instanceof ServerMessageImpl) {
            ServerMessageImpl message = (ServerMessageImpl)mutable;
            if (message.isFrozen()) {
                return;
            }
            String json = this._jsonContext.generate((Message.Mutable)message);
            message.freeze(json);
        }
    }

    private void notifyOnMessage(ServerChannel.MessageListener listener, ServerSession from, ServerChannel to, ServerMessage.Mutable mutable, Promise<Boolean> promise) {
        try {
            listener.onMessage(from, to, mutable, Promise.from(r -> promise.succeed((Object)(r == null ? true : r)), failure -> {
                this._logger.info("Exception reported by listener " + listener, failure);
                promise.succeed((Object)true);
            }));
        }
        catch (Throwable x) {
            this._logger.info("Exception thrown by listener " + listener, x);
            promise.succeed((Object)true);
        }
    }

    private void extendIncoming(ServerSessionImpl session, ServerMessage.Mutable message, Promise<Boolean> promise) {
        AsyncFoldLeft.run(this._extensions, (Object)true, (result, extension, loop) -> {
            if (result.booleanValue()) {
                try {
                    extension.incoming((ServerSession)session, message, Promise.from(r -> {
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug("Extension {}: result {} for incoming message {}", new Object[]{extension, r, message});
                        }
                        loop.proceed((Object)(r == null ? true : r));
                    }, failure -> {
                        this._logger.info("Exception reported by extension " + extension, failure);
                        loop.proceed((Object)true);
                    }));
                }
                catch (Throwable x) {
                    this._logger.info("Exception thrown by extension " + extension, x);
                    loop.proceed((Object)true);
                }
            } else {
                loop.leave((Object)false);
            }
        }, promise);
    }

    protected void extendOutgoing(ServerSession sender, ServerSession session, ServerMessage.Mutable message, Promise<Boolean> promise) {
        ArrayList<BayeuxServer.Extension> extensions = new ArrayList<BayeuxServer.Extension>(this._extensions);
        Collections.reverse(extensions);
        AsyncFoldLeft.run(extensions, (Object)true, (result, extension, loop) -> {
            if (result.booleanValue()) {
                try {
                    extension.outgoing(sender, session, message, Promise.from(r -> loop.proceed((Object)(r == null ? true : r)), failure -> {
                        this._logger.info("Exception reported by extension " + extension, failure);
                        loop.proceed((Object)true);
                    }));
                }
                catch (Exception x) {
                    this._logger.info("Exception thrown by extension " + extension, (Throwable)x);
                    loop.proceed((Object)true);
                }
            } else {
                loop.leave((Object)false);
            }
        }, promise);
    }

    public void extendReply(ServerSessionImpl sender, ServerSessionImpl session, ServerMessage.Mutable reply, Promise<ServerMessage.Mutable> promise) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("<< {} {}", (Object)reply, (Object)sender);
        }
        this.extendOutgoing(sender, session, reply, (Promise<Boolean>)Promise.from(b -> {
            if (b.booleanValue()) {
                if (session != null) {
                    session.extendOutgoing(sender, reply, promise);
                } else {
                    promise.succeed((Object)reply);
                }
            } else {
                promise.succeed(null);
            }
        }, arg_0 -> promise.fail(arg_0)));
    }

    protected boolean removeServerChannel(ServerChannelImpl channel) {
        if (this._channels.remove(channel.getId(), channel)) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Removed channel {}", (Object)channel);
            }
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                this.notifyChannelRemoved((BayeuxServer.ChannelListener)listener, channel);
            }
            return true;
        }
        return false;
    }

    private void notifyChannelRemoved(BayeuxServer.ChannelListener listener, ServerChannelImpl channel) {
        try {
            listener.channelRemoved(channel.getId());
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    protected List<BayeuxServer.BayeuxServerListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    public Set<String> getKnownTransportNames() {
        return this._transports.keySet();
    }

    public ServerTransport getTransport(String transport) {
        return this._transports.get(transport);
    }

    public ServerTransport addTransport(ServerTransport transport) {
        ServerTransport result = this._transports.put(transport.getName(), transport);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Added transport {} from {}", (Object)transport.getName(), transport.getClass());
        }
        return result;
    }

    public void setTransports(ServerTransport ... transports) {
        this.setTransports(Arrays.asList(transports));
    }

    public void setTransports(List<ServerTransport> transports) {
        this._transports.clear();
        for (ServerTransport transport : transports) {
            this.addTransport(transport);
        }
    }

    public List<ServerTransport> getTransports() {
        return new ArrayList<ServerTransport>(this._transports.values());
    }

    protected AbstractHttpTransport findHttpTransport(HttpServletRequest request) {
        for (String transportName : this._allowedTransports) {
            AbstractHttpTransport transport;
            ServerTransport serverTransport = this.getTransport(transportName);
            if (!(serverTransport instanceof AbstractHttpTransport) || !(transport = (AbstractHttpTransport)serverTransport).accept(request)) continue;
            return transport;
        }
        return null;
    }

    @ManagedAttribute(value="The transports allowed by this server", readonly=true)
    public List<String> getAllowedTransports() {
        return Collections.unmodifiableList(this._allowedTransports);
    }

    public void setAllowedTransports(String ... allowed) {
        this.setAllowedTransports(Arrays.asList(allowed));
    }

    public void setAllowedTransports(List<String> allowed) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("setAllowedTransport {} of {}", allowed, this._transports);
        }
        this._allowedTransports.clear();
        for (String transport : allowed) {
            if (!this._transports.containsKey(transport)) continue;
            this._allowedTransports.add(transport);
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("allowedTransports {}", this._allowedTransports);
        }
    }

    @ManagedAttribute(value="Whether this server broadcast messages to the publisher", readonly=true)
    public boolean isBroadcastToPublisher() {
        return this._broadcastToPublisher;
    }

    protected void unknownSession(ServerMessage.Mutable reply) {
        this.error(reply, "402::session_unknown");
        if ("/meta/handshake".equals(reply.getChannel()) || "/meta/connect".equals(reply.getChannel())) {
            Map advice = reply.getAdvice(true);
            advice.put("reconnect", "handshake");
            advice.put("interval", 0L);
        }
    }

    protected void error(ServerMessage.Mutable reply, String error) {
        if (reply != null) {
            reply.put((Object)"error", (Object)error);
            reply.setSuccessful(false);
        }
    }

    protected ServerMessage.Mutable createReply(ServerMessage.Mutable message) {
        Object subscriptions;
        ServerMessageImpl reply = (ServerMessageImpl)this.newMessage();
        message.setAssociated((ServerMessage.Mutable)reply);
        reply.setAssociated(message);
        reply.setServerTransport(message.getServerTransport());
        reply.setBayeuxContext(message.getBayeuxContext());
        reply.setChannel(message.getChannel());
        String id = message.getId();
        if (id != null) {
            reply.setId(id);
        }
        if ((subscriptions = message.get((Object)"subscription")) != null) {
            reply.put("subscription", subscriptions);
        }
        return reply;
    }

    private boolean validateSubscriptions(List<String> subscriptions) {
        if (this._validation) {
            for (String subscription : subscriptions) {
                if (this.validate(subscription)) continue;
                return false;
            }
        }
        return true;
    }

    @ManagedOperation(value="Sweeps channels and sessions of this BayeuxServer", impact="ACTION")
    public void sweep() {
        for (ServerChannelImpl channel : this._channels.values()) {
            channel.sweep();
        }
        for (ServerTransport transport : this._transports.values()) {
            if (!(transport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)transport).sweep();
        }
        long now = System.nanoTime();
        for (ServerSessionImpl session : this._sessions.values()) {
            session.sweep(now);
        }
    }

    @ManagedAttribute(value="Reports additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailedDump = detailedDump;
    }

    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Object> children = new ArrayList<Object>();
        SecurityPolicy securityPolicy = this.getSecurityPolicy();
        if (securityPolicy != null) {
            children.add(securityPolicy);
        }
        List<String> transports = this._allowedTransports;
        if (this.isDetailedDump()) {
            transports = transports.stream().map(t -> this.getTransport((String)t)).collect(Collectors.toList());
        }
        children.add(new DumpableCollection(TRANSPORTS_OPTION, transports));
        if (this.isDetailedDump()) {
            children.add(new DumpableCollection("channels", new TreeMap<String, ServerChannelImpl>(this._channels).values()));
        } else {
            children.add("channels size=" + this._channels.size());
        }
        if (this.isDetailedDump()) {
            List<ServerSessionImpl> remote;
            Map<Boolean, List<ServerSessionImpl>> sessions = this._sessions.values().stream().collect(Collectors.groupingBy(ServerSessionImpl::isLocalSession));
            List<ServerSessionImpl> local = sessions.get(true);
            if (local != null) {
                children.add(new DumpableCollection("local sessions", local));
            }
            if ((remote = sessions.get(false)) != null) {
                children.add(new DumpableCollection("remote sessions", remote));
            }
        } else {
            children.add("sessions size=" + this._sessions.size());
        }
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])children.toArray());
    }

    private void handleMetaHandshake(ServerSessionImpl session, ServerMessage.Mutable message, Promise<Boolean> promise) {
        BayeuxContext context = message.getBayeuxContext();
        if (context != null) {
            session.setUserAgent(context.getHeader("User-Agent"));
        }
        if (this._policy != null) {
            this._policy.canHandshake((BayeuxServer)this, (ServerSession)session, (ServerMessage)message, Promise.from(can -> {
                if (can.booleanValue()) {
                    this.handleMetaHandshake1(session, message, promise);
                } else {
                    ServerMessage.Mutable reply = message.getAssociated();
                    this.error(reply, "403::handshake_denied");
                    Map advice = reply.getAdvice(true);
                    if (!advice.containsKey("reconnect")) {
                        advice.put("reconnect", "none");
                    }
                    promise.succeed((Object)false);
                }
            }, arg_0 -> promise.fail(arg_0)));
        } else {
            this.handleMetaHandshake1(session, message, promise);
        }
    }

    private void handleMetaHandshake1(ServerSessionImpl session, ServerMessage.Mutable message, Promise<Boolean> promise) {
        ServerMessage.Mutable reply = message.getAssociated();
        if (session.handshake(message)) {
            this.addServerSession(session, (ServerMessage)message);
            reply.setSuccessful(true);
            reply.setClientId(session.getId());
            reply.put((Object)"version", (Object)"1.0");
            reply.put((Object)"minimumVersion", (Object)"1.0");
            reply.put((Object)"supportedConnectionTypes", this.getAllowedTransports());
            Map<String, Object> adviceOut = session.takeAdvice(message.getServerTransport());
            reply.put((Object)"advice", adviceOut);
            promise.succeed((Object)true);
        } else {
            this.error(reply, "403::handshake_failed");
            promise.succeed((Object)false);
        }
    }

    private void handleMetaConnect(ServerSessionImpl session, ServerMessage.Mutable message, Promise<Boolean> promise) {
        ServerMessage.Mutable reply = message.getAssociated();
        if (session.connected()) {
            reply.setSuccessful(true);
            Map adviceIn = message.getAdvice();
            if (adviceIn != null) {
                Number timeout = (Number)adviceIn.get("timeout");
                session.updateTransientTimeout(timeout == null ? -1L : timeout.longValue());
                Number interval = (Number)adviceIn.get("interval");
                session.updateTransientInterval(interval == null ? -1L : interval.longValue());
                session.reAdvise();
            } else {
                session.updateTransientTimeout(-1L);
                session.updateTransientInterval(-1L);
            }
            Map<String, Object> adviceOut = session.takeAdvice(message.getServerTransport());
            if (adviceOut != null) {
                reply.put((Object)"advice", adviceOut);
            }
            promise.succeed((Object)true);
        } else {
            this.unknownSession(reply);
            promise.succeed((Object)false);
        }
    }

    private void handleMetaSubscribe(ServerSessionImpl session, ServerMessage.Mutable message, Promise<Boolean> promise) {
        ServerMessage.Mutable reply = message.getAssociated();
        Object subscriptionField = message.get((Object)"subscription");
        if (subscriptionField == null) {
            this.error(reply, "403::subscription_missing");
            promise.succeed((Object)false);
        } else {
            List<String> subscriptions = BayeuxServerImpl.toChannelList(subscriptionField);
            if (subscriptions == null) {
                this.error(reply, "403::subscription_invalid");
                promise.succeed((Object)false);
            } else if (!this.validateSubscriptions(subscriptions)) {
                this.error(reply, "403::subscription_invalid");
                promise.succeed((Object)false);
            } else {
                AsyncFoldLeft.run(subscriptions, (Object)true, (result, subscription, loop) -> {
                    ServerChannelImpl channel = this.getServerChannel((String)subscription);
                    if (channel == null) {
                        this.isCreationAuthorized(session, (ServerMessage)message, (String)subscription, (Promise<Authorizer.Result>)Promise.from(creationResult -> {
                            if (creationResult instanceof Authorizer.Result.Denied) {
                                String denyReason = ((Authorizer.Result.Denied)creationResult).getReason();
                                this.error(reply, "403:" + denyReason + ":create_denied");
                                loop.leave((Object)false);
                            } else {
                                this.handleMetaSubscribe1(session, message, (ServerChannelImpl)this.createChannelIfAbsent((String)subscription, new ConfigurableServerChannel.Initializer[0]).getReference(), this.resolveLoop((AsyncFoldLeft.Loop<Boolean>)loop));
                            }
                        }, arg_0 -> ((Promise)promise).fail(arg_0)));
                    } else {
                        this.handleMetaSubscribe1(session, message, channel, this.resolveLoop((AsyncFoldLeft.Loop<Boolean>)loop));
                    }
                }, promise);
            }
        }
    }

    private void handleMetaSubscribe1(ServerSessionImpl session, ServerMessage.Mutable message, ServerChannelImpl channel, Promise<Boolean> promise) {
        ServerMessage.Mutable reply = message.getAssociated();
        this.isSubscribeAuthorized(channel, session, (ServerMessage)message, (Promise<Authorizer.Result>)Promise.from(subscribeResult -> {
            if (subscribeResult instanceof Authorizer.Result.Denied) {
                String denyReason = ((Authorizer.Result.Denied)subscribeResult).getReason();
                this.error(reply, "403:" + denyReason + ":subscribe_denied");
                promise.succeed((Object)false);
            } else if (channel.subscribe(session, (ServerMessage)message)) {
                reply.setSuccessful(true);
                promise.succeed((Object)true);
            } else {
                this.error(reply, "403::subscribe_failed");
                promise.succeed((Object)false);
            }
        }, arg_0 -> promise.fail(arg_0)));
    }

    private void handleMetaUnsubscribe(ServerSessionImpl session, ServerMessage.Mutable message, Promise<Boolean> promise) {
        ServerMessage.Mutable reply = message.getAssociated();
        Object subscriptionField = message.get((Object)"subscription");
        if (subscriptionField == null) {
            this.error(reply, "403::subscription_missing");
            promise.succeed((Object)false);
        } else {
            List<String> subscriptions = BayeuxServerImpl.toChannelList(subscriptionField);
            if (subscriptions == null) {
                this.error(reply, "403::subscription_invalid");
                promise.succeed((Object)false);
            } else if (!this.validateSubscriptions(subscriptions)) {
                this.error(reply, "403::subscription_invalid");
                promise.succeed((Object)false);
            } else {
                AsyncFoldLeft.run(subscriptions, (Object)true, (result, subscription, loop) -> {
                    ServerChannelImpl channel = this.getServerChannel((String)subscription);
                    if (channel == null) {
                        this.error(reply, "400::channel_missing");
                        loop.leave((Object)false);
                    } else if (channel.unsubscribe(session, (ServerMessage)message)) {
                        reply.setSuccessful(true);
                        loop.proceed((Object)true);
                    } else {
                        this.error(reply, "403::unsubscribe_failed");
                        loop.leave((Object)false);
                    }
                }, promise);
            }
        }
    }

    private void handleMetaDisconnect(ServerSessionImpl session, ServerMessage.Mutable message, Promise<Boolean> promise) {
        ServerMessage.Mutable reply = message.getAssociated();
        reply.setSuccessful(true);
        this.removeServerSession(session, false);
        session.flush();
        promise.succeed((Object)true);
    }

    private static List<String> toChannelList(Object channels) {
        if (channels instanceof String) {
            return Collections.singletonList((String)channels);
        }
        if (channels instanceof Object[]) {
            Object[] array = (Object[])channels;
            ArrayList<String> channelList = new ArrayList<String>();
            for (Object o : array) {
                channelList.add(String.valueOf(o));
            }
            return channelList;
        }
        if (channels instanceof List) {
            List list = (List)channels;
            ArrayList<String> channelList = new ArrayList<String>();
            for (Object o : list) {
                channelList.add(String.valueOf(o));
            }
            return channelList;
        }
        return null;
    }

    static {
        int i;
        VALID = new boolean[256];
        BayeuxServerImpl.VALID[32] = true;
        BayeuxServerImpl.VALID[33] = true;
        BayeuxServerImpl.VALID[35] = true;
        BayeuxServerImpl.VALID[36] = true;
        BayeuxServerImpl.VALID[40] = true;
        BayeuxServerImpl.VALID[41] = true;
        BayeuxServerImpl.VALID[42] = true;
        BayeuxServerImpl.VALID[43] = true;
        BayeuxServerImpl.VALID[45] = true;
        BayeuxServerImpl.VALID[46] = true;
        BayeuxServerImpl.VALID[47] = true;
        BayeuxServerImpl.VALID[64] = true;
        BayeuxServerImpl.VALID[95] = true;
        BayeuxServerImpl.VALID[123] = true;
        BayeuxServerImpl.VALID[126] = true;
        BayeuxServerImpl.VALID[125] = true;
        for (i = 48; i <= 57; ++i) {
            BayeuxServerImpl.VALID[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            BayeuxServerImpl.VALID[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            BayeuxServerImpl.VALID[i] = true;
        }
    }
}

